/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.base.DexException;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.ins.ExceptionHandler;
import com.reandroid.dex.ins.ExceptionLabel;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.TryItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexCatch;
import com.reandroid.dex.model.DexCode;
import com.reandroid.dex.model.DexInstruction;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.FilterIterator;
import java.io.IOException;
import java.util.Iterator;

public class DexTry
extends DexCode {
    private final DexMethod dexMethod;
    private final TryItem tryItem;
    private final int address;

    public DexTry(DexMethod dexMethod, TryItem tryItem, int address) {
        this.dexMethod = dexMethod;
        this.tryItem = tryItem;
        this.address = address;
    }

    public DexTry(DexMethod dexMethod, TryItem tryItem) {
        this(dexMethod, tryItem, -1);
    }

    public DexInstruction getFirst() {
        return CollectionUtil.getFirst(this.getInstructions());
    }

    public void setFirst(DexInstruction instruction) {
        this.setStartAddress(instruction.getAddress());
    }

    public DexInstruction getLast() {
        return CollectionUtil.getLast(this.getInstructions());
    }

    public void setLast(DexInstruction instruction) {
        this.setEndAddress(instruction.getAddress() + instruction.getCodeUnits());
    }

    public Iterator<DexInstruction> getInstructions() {
        InstructionList instructionList = this.getDexMethod().getDefinition().getInstructionList();
        if (instructionList == null) {
            return EmptyIterator.of();
        }
        Iterator<Ins> iterator = FilterIterator.of(instructionList.iterator(), ins -> {
            int address = ins.getAddress();
            return address >= this.getStartAddress() && address < this.getEndAddress();
        });
        return DexInstruction.create(this.getDexMethod(), iterator);
    }

    public int getStartAddress() {
        return this.getTryItem().getStartAddress();
    }

    public void setStartAddress(int address) {
        this.getTryItem().setStartAddress(address);
    }

    public int getEndAddress() {
        TryItem tryItem = this.getTryItem();
        return tryItem.getStartAddress() + tryItem.getCatchCodeUnit();
    }

    public void setEndAddress(int address) {
        TryItem tryItem = this.getTryItem();
        int start = tryItem.getStartAddress();
        if (address < start) {
            throw new DexException("Invalid try end address " + address + "<" + start);
        }
        this.getTryItem().setCatchCodeUnit(address - start);
    }

    public DexCatch getCatchAll() {
        return this.create(this.getTryItem().getCatchAllHandler());
    }

    public DexCatch getOrCreateCatchAll() {
        TryItem tryItem = this.getTryItem();
        boolean hasCatchAll = tryItem.hasCatchAllHandler();
        DexCatch dexCatch = this.create(this.getTryItem().getOrCreateCatchAll());
        if (!hasCatchAll) {
            dexCatch.setCatchAddress(this.getEndAddress());
        }
        return dexCatch;
    }

    public DexCatch getCatch(TypeKey typeKey) {
        return this.create(this.getTryItem().getExceptionHandler(typeKey));
    }

    public int getCatchCount() {
        TryItem tryItem = this.getTryItem();
        int count = 0;
        if (tryItem.hasCatchAllHandler()) {
            count = 1;
        }
        return count += tryItem.getCatchTypedHandlersCount();
    }

    public Iterator<DexCatch> getCatches() {
        return this.getCatches(this.address);
    }

    public Iterator<DexCatch> getCatches(int address) {
        return ComputeIterator.of(this.getTryItem().getExceptionHandlersForAddress(address), this::create);
    }

    public boolean trapsCatchAll() {
        return this.traps(null, this.address);
    }

    public boolean trapsCatchAll(int address) {
        return this.traps(null, address);
    }

    public boolean traps(TypeKey typeKey) {
        return this.traps(typeKey, this.address);
    }

    public boolean traps(TypeKey typeKey, int address) {
        return this.getTryItem().traps(typeKey, address);
    }

    DexCatch create(ExceptionHandler handler) {
        if (handler != null) {
            return new DexCatch(this, handler);
        }
        return null;
    }

    @Override
    public void removeSelf() {
        this.getTryItem().removeSelf();
    }

    public TryItem getTryItem() {
        return this.tryItem;
    }

    @Override
    public boolean uses(Key key) {
        Iterator<DexCatch> iterator = this.getCatches();
        while (iterator.hasNext()) {
            DexCatch dexCatch = iterator.next();
            if (!dexCatch.uses(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DexMethod getDexMethod() {
        return this.dexMethod;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        ExceptionLabel label;
        TryItem tryItem = this.getTryItem();
        Iterator<ExceptionHandler> handlers = tryItem.getExceptionHandlers();
        if (!handlers.hasNext()) {
            writer.appendComment("Empty try-catch");
            writer.newLine();
            return;
        }
        ExceptionLabel previous = null;
        while (handlers.hasNext()) {
            ExceptionLabel label2 = handlers.next().getStartLabel();
            if (label2.isEqualExtraLine(previous)) continue;
            previous = label2;
            writer.newLine();
            label2.appendExtra(writer);
        }
        writer.indentPlus();
        Iterator<DexInstruction> instructions = this.getInstructions();
        writer.appendAll(instructions, true);
        writer.indentMinus();
        handlers = tryItem.getExceptionHandlers();
        previous = null;
        while (handlers.hasNext()) {
            label = handlers.next().getEndLabel();
            if (label.isEqualExtraLine(previous)) continue;
            previous = label;
            writer.newLine();
            label.appendExtra(writer);
        }
        handlers = tryItem.getExceptionHandlers();
        while (handlers.hasNext()) {
            label = handlers.next().getHandlerLabel();
            writer.newLine();
            label.appendExtra(writer);
        }
    }

    public static Iterator<DexTry> create(DexMethod dexMethod, Iterator<TryItem> iterator) {
        return DexTry.create(dexMethod, -1, iterator);
    }

    public static Iterator<DexTry> create(DexMethod dexMethod, int address, Iterator<TryItem> iterator) {
        if (dexMethod == null) {
            return EmptyIterator.of();
        }
        return ComputeIterator.of(iterator, tryItem -> DexTry.create(dexMethod, tryItem, address));
    }

    public static DexTry create(DexMethod dexMethod, TryItem tryItem) {
        return DexTry.create(dexMethod, tryItem, -1);
    }

    public static DexTry create(DexMethod dexMethod, TryItem tryItem, int address) {
        if (dexMethod == null || tryItem == null) {
            return null;
        }
        return new DexTry(dexMethod, tryItem, address);
    }
}

