/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.common.ArraySupplier;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.model.DexLayout;
import com.reandroid.dex.sections.DexContainerBlock;
import com.reandroid.dex.sections.DexLayoutBlock;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.ArraySupplierIterator;
import java.util.Iterator;
import java.util.List;

class DexFileLayoutController
implements DexContainerBlock.LayoutBlockChangedListener,
ArraySupplier<DexLayout>,
Iterable<DexLayout> {
    private final DexFile dexFile;
    private final List<DexLayout> dexLayoutList;
    private boolean sortRequired;

    public DexFileLayoutController(DexFile dexFile) {
        this.dexFile = dexFile;
        this.dexLayoutList = new ArrayCollection<DexLayout>();
    }

    @Override
    public Iterator<DexLayout> iterator() {
        return ArraySupplierIterator.of(this);
    }

    @Override
    public DexLayout get(int i) {
        return this.get((DexLayoutBlock)this.getContainerBlock().get(i));
    }

    @Override
    public int getCount() {
        return this.getContainerBlock().size();
    }

    private DexLayout get(DexLayoutBlock layoutBlock) {
        Object dexLayout;
        if (layoutBlock == null) {
            return null;
        }
        int index = layoutBlock.getIndex();
        List<DexLayout> dexLayoutList = this.dexLayoutList;
        if (index > 0 && index < dexLayoutList.size() && (dexLayout = dexLayoutList.get(index)) != null && ((DexLayout)dexLayout).getDexLayoutBlock() == layoutBlock) {
            return dexLayout;
        }
        for (DexLayout layout : dexLayoutList) {
            if (layoutBlock != layout.getDexLayoutBlock()) continue;
            this.sortRequired = true;
            return layout;
        }
        DexLayout layout = new DexLayout(this.dexFile, layoutBlock);
        dexLayoutList.add(layout);
        return layout;
    }

    private DexContainerBlock getContainerBlock() {
        return this.dexFile.getContainerBlock();
    }

    public void refreshController() {
        if (!this.sortRequired) {
            return;
        }
        DexContainerBlock containerBlock = this.getContainerBlock();
        List<DexLayout> dexLayoutList = this.dexLayoutList;
        for (int i = 0; i < dexLayoutList.size(); ++i) {
            DexLayout layout = dexLayoutList.get(i);
            if (containerBlock.containsExact(layout.getDexLayoutBlock())) continue;
            dexLayoutList.remove(i);
            --i;
        }
        dexLayoutList.sort((layout1, layout2) -> CompareUtil.compare(layout1.getIndex(), layout2.getIndex()));
    }

    @Override
    public void onLayoutRemoved(DexLayoutBlock layoutBlock) {
        List<DexLayout> dexLayoutList = this.dexLayoutList;
        int size = dexLayoutList.size();
        for (int i = 0; i < size; ++i) {
            DexLayout layout = dexLayoutList.get(i);
            if (layout.getDexLayoutBlock() != layoutBlock) continue;
            dexLayoutList.remove(i);
            break;
        }
    }

    @Override
    public void onLayoutAdded(DexLayoutBlock layoutBlock) {
        this.get(layoutBlock);
    }

    @Override
    public void onLayoutsCleared() {
        this.dexLayoutList.clear();
    }
}

