/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassModule;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexDirectory;
import com.reandroid.dex.model.DexFileInfo;
import com.reandroid.dex.model.DexFileLayoutController;
import com.reandroid.dex.model.DexInstruction;
import com.reandroid.dex.model.DexLayout;
import com.reandroid.dex.model.DexMergeOptions;
import com.reandroid.dex.model.DexSource;
import com.reandroid.dex.sections.DexContainerBlock;
import com.reandroid.dex.sections.MergeOptions;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.io.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class DexFile
implements Closeable,
DexClassRepository,
Iterable<DexLayout> {
    private final DexContainerBlock containerBlock;
    private final DexFileLayoutController layoutController;
    private DexDirectory dexDirectory;
    private boolean closed;

    public DexFile(DexContainerBlock containerBlock) {
        this.containerBlock = containerBlock;
        this.layoutController = new DexFileLayoutController(this);
        containerBlock.setLayoutBlockChangedListener(this.layoutController);
    }

    public boolean isMultiLayout() {
        return this.getContainerBlock().isMultiLayout();
    }

    @Override
    public Iterator<DexLayout> iterator() {
        return this.layoutController.iterator();
    }

    public Iterator<DexLayout> clonedIterator() {
        return this.layoutController.iterator();
    }

    public DexLayout getOrCreateFirst() {
        return this.getOrCreateAt(0);
    }

    public DexLayout getOrCreateAt(int index) {
        this.getContainerBlock().ensureSize(index + 1);
        return this.getLayout(index);
    }

    public DexLayout getFirst() {
        return this.layoutController.get(0);
    }

    public DexLayout getLayout(int i) {
        return this.layoutController.get(i);
    }

    public int size() {
        return this.getContainerBlock().size();
    }

    public boolean isEmpty() {
        return this.getContainerBlock().isEmpty();
    }

    public int getIndex() {
        DexDirectory directory = this.getDexDirectory();
        if (directory != null) {
            return directory.indexOf(this);
        }
        return -1;
    }

    @Override
    public int getVersion() {
        return this.getContainerBlock().getVersion();
    }

    @Override
    public void setVersion(int version) {
        this.getContainerBlock().setVersion(version);
    }

    public String getSimpleName() {
        return this.getContainerBlock().getSimpleName();
    }

    public void setSimpleName(String simpleName) {
        this.getContainerBlock().setSimpleName(simpleName);
    }

    public DexSource<DexFile> getSource() {
        DexDirectory directory = this.getDexDirectory();
        if (directory != null) {
            return directory.getDexSourceSet().getSource(this);
        }
        return null;
    }

    public DexDirectory getDexDirectory() {
        return this.dexDirectory;
    }

    public void setDexDirectory(DexDirectory dexDirectory) {
        this.dexDirectory = dexDirectory;
        DexContainerBlock containerBlock = this.getContainerBlock();
        containerBlock.setTag(this);
        containerBlock.setSimpleName(this.getSimpleName());
    }

    public DexContainerBlock getContainerBlock() {
        return this.containerBlock;
    }

    @Override
    public void refresh() {
        this.getContainerBlock().refresh();
        this.layoutController.refreshController();
    }

    @Override
    public void refreshFull() {
        this.layoutController.refreshController();
        this.getContainerBlock().refreshFull();
        this.layoutController.refreshController();
    }

    public void clearEmptySections() {
        for (DexLayout dexLayout : this) {
            dexLayout.clearEmptySections();
        }
    }

    public Iterator<DexInstruction> getDexInstructions() {
        return new IterableIterator<DexLayout, DexInstruction>(this.iterator()){

            @Override
            public Iterator<DexInstruction> iterator(DexLayout element) {
                return element.getDexInstructions();
            }
        };
    }

    public Iterator<DexInstruction> getDexInstructionsCloned() {
        return new IterableIterator<DexLayout, DexInstruction>(this.iterator()){

            @Override
            public Iterator<DexInstruction> iterator(DexLayout element) {
                return element.getDexInstructionsCloned();
            }
        };
    }

    @Override
    public DexClassRepository getRootRepository() {
        DexDirectory dexDirectory = this.getDexDirectory();
        if (dexDirectory != null) {
            return dexDirectory.getRootRepository();
        }
        return this;
    }

    @Override
    public Iterator<DexClassModule> modules() {
        return (Iterator)ObjectsUtil.cast(this.iterator());
    }

    public int clearDuplicateData() {
        int result = 0;
        for (DexLayout dexLayout : this) {
            result += dexLayout.clearDuplicateData();
        }
        return result;
    }

    public int clearUnused() {
        int result = 0;
        for (DexLayout dexLayout : this) {
            result += dexLayout.clearUnused();
        }
        return result;
    }

    public boolean merge(DexClass dexClass) {
        return this.merge((MergeOptions)new DexMergeOptions(true), dexClass);
    }

    public boolean merge(MergeOptions options, DexClass dexClass) {
        return this.merge(options, dexClass.getId());
    }

    public boolean merge(ClassId classId) {
        return this.merge((MergeOptions)new DexMergeOptions(true), classId);
    }

    public boolean merge(MergeOptions options, ClassId classId) {
        return this.getOrCreateFirst().merge(options, classId);
    }

    public boolean merge(MergeOptions options, DexFile dexFile) {
        if (dexFile == null) {
            return false;
        }
        DexLayout dexLayout = dexFile.getFirst();
        if (dexLayout == null) {
            return false;
        }
        return this.getOrCreateFirst().merge(options, dexLayout);
    }

    public boolean merge(MergeOptions options, DexLayout dexLayout) {
        if (dexLayout == null || dexLayout.isEmpty()) {
            return false;
        }
        return this.getOrCreateFirst().merge(options, dexLayout);
    }

    public void combineFrom(DexLayout dexLayout) {
        this.getContainerBlock().combineFrom(dexLayout.getDexLayoutBlock());
    }

    public void combineFrom(MergeOptions options, DexLayout dexLayout) {
        this.getContainerBlock().combineFrom(options, dexLayout.getDexLayoutBlock());
    }

    public void combineFrom(DexFile dexFile) {
        this.getContainerBlock().combineFrom(dexFile.getContainerBlock());
    }

    public void combineFrom(MergeOptions options, DexFile dexFile) {
        this.getContainerBlock().combineFrom(options, dexFile.getContainerBlock());
    }

    private void requireNotClosed() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Closed");
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            DexLayout layout = this.getLayout(i);
            if (layout == null) continue;
            layout.close();
        }
        this.getContainerBlock().clear();
    }

    public byte[] getBytes() {
        if (this.isEmpty()) {
            return new byte[0];
        }
        return this.getContainerBlock().getBytes();
    }

    public void readBytes(BlockReader reader) throws IOException {
        this.getContainerBlock().readBytes(reader);
    }

    public void readBytes(BlockReader reader, Predicate<SectionType<?>> filter) throws IOException {
        this.getContainerBlock().readBytes(reader, filter);
    }

    public void write(File file) throws IOException {
        OutputStream outputStream = FileUtil.outputStream(file);
        this.write(outputStream);
        outputStream.close();
    }

    public void write(OutputStream outputStream) throws IOException {
        this.getContainerBlock().writeBytes(outputStream);
    }

    public void parseSmaliDirectory(File dir) throws IOException {
        List<File> layoutDir;
        File fileInfo = new File(dir, DexFileInfo.FILE_NAME);
        if (fileInfo.isFile()) {
            DexFileInfo.readJson(fileInfo).applyTo(this);
        }
        if ((layoutDir = this.listSmaliLayouts(dir)) != null) {
            int size = layoutDir.size();
            for (int i = 0; i < size; ++i) {
                File file = layoutDir.get(i);
                DexLayout layout = this.getOrCreateAt(i);
                layout.parseSmaliDirectory(file);
            }
        } else {
            this.getOrCreateFirst().parseSmaliDirectory(dir);
        }
    }

    public void writeSmali(SmaliWriter writer, File root) throws IOException {
        this.requireNotClosed();
        root = new File(root, this.buildSmaliDirectoryName());
        DexFileInfo fileInfo = DexFileInfo.fromDex(this);
        fileInfo.saveToDirectory(root);
        if (!this.isMultiLayout()) {
            DexLayout first = this.getFirst();
            if (first != null) {
                first.writeSmali(writer, root);
            }
        } else {
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                DexLayout dexLayout = this.getLayout(i);
                String name = "layout" + i;
                File dir = new File(root, name);
                dexLayout.writeSmali(writer, dir);
            }
        }
    }

    private List<File> listSmaliLayouts(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return null;
        }
        ArrayCollection<File> results = new ArrayCollection<File>();
        for (File file : files) {
            if (file.isFile()) {
                if (file.getName().equals(DexFileInfo.FILE_NAME)) continue;
                return null;
            }
            if (this.isLayoutDirectory(file)) {
                results.add(file);
                continue;
            }
            return null;
        }
        if (results.isEmpty()) {
            return null;
        }
        results.sort(CompareUtil.getToStringComparator());
        return results;
    }

    private boolean isLayoutDirectory(File dir) {
        String prefix;
        if (!dir.isDirectory()) {
            return false;
        }
        String name = dir.getName();
        if (!name.startsWith(prefix = "layout")) {
            return false;
        }
        name = name.substring(prefix.length());
        try {
            int i = Integer.parseInt(name);
            return i >= 0;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    public String getFileName() {
        String simpleName = this.getSimpleName();
        if (simpleName == null) {
            return this.buildSmaliDirectoryName() + ".dex";
        }
        return FileUtil.getFileName(simpleName);
    }

    public String buildSmaliDirectoryName() {
        String name = this.getSimpleName();
        if (name != null && name.endsWith(".dex")) {
            return name.substring(0, name.length() - 4);
        }
        DexDirectory dexDirectory = this.getDexDirectory();
        if (dexDirectory == null) {
            return "classes";
        }
        int i = 0;
        for (DexFile dexFile : dexDirectory) {
            if (dexFile == this) break;
            ++i;
        }
        if (i == 0) {
            return "classes";
        }
        return "classes" + ++i;
    }

    public String printSectionInfo(boolean hex) {
        int size = this.size();
        if (size == 0) {
            return "no layouts";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                builder.append('\n');
            }
            DexLayout layout = this.getLayout(i);
            builder.append(layout.printSectionInfo(hex));
        }
        return builder.toString();
    }

    public int getDexClassesCountForDebug() {
        int count = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            count += this.getLayout(i).getDexClassesCountForDebug();
        }
        return count;
    }

    public String toString() {
        int size = this.size();
        if (size == 0) {
            return "EMPTY DEX FILE";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                builder.append('\n');
            }
            builder.append(this.getLayout(i));
        }
        if (this.isMultiLayout()) {
            builder.append('\n');
            builder.append("total classes = ");
            builder.append(this.getDexClassesCountForDebug());
        }
        return builder.toString();
    }

    public static DexFile createDefault() {
        return new DexFile(DexContainerBlock.createDefault());
    }

    public static DexFile createNew() {
        return new DexFile(new DexContainerBlock());
    }

    public static int getDexFileNumber(String name) {
        int i = name.lastIndexOf(47);
        if (i < 0) {
            i = name.lastIndexOf(92);
        }
        if (i >= 0) {
            name = name.substring(i + 1);
        }
        if (name.equals("classes.dex")) {
            return 0;
        }
        String prefix = "classes";
        String ext = ".dex";
        if (!name.startsWith(prefix) || !name.endsWith(ext)) {
            return -1;
        }
        String num = name.substring(prefix.length(), name.length() - ext.length());
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }

    public static String getDexName(int i) {
        if (i == 0) {
            return "classes.dex";
        }
        if (i == 1) {
            i = 2;
        }
        return "classes" + i + ".dex";
    }

    public static DexFile read(byte[] dexBytes) throws IOException {
        return DexFile.read(dexBytes, null);
    }

    public static DexFile read(File file) throws IOException {
        return DexFile.read(file, null);
    }

    public static DexFile read(InputStream inputStream) throws IOException {
        return DexFile.read(inputStream, null);
    }

    public static DexFile read(BlockReader reader) throws IOException {
        return DexFile.read(reader, null);
    }

    public static DexFile read(byte[] dexBytes, Predicate<SectionType<?>> filter) throws IOException {
        return DexFile.read(new BlockReader(dexBytes), filter);
    }

    public static DexFile read(File file, Predicate<SectionType<?>> filter) throws IOException {
        return DexFile.read(new BlockReader(file), filter);
    }

    public static DexFile read(InputStream inputStream, Predicate<SectionType<?>> filter) throws IOException {
        return DexFile.read(new BlockReader(inputStream), filter);
    }

    public static DexFile read(BlockReader reader, Predicate<SectionType<?>> filter) throws IOException {
        DexFile dexFile = new DexFile(new DexContainerBlock());
        dexFile.readBytes(reader, filter);
        return dexFile;
    }
}

