/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.common.ArraySupplier;
import com.reandroid.dex.common.AnnotationVisibility;
import com.reandroid.dex.key.AnnotationElementKey;
import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.Dex;
import com.reandroid.dex.model.DexAnnotationElement;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexField;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.model.DexMethodParameter;
import com.reandroid.dex.program.AnnotatedProgram;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.collection.ArraySupplierIterator;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.util.Iterator;

public class DexAnnotation
extends Dex
implements Iterable<DexAnnotationElement> {
    private final Dex declaring;
    private final AnnotatedProgram annotatedProgram;
    private TypeKey typeKey;
    private AnnotationItemKey mRemoved;

    public DexAnnotation(Dex declaring, AnnotatedProgram annotatedProgram, TypeKey typeKey) {
        this.declaring = declaring;
        this.annotatedProgram = annotatedProgram;
        this.typeKey = typeKey;
    }

    public AnnotationItemKey getKey() {
        AnnotationItemKey key = this.mRemoved;
        if (key == null) {
            key = this.getAnnotationSet().get(this.getType());
        }
        return key;
    }

    public void setKey(Key key) {
        AnnotationItemKey itemKey = (AnnotationItemKey)key;
        AnnotationSetKey annotationSetKey = this.getAnnotationSet().remove(this.getType()).add(itemKey);
        this.setAnnotation(annotationSetKey);
        this.typeKey = itemKey.getType();
    }

    public TypeKey getType() {
        return this.typeKey;
    }

    public void setType(TypeKey typeKey) {
        this.setKey(this.getKey().changeType(typeKey));
    }

    @Override
    public boolean uses(Key key) {
        return this.getKey().uses(key);
    }

    public boolean contains(String name) {
        return this.getKey().containsElement(name);
    }

    public DexAnnotationElement get(String name) {
        return DexAnnotationElement.create(this, name);
    }

    public DexAnnotationElement get(int index) {
        return DexAnnotationElement.create(this, (AnnotationElementKey)this.getKey().get(index));
    }

    public int size() {
        return this.getKey().size();
    }

    public void remove(String name) {
        this.setKey(this.getKey().remove(name));
    }

    @Override
    public Iterator<DexAnnotationElement> iterator() {
        return ArraySupplierIterator.of(new ArraySupplier<DexAnnotationElement>(){

            @Override
            public DexAnnotationElement get(int i) {
                return DexAnnotation.this.get(i);
            }

            @Override
            public int getCount() {
                return DexAnnotation.this.size();
            }
        });
    }

    public AnnotationVisibility getVisibility() {
        return this.getKey().getVisibility();
    }

    public void setVisibility(AnnotationVisibility visibility) {
        this.setKey(this.getKey().changeVisibility(visibility));
    }

    public DexAnnotationElement getOrCreate(String name) {
        if (!this.contains(name)) {
            this.setKey(this.getKey().getOrCreate(name));
        }
        return DexAnnotationElement.create(this, name);
    }

    @Override
    public void removeSelf() {
        if (!this.isRemoved()) {
            this.applyRemoveSelf();
        }
    }

    public boolean isRemoved() {
        this.checkRemoved();
        return this.typeKey == null;
    }

    private void checkRemoved() {
        AnnotationItemKey key = this.mRemoved;
        if (key != null) {
            AnnotationSetKey annotationSetKey = this.getAnnotationSet();
            TypeKey typeKey = key.getType();
            if (annotationSetKey != null) {
                if (annotationSetKey.contains(typeKey)) {
                    this.typeKey = typeKey;
                    this.mRemoved = null;
                } else {
                    this.applyRemoveSelf();
                }
            }
        }
    }

    private void applyRemoveSelf() {
        AnnotationItemKey key = this.mRemoved;
        if (key != null) {
            this.typeKey = null;
            return;
        }
        AnnotationSetKey annotationSetKey = this.getAnnotationSet();
        key = this.getKey();
        TypeKey typeKey = this.typeKey;
        this.typeKey = null;
        if (key != null) {
            this.mRemoved = key;
            typeKey = key.getType();
        }
        this.setAnnotation(annotationSetKey.remove(typeKey));
    }

    public Dex getDeclaring() {
        return this.declaring;
    }

    private AnnotatedProgram getAnnotatedItem() {
        return this.annotatedProgram;
    }

    private AnnotationSetKey getAnnotationSet() {
        return this.getAnnotatedItem().getAnnotation();
    }

    private void setAnnotation(AnnotationSetKey annotationSetKey) {
        this.getAnnotatedItem().setAnnotation(annotationSetKey);
    }

    public ElementType getAnnotationType() {
        Dex declaring = this.getDeclaring();
        if (declaring instanceof DexMethodParameter) {
            return ElementType.PARAMETER;
        }
        if (declaring instanceof DexMethod) {
            return ElementType.METHOD;
        }
        if (declaring instanceof DexField) {
            return ElementType.FIELD;
        }
        return ElementType.TYPE;
    }

    @Override
    public DexClassRepository getClassRepository() {
        return this.getDeclaring().getClassRepository();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        if (!this.isRemoved()) {
            this.getKey().append(writer);
        }
    }

    @Override
    public String toString() {
        AnnotationItemKey key = this.getKey();
        if (this.isRemoved()) {
            return "#REMOVED " + key;
        }
        return String.valueOf(key);
    }

    public static DexAnnotation create(Dex declaring, AnnotatedProgram annotatedProgram, TypeKey typeKey) {
        if (declaring != null && annotatedProgram != null && annotatedProgram.hasAnnotation(typeKey)) {
            return new DexAnnotation(declaring, annotatedProgram, typeKey);
        }
        return null;
    }

    public static DexAnnotation create(Dex declaring, AnnotatedProgram annotatedProgram, AnnotationItemKey itemKey) {
        if (declaring != null && annotatedProgram != null && itemKey != null) {
            return DexAnnotation.create(declaring, annotatedProgram, itemKey.getType());
        }
        return null;
    }
}

