/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.ProgramKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.Dex;
import com.reandroid.dex.model.DexAnnotation;
import com.reandroid.dex.model.DexAnnotationElement;
import com.reandroid.dex.program.ProgramElement;
import com.reandroid.utils.collection.ComputeIterator;
import java.util.Iterator;

public interface AnnotatedDex
extends ProgramElement {
    public ProgramElement getProgramElement();

    @Override
    default public ProgramKey getKey() {
        return this.getProgramElement().getKey();
    }

    @Override
    default public AnnotationSetKey getAnnotation() {
        return this.getProgramElement().getAnnotation();
    }

    @Override
    default public void setAnnotation(AnnotationSetKey annotationSet) {
        this.getProgramElement().setAnnotation(annotationSet);
    }

    @Override
    default public boolean hasAnnotations() {
        return this.getProgramElement().hasAnnotations();
    }

    @Override
    default public void clearAnnotations() {
        this.getProgramElement().clearAnnotations();
    }

    default public Iterator<DexAnnotation> getDexAnnotations() {
        AnnotationSetKey annotation = this.getProgramElement().getAnnotation();
        return ComputeIterator.of(annotation.getTypes(), this::getDexAnnotation);
    }

    default public DexAnnotation getDexAnnotation(TypeKey typeKey) {
        ProgramElement annotatedProgram = this.getProgramElement();
        if (annotatedProgram.hasAnnotation(typeKey)) {
            return new DexAnnotation((Dex)((Object)this), annotatedProgram, typeKey);
        }
        return null;
    }

    default public DexAnnotation getOrCreateDexAnnotation(TypeKey typeKey) {
        ProgramElement annotatedProgram = this.getProgramElement();
        AnnotationSetKey annotationSetKey = annotatedProgram.getAnnotation();
        if (!annotationSetKey.contains(typeKey)) {
            annotationSetKey = annotationSetKey.getOrCreate(typeKey);
            annotatedProgram.setAnnotation(annotationSetKey);
        }
        return new DexAnnotation((Dex)((Object)this), annotatedProgram, typeKey);
    }

    default public DexAnnotationElement getDexAnnotationElement(TypeKey typeKey, String name) {
        DexAnnotation dexAnnotation = this.getDexAnnotation(typeKey);
        if (dexAnnotation != null) {
            return dexAnnotation.get(name);
        }
        return null;
    }

    default public DexAnnotationElement getOrCreateDexAnnotationElement(TypeKey typeKey, String name) {
        DexAnnotation annotation = this.getOrCreateDexAnnotation(typeKey);
        return annotation.getOrCreate(name);
    }
}

