/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.common.DexUtils;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.PrimitiveKeyHelper;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.NumberX;
import com.reandroid.utils.StringsUtil;
import java.io.IOException;

public abstract class PrimitiveKey
implements Key {
    private static PrimitiveKey TRUE_KEY;
    private static PrimitiveKey FALSE_KEY;

    public abstract Object getValue();

    public abstract TypeKey valueType();

    public abstract int width();

    public abstract long getValueAsLong();

    public boolean isNumber() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isByte() {
        return false;
    }

    public boolean isChar() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isShort() {
        return false;
    }

    public boolean isX() {
        return false;
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof PrimitiveKey)) {
            return StringsUtil.compareToString(this, obj);
        }
        PrimitiveKey other = (PrimitiveKey)obj;
        return Long.compare(this.getValueAsLong(), other.getValueAsLong());
    }

    @Override
    public abstract void append(SmaliWriter var1) throws IOException;

    public static PrimitiveKey of(boolean value) {
        PrimitiveKey key;
        if (value) {
            key = TRUE_KEY;
            if (key == null) {
                TRUE_KEY = key = new BooleanKey(true);
            }
        } else {
            key = FALSE_KEY;
            if (key == null) {
                FALSE_KEY = key = new BooleanKey(false);
            }
        }
        return key;
    }

    public static PrimitiveKey of(byte value) {
        return new ByteKey(value);
    }

    public static PrimitiveKey of(char value) {
        return new CharKey(value);
    }

    public static PrimitiveKey of(double value) {
        return new DoubleKey(value);
    }

    public static PrimitiveKey of(float value) {
        return new FloatKey(value);
    }

    public static PrimitiveKey of(int value) {
        return new IntegerKey(value);
    }

    public static PrimitiveKey of(long value) {
        return new LongKey(value);
    }

    public static PrimitiveKey of(short value) {
        return new ShortKey(value);
    }

    public static PrimitiveKey of(int width, long value) {
        return new NumberXKey(width, value);
    }

    public static PrimitiveKey parse(String text) {
        return PrimitiveKeyHelper.parse(text);
    }

    public static PrimitiveKey readSafe(SmaliReader reader) {
        return PrimitiveKeyHelper.readSafe(reader);
    }

    public static class NumberXKey
    extends NumberKey {
        private final int width;
        private final long value;

        public NumberXKey(int width, long value) {
            this.width = width;
            this.value = value;
        }

        public long value() {
            return this.value;
        }

        @Override
        public Number getValue() {
            int width = this.width();
            long value = this.value();
            if (width == 1) {
                return (byte)value;
            }
            if (width == 2) {
                return (short)value;
            }
            if (width == 4) {
                return (int)value;
            }
            if (width == 8) {
                return value;
            }
            return NumberX.valueOf(this.width(), this.value());
        }

        @Override
        public int width() {
            return this.width;
        }

        @Override
        public long getValueAsLong() {
            return this.value();
        }

        @Override
        public boolean isX() {
            return true;
        }

        @Override
        public TypeKey valueType() {
            return null;
        }

        public int hashCode() {
            return Long.hashCode(this.value());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.value() == ((NumberXKey)obj).value();
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.appendHex(this.value());
        }

        @Override
        public String toString() {
            return NumberX.toHexString(this.width(), this.value());
        }
    }

    public static class ShortKey
    extends NumberKey {
        private final short value;

        public ShortKey(short value) {
            this.value = value;
        }

        public short value() {
            return this.value;
        }

        @Override
        public Short getValue() {
            return this.value;
        }

        @Override
        public int width() {
            return 2;
        }

        @Override
        public long getValueAsLong() {
            return this.value();
        }

        @Override
        public TypeKey valueType() {
            return TypeKey.TYPE_S;
        }

        @Override
        public boolean isShort() {
            return true;
        }

        public int hashCode() {
            return this.value();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.value() == ((ShortKey)obj).value();
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.appendHex(this.value());
        }

        @Override
        public String toString() {
            return HexUtil.toSignedHex(this.value()) + "S";
        }
    }

    public static class LongKey
    extends NumberKey {
        private final long value;

        public LongKey(long value) {
            this.value = value;
        }

        public long value() {
            return this.value;
        }

        @Override
        public Long getValue() {
            return this.value;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public long getValueAsLong() {
            return this.value();
        }

        @Override
        public TypeKey valueType() {
            return TypeKey.TYPE_J;
        }

        @Override
        public boolean isLong() {
            return true;
        }

        public int hashCode() {
            return Long.hashCode(this.value());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.value() == ((LongKey)obj).value();
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.appendHex(this.value());
        }

        @Override
        public String toString() {
            return HexUtil.toSignedHex(this.getValue());
        }
    }

    public static class IntegerKey
    extends NumberKey {
        private final int value;

        public IntegerKey(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        @Override
        public Integer getValue() {
            return this.value();
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public long getValueAsLong() {
            return this.value();
        }

        @Override
        public TypeKey valueType() {
            return TypeKey.TYPE_I;
        }

        @Override
        public boolean isInteger() {
            return true;
        }

        public int hashCode() {
            return this.value();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.value() == ((IntegerKey)obj).value();
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.appendHex(this.value());
        }

        @Override
        public String toString() {
            return HexUtil.toSignedHex(this.getValue());
        }
    }

    public static class FloatKey
    extends NumberKey {
        private final float value;

        public FloatKey(float value) {
            this.value = value;
        }

        public float value() {
            return this.value;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public int width() {
            return 4;
        }

        @Override
        public long getValueAsLong() {
            return Float.floatToIntBits(this.value());
        }

        @Override
        public TypeKey valueType() {
            return TypeKey.TYPE_F;
        }

        @Override
        public boolean isFloat() {
            return true;
        }

        @Override
        public int compareTo(Object obj) {
            if (obj == this) {
                return 0;
            }
            if (!(obj instanceof FloatKey)) {
                return StringsUtil.compareToString(this, obj);
            }
            return Float.compare(this.value(), ((FloatKey)obj).value());
        }

        public int hashCode() {
            return Float.hashCode(this.value());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return Float.floatToIntBits(this.value()) == Float.floatToIntBits(((FloatKey)obj).value());
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.append(this.value());
        }

        @Override
        public String toString() {
            return this.value() + "f";
        }
    }

    public static class DoubleKey
    extends NumberKey {
        private final double value;

        public DoubleKey(double value) {
            this.value = value;
        }

        public double value() {
            return this.value;
        }

        @Override
        public Double getValue() {
            return this.value;
        }

        @Override
        public int width() {
            return 8;
        }

        @Override
        public long getValueAsLong() {
            return Double.doubleToLongBits(this.value());
        }

        @Override
        public TypeKey valueType() {
            return TypeKey.TYPE_D;
        }

        @Override
        public boolean isDouble() {
            return true;
        }

        @Override
        public int compareTo(Object obj) {
            if (obj == this) {
                return 0;
            }
            if (!(obj instanceof DoubleKey)) {
                return StringsUtil.compareToString(this, obj);
            }
            return Double.compare(this.value(), ((DoubleKey)obj).value());
        }

        public int hashCode() {
            return Double.hashCode(this.value());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return Double.doubleToLongBits(this.value()) == Double.doubleToLongBits(((DoubleKey)obj).value());
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.append(this.value());
        }

        @Override
        public String toString() {
            return Double.toString(this.value());
        }
    }

    public static class CharKey
    extends PrimitiveKey {
        private final char value;

        public CharKey(char value) {
            this.value = value;
        }

        public char value() {
            return this.value;
        }

        @Override
        public Character getValue() {
            return Character.valueOf(this.value);
        }

        @Override
        public int width() {
            return 0;
        }

        @Override
        public long getValueAsLong() {
            return this.value();
        }

        @Override
        public TypeKey valueType() {
            return TypeKey.TYPE_C;
        }

        @Override
        public boolean isChar() {
            return true;
        }

        public int hashCode() {
            return this.value();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.value() == ((CharKey)obj).value();
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.append(DexUtils.quoteChar(this.value()));
        }

        public String toString() {
            return DexUtils.quoteChar(this.value());
        }
    }

    public static class ByteKey
    extends NumberKey {
        private final byte value;

        public ByteKey(byte value) {
            this.value = value;
        }

        public byte value() {
            return this.value;
        }

        @Override
        public Byte getValue() {
            return this.value;
        }

        @Override
        public int width() {
            return 1;
        }

        @Override
        public long getValueAsLong() {
            return this.value();
        }

        @Override
        public TypeKey valueType() {
            return TypeKey.TYPE_B;
        }

        @Override
        public boolean isByte() {
            return true;
        }

        public int hashCode() {
            return this.value();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.value() == ((ByteKey)obj).value();
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.appendHex(this.value());
        }

        @Override
        public String toString() {
            return HexUtil.toSignedHex(this.value()) + "t";
        }
    }

    public static class BooleanKey
    extends PrimitiveKey {
        private final boolean value;

        public BooleanKey(boolean value) {
            this.value = value;
        }

        public boolean value() {
            return this.value;
        }

        @Override
        public boolean isBoolean() {
            return true;
        }

        @Override
        public Boolean getValue() {
            return this.value();
        }

        @Override
        public int width() {
            return 0;
        }

        @Override
        public long getValueAsLong() {
            return this.value() ? 1L : 0L;
        }

        @Override
        public TypeKey valueType() {
            return TypeKey.TYPE_Z;
        }

        public int hashCode() {
            return this.value() ? 1 : 0;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.value() == ((BooleanKey)obj).value();
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.append(this.value() ? "true" : "false");
        }

        public String toString() {
            return this.value() ? "true" : "false";
        }
    }

    public static abstract class NumberKey
    extends PrimitiveKey {
        @Override
        public abstract Number getValue();

        @Override
        public boolean isNumber() {
            return true;
        }

        public String toString() {
            return this.getValue().toString();
        }
    }
}

