/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyUtil;
import com.reandroid.dex.key.ProgramKey;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.key.TypeListKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Iterator;
import java.util.function.Function;

public class MethodKey
implements ProgramKey {
    private final TypeKey declaring;
    private final StringKey nameKey;
    private final ProtoKey proto;
    public static final MethodKey STATIC_CONSTRUCTOR = new MethodKey(TypeKey.OBJECT, "<clinit>", ProtoKey.emptyParameters(TypeKey.TYPE_V));
    public static final MethodKey EQUALS = new MethodKey(TypeKey.OBJECT, "equals", ProtoKey.create(TypeKey.TYPE_Z, TypeKey.OBJECT));
    public static final MethodKey HASHCODE = new MethodKey(TypeKey.OBJECT, "hashCode", ProtoKey.emptyParameters(TypeKey.TYPE_I));
    public static final MethodKey TO_STRING = new MethodKey(TypeKey.OBJECT, "toString", ProtoKey.emptyParameters(TypeKey.STRING));
    public static final MethodKey CONSTRUCTOR = new MethodKey(TypeKey.OBJECT, "<init>", ProtoKey.emptyParameters(TypeKey.TYPE_V));
    public static final MethodKey CONSTRUCTOR_STATIC = new MethodKey(TypeKey.OBJECT, "<clinit>", ProtoKey.emptyParameters(TypeKey.TYPE_V));

    public MethodKey(TypeKey declaring, StringKey name, ProtoKey proto) {
        this.declaring = declaring;
        this.nameKey = name;
        this.proto = proto;
    }

    public MethodKey(TypeKey declaring, String name, ProtoKey proto) {
        this(declaring, StringKey.create(name), proto);
    }

    @Override
    public ElementType getElementType() {
        return ElementType.METHOD;
    }

    public int getRegister(int index) {
        return this.getProto().getRegister(index);
    }

    public int getParameterIndex(int index) {
        return this.getProto().getParameterIndex(index);
    }

    public MethodKey changeDeclaring(TypeKey typeKey) {
        if (this.getDeclaring().equals(typeKey)) {
            return this;
        }
        return new MethodKey(typeKey, this.getNameKey(), this.getProto());
    }

    public MethodKey changeName(String name) {
        return this.changeName(StringKey.create(name));
    }

    public MethodKey changeName(StringKey name) {
        if (name.equals(this.getNameKey())) {
            return this;
        }
        return new MethodKey(this.getDeclaring(), name, this.getProto());
    }

    public MethodKey changeParameters(TypeListKey parameters) {
        return this.changeProto(this.getProto().changeParameters(parameters));
    }

    public MethodKey changeParameter(int index, TypeKey parameter) {
        return this.changeProto(this.getProto().changeParameter(index, parameter));
    }

    public MethodKey changeProto(ProtoKey protoKey) {
        if (protoKey.equals(this.getProto())) {
            return this;
        }
        return MethodKey.create(this.getDeclaring(), this.getNameKey(), protoKey);
    }

    public MethodKey changeReturnType(TypeKey typeKey) {
        return this.changeProto(this.getProto().changeReturnType(typeKey));
    }

    public MethodKey removeParameter(int index) {
        return this.changeProto(this.getProto().removeParameter(index));
    }

    @Override
    public TypeKey getDeclaring() {
        return this.declaring;
    }

    public StringKey getNameKey() {
        return this.nameKey;
    }

    public ProtoKey getProto() {
        return this.proto;
    }

    public TypeKey getReturnType() {
        return this.getProto().getReturnType();
    }

    public TypeListKey getParameters() {
        return this.getProto().getParameters();
    }

    public String getName() {
        return this.getNameKey().getString();
    }

    public Iterator<TypeKey> parameters() {
        return this.getParameters().iterator();
    }

    public int getParametersCount() {
        return this.getParameters().size();
    }

    public TypeKey getParameter(int i) {
        return (TypeKey)this.getParameters().get(i);
    }

    public int getParameterRegistersCount() {
        return this.getProto().getParameterRegistersCount();
    }

    public Iterator<Key> mentionedKeys() {
        return CombiningIterator.singleTwo(this, CombiningIterator.singleOne(this.getDeclaring(), SingleIterator.of(this.getNameKey())), this.getProto().mentionedKeys());
    }

    public MethodKey replaceTypes(Function<TypeKey, TypeKey> function) {
        MethodKey result = this;
        TypeKey typeKey = this.getDeclaring();
        typeKey = typeKey.changeTypeName(function.apply(typeKey));
        result = result.changeDeclaring(typeKey);
        typeKey = this.getReturnType();
        typeKey = typeKey.changeTypeName(function.apply(typeKey));
        result = result.changeReturnType(typeKey);
        int count = this.getParametersCount();
        for (int i = 0; i < count; ++i) {
            typeKey = this.getParameter(i);
            typeKey = typeKey.changeTypeName(function.apply(typeKey));
            result = result.changeParameter(i, typeKey);
        }
        return result;
    }

    @Override
    public MethodKey replaceKey(Key search, Key replace) {
        MethodKey result = this;
        if (search.equals(result)) {
            return (MethodKey)replace;
        }
        if (search.equals(result.getDeclaring())) {
            result = result.changeDeclaring((TypeKey)replace);
        }
        if (replace instanceof StringKey && search.equals(result.getNameKey())) {
            result = result.changeName((StringKey)replace);
        }
        result = result.changeProto(this.getProto().replaceKey(search, replace));
        return result;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getDeclaring().append(writer);
        writer.append("->");
        this.appendDefinition(writer);
    }

    public void appendDefinition(SmaliWriter writer) throws IOException {
        this.getNameKey().appendSimpleName(writer);
        this.getProto().append(writer);
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof MethodKey)) {
            return StringsUtil.compareToString(this, obj);
        }
        MethodKey key = (MethodKey)obj;
        int i = CompareUtil.compare(this.getDeclaring(), key.getDeclaring());
        if (i != 0) {
            return i;
        }
        i = CompareUtil.compare(this.getNameKey(), key.getNameKey());
        if (i != 0) {
            return i;
        }
        return CompareUtil.compare(this.getProto(), key.getProto());
    }

    public int compareTo(Object obj, boolean checkDefining) {
        int i;
        if (obj == null) {
            return -1;
        }
        if (obj == this) {
            return 0;
        }
        MethodKey key = (MethodKey)obj;
        if (checkDefining && (i = CompareUtil.compare(this.getDeclaring(), key.getDeclaring())) != 0) {
            return i;
        }
        i = CompareUtil.compare(this.getNameKey(), key.getNameKey());
        if (i != 0) {
            return i;
        }
        return CompareUtil.compare(this.getProto(), key.getProto());
    }

    public boolean equalsIgnoreDeclaring(MethodKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return ObjectsUtil.equals(this.getNameKey(), other.getNameKey()) && ObjectsUtil.equals(this.getProto(), other.getProto());
    }

    public boolean equalsIgnoreReturnType(MethodKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!ObjectsUtil.equals(this.getDeclaring(), other.getDeclaring())) {
            return false;
        }
        if (!ObjectsUtil.equals(this.getNameKey(), other.getNameKey())) {
            return false;
        }
        return this.getProto().equalsParameters(other.getProto());
    }

    public boolean equalsNameAndParameters(MethodKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!KeyUtil.matches(this.getName(), other.getName())) {
            return false;
        }
        return TypeListKey.equalsIgnoreEmpty(this.getParameters(), other.getParameters());
    }

    public boolean equalsIgnoreName(MethodKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!ObjectsUtil.equals(this.getDeclaring(), other.getDeclaring())) {
            return false;
        }
        return ObjectsUtil.equals(this.getProto(), other.getProto());
    }

    public boolean equalsName(MethodKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return KeyUtil.matches(this.getName(), other.getName());
    }

    public boolean equalsName(String name) {
        return KeyUtil.matches(this.getName(), name);
    }

    public boolean equalsProto(MethodKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return ObjectsUtil.equals(this.getProto(), other.getProto());
    }

    public boolean equalsDeclaring(TypeKey declaring) {
        return ObjectsUtil.equals(this.getDeclaring(), declaring);
    }

    public boolean equalsDeclaring(MethodKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return ObjectsUtil.equals(this.getDeclaring(), other.getDeclaring());
    }

    public boolean equalsReturnType(TypeKey returnType) {
        return this.getProto().equalsReturnType(returnType);
    }

    public boolean equalsReturnType(MethodKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.getProto().equalsReturnType(other.getProto());
    }

    public boolean equals(Object obj, boolean checkDefining, boolean checkType) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodKey)) {
            return false;
        }
        MethodKey methodKey = (MethodKey)obj;
        if (!ObjectsUtil.equals(this.getNameKey(), methodKey.getNameKey())) {
            return false;
        }
        if (!TypeListKey.equalsIgnoreEmpty(this.getParameters(), methodKey.getParameters())) {
            return false;
        }
        if (checkDefining && !ObjectsUtil.equals(this.getDeclaring(), methodKey.getDeclaring())) {
            return false;
        }
        if (checkType) {
            return ObjectsUtil.equals(this.getReturnType(), methodKey.getReturnType());
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodKey)) {
            return false;
        }
        MethodKey methodKey = (MethodKey)obj;
        return ObjectsUtil.equals(this.getNameKey(), methodKey.getNameKey()) && ObjectsUtil.equals(this.getDeclaring(), methodKey.getDeclaring()) && ObjectsUtil.equals(this.getProto(), methodKey.getProto());
    }

    public int hashCode() {
        return ObjectsUtil.hash(this.getDeclaring(), this.getNameKey(), this.getProto());
    }

    public String toString() {
        return this.getDeclaring() + "->" + this.getNameKey().getAsSimpleName() + this.getProto();
    }

    public static MethodKey parse(String text) {
        return MethodKey.parse(text, 0);
    }

    public static MethodKey parse(String text, int start) {
        if (text.length() - start < 6 || text.charAt(start) != 'L' && text.charAt(start) != '[') {
            return null;
        }
        int i = text.indexOf("->", start);
        if (i < 0) {
            return null;
        }
        TypeKey defining = TypeKey.parseBinaryType(text, start, i);
        if (defining == null) {
            return null;
        }
        i = text.indexOf(40, start = start + defining.getTypeName().length() + 2);
        if (i < 0) {
            return null;
        }
        String name = text.substring(start, i);
        start = i;
        if ((i = text.indexOf(41, start)) < 0) {
            return null;
        }
        ProtoKey protoKey = ProtoKey.parse(text, start);
        if (protoKey == null) {
            return null;
        }
        return MethodKey.create(defining, StringKey.create(name), protoKey);
    }

    public static MethodKey convert(Method method) {
        TypeKey declaring = TypeKey.convert(method.getDeclaringClass());
        TypeKey returnType = TypeKey.convert(method.getReturnType());
        Parameter[] parameters = method.getParameters();
        int length = parameters.length;
        TypeKey[] typeKeys = new TypeKey[length];
        for (int i = 0; i < length; ++i) {
            typeKeys[i] = TypeKey.convert(parameters[i].getType());
        }
        ProtoKey protoKey = ProtoKey.create(returnType, typeKeys);
        return MethodKey.create(declaring, StringKey.create(method.getName()), protoKey);
    }

    public static MethodKey create(TypeKey declaring, StringKey name, ProtoKey protoKey) {
        if (declaring == null || name == null || protoKey == null) {
            return null;
        }
        return new MethodKey(declaring, name, protoKey);
    }

    public static MethodKey create(TypeKey declaring, String name, ProtoKey protoKey) {
        return MethodKey.create(declaring, StringKey.create(name), protoKey);
    }

    public static MethodKey read(SmaliReader reader) throws IOException {
        TypeKey declaring = TypeKey.read(reader);
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, '-');
        SmaliParseException.expect(reader, '>');
        reader.skipWhitespacesOrComment();
        StringKey name = StringKey.readSimpleName(reader, '(');
        ProtoKey protoKey = ProtoKey.read(reader);
        return MethodKey.create(declaring, name, protoKey);
    }
}

