/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.ProgramKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.util.Iterator;

public class FieldKey
implements ProgramKey {
    private final TypeKey declaring;
    private final StringKey name;
    private final TypeKey type;

    FieldKey(TypeKey declaring, StringKey name, TypeKey type) {
        this.declaring = declaring;
        this.name = name;
        this.type = type;
    }

    @Override
    public ElementType getElementType() {
        return ElementType.FIELD;
    }

    @Override
    public TypeKey getDeclaring() {
        return this.declaring;
    }

    public StringKey getNameKey() {
        return this.name;
    }

    public String getName() {
        return this.getNameKey().getString();
    }

    public TypeKey getType() {
        return this.type;
    }

    public FieldKey changeDeclaring(TypeKey typeKey) {
        if (typeKey.equals(this.getDeclaring())) {
            return this;
        }
        return FieldKey.create(typeKey, this.getNameKey(), this.getType());
    }

    public FieldKey changeName(String name) {
        if (name.equals(this.getName())) {
            return this;
        }
        return FieldKey.create(this.getDeclaring(), name, this.getType());
    }

    public FieldKey changeName(StringKey name) {
        if (name.equals(this.getNameKey())) {
            return this;
        }
        return FieldKey.create(this.getDeclaring(), name, this.getType());
    }

    public FieldKey changeType(TypeKey typeKey) {
        if (typeKey.equals(this.getType())) {
            return this;
        }
        return FieldKey.create(this.getDeclaring(), this.getNameKey(), typeKey);
    }

    public Iterator<Key> mentionedKeys() {
        return CombiningIterator.singleThree(this, SingleIterator.of(this.getDeclaring()), SingleIterator.of(this.getNameKey()), SingleIterator.of(this.getType()));
    }

    @Override
    public FieldKey replaceKey(Key search, Key replace) {
        FieldKey result = this;
        if (search.equals(result)) {
            return (FieldKey)replace;
        }
        if (search.equals(result.getDeclaring())) {
            result = result.changeDeclaring((TypeKey)replace);
        }
        if (replace instanceof StringKey && search.equals(result.getNameKey())) {
            result = result.changeName((StringKey)replace);
        }
        if (replace instanceof TypeKey && search.equals(result.getType())) {
            result = result.changeType((TypeKey)replace);
        }
        return result;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getDeclaring().append(writer);
        writer.append('-');
        writer.append('>');
        this.appendDefinition(writer);
    }

    public void appendDefinition(SmaliWriter writer) throws IOException {
        this.getNameKey().appendSimpleName(writer);
        writer.append(':');
        this.getType().append(writer);
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == null) {
            return -1;
        }
        FieldKey key = (FieldKey)obj;
        int i = CompareUtil.compare(this.getDeclaring(), key.getDeclaring());
        if (i != 0) {
            return i;
        }
        i = CompareUtil.compare(this.getNameKey(), key.getNameKey());
        if (i != 0) {
            return i;
        }
        return CompareUtil.compare(this.getType(), key.getType());
    }

    public boolean equalsDeclaring(TypeKey declaring) {
        if (declaring == null) {
            return false;
        }
        return this.getDeclaring().equals(declaring);
    }

    public boolean equalsDeclaring(FieldKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.getDeclaring().equals(other.getDeclaring());
    }

    public boolean equalsIgnoreDeclaring(FieldKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.getName().equals(other.getName()) && this.getType().equals(other.getType());
    }

    public boolean equalsIgnoreName(FieldKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.getDeclaring().equals(other.getDeclaring()) && this.getType().equals(other.getType());
    }

    public boolean equalsName(FieldKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.getNameKey().equals(other.getNameKey());
    }

    public boolean equalsName(String name) {
        return ObjectsUtil.equals(this.getName(), name);
    }

    public boolean equalsType(TypeKey typeKey) {
        if (typeKey == null) {
            return false;
        }
        return this.getType().equals(typeKey);
    }

    public boolean equalsType(FieldKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.getType().equals(other.getType());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FieldKey)) {
            return false;
        }
        FieldKey other = (FieldKey)obj;
        return this.getDeclaring().equals(other.getDeclaring()) && this.getNameKey().equals(other.getNameKey()) && this.getType().equals(other.getType());
    }

    public int hashCode() {
        return ObjectsUtil.hash(this.getDeclaring(), this.getNameKey(), this.getType());
    }

    public String toString() {
        return this.getDeclaring() + "->" + this.getNameKey().getAsSimpleName() + ':' + this.getType();
    }

    public static FieldKey create(TypeKey declaring, StringKey name, TypeKey type) {
        if (declaring == null || name == null || type == null) {
            return null;
        }
        return new FieldKey(declaring, name, type);
    }

    public static FieldKey create(TypeKey declaring, String name, TypeKey type) {
        return FieldKey.create(declaring, StringKey.create(name), type);
    }

    public static FieldKey parse(String text) {
        return FieldKey.parse(text, 0);
    }

    public static FieldKey parse(String text, int start) {
        if (start + 6 >= text.length() || text.charAt(start) != 'L') {
            return null;
        }
        int i = text.indexOf("->", start);
        if (i < 0) {
            return null;
        }
        TypeKey declaring = TypeKey.parseBinaryType(text, start, i);
        if (declaring == null) {
            return null;
        }
        i = text.indexOf(58, start = start + declaring.getTypeName().length() + 2);
        if (i < 0 || i == start) {
            return null;
        }
        String name = text.substring(start, i);
        start = start + name.length() + 1;
        i = text.length();
        TypeKey type = TypeKey.parseBinaryType(text, start, i);
        return FieldKey.create(declaring, name, type);
    }

    public static FieldKey convert(Field field) {
        TypeKey declaring = TypeKey.convert(field.getDeclaringClass());
        TypeKey type = TypeKey.convert(field.getType());
        return FieldKey.create(declaring, field.getName(), type);
    }

    public static FieldKey read(SmaliReader reader) throws IOException {
        TypeKey declaring = TypeKey.read(reader);
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, '-');
        SmaliParseException.expect(reader, '>');
        StringKey name = StringKey.readSimpleName(reader, ':');
        reader.skip(1);
        TypeKey type = TypeKey.read(reader);
        return FieldKey.create(declaring, name, type);
    }
}

