/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.common.AnnotationVisibility;
import com.reandroid.dex.key.AnnotationElementKey;
import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyList;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.ComputeIterator;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Predicate;

public class AnnotationSetKey
extends KeyList<AnnotationItemKey> {
    private static final AnnotationSetKey EMPTY = new AnnotationSetKey(EMPTY_ARRAY);

    private AnnotationSetKey(Key[] elements) {
        super(elements, true);
    }

    public Iterator<TypeKey> getTypes() {
        return ComputeIterator.of(this.iterator(), AnnotationItemKey::getType);
    }

    public AnnotationSetKey removeElementIf(TypeKey typeKey, Predicate<? super AnnotationElementKey> predicate) {
        AnnotationSetKey result = this;
        KeyList itemKey = result.get(typeKey);
        if (itemKey == null) {
            return result;
        }
        int i = result.indexOf(itemKey);
        itemKey = itemKey.removeIf(predicate);
        return result.set(i, (AnnotationItemKey)itemKey);
    }

    public AnnotationSetKey removeElement(TypeKey typeKey, String name) {
        AnnotationSetKey result = this;
        AnnotationItemKey itemKey = result.get(typeKey);
        if (itemKey == null) {
            return result;
        }
        int i = result.indexOf(itemKey);
        itemKey = itemKey.remove(name);
        return result.set(i, itemKey);
    }

    public AnnotationSetKey changeType(TypeKey typeKey, TypeKey newType) {
        AnnotationSetKey result = this;
        AnnotationItemKey itemKey = result.get(typeKey);
        if (itemKey == null) {
            return result;
        }
        int i = result.indexOf(itemKey);
        itemKey = itemKey.changeType(newType);
        return result.set(i, itemKey).sorted();
    }

    public AnnotationSetKey renameElement(TypeKey typeKey, String name, String newName) {
        AnnotationSetKey result = this;
        AnnotationItemKey itemKey = result.get(typeKey);
        if (itemKey == null) {
            return result;
        }
        int i = result.indexOf(itemKey);
        itemKey = itemKey.rename(name, newName);
        return result.set(i, itemKey);
    }

    public AnnotationSetKey setAnnotation(TypeKey typeKey, String name, Key value) {
        AnnotationSetKey result = this;
        result = result.getOrCreate(typeKey);
        AnnotationItemKey itemKey = result.get(typeKey);
        int i = result.indexOf(itemKey);
        itemKey = itemKey.setValue(name, value);
        return result.set(i, itemKey);
    }

    public AnnotationSetKey getOrCreate(TypeKey typeKey, String name) {
        AnnotationSetKey result = this;
        result = result.getOrCreate(typeKey);
        AnnotationItemKey itemKey = result.get(typeKey);
        int i = result.indexOf(itemKey);
        itemKey = itemKey.getOrCreate(name);
        return result.set(i, itemKey);
    }

    public AnnotationSetKey setVisibility(TypeKey typeKey, AnnotationVisibility visibility) {
        AnnotationItemKey itemKey = this.get(typeKey);
        if (itemKey == null) {
            return this;
        }
        int i = this.indexOf(itemKey);
        itemKey = itemKey.changeVisibility(visibility);
        return this.set(i, itemKey);
    }

    public AnnotationSetKey getOrCreate(TypeKey typeKey) {
        AnnotationItemKey itemKey = this.get(typeKey);
        if (itemKey != null) {
            return this;
        }
        itemKey = AnnotationItemKey.create(AnnotationVisibility.BUILD, typeKey, new AnnotationElementKey[0]);
        return this.add(itemKey).sorted();
    }

    public Key getAnnotationValue(TypeKey typeKey, String name) {
        AnnotationItemKey itemKey = this.get(typeKey);
        if (itemKey != null) {
            return itemKey.get(name);
        }
        return null;
    }

    public boolean containsElement(TypeKey typeKey, String name) {
        AnnotationItemKey itemKey = this.get(typeKey);
        if (itemKey != null) {
            return itemKey.containsElement(name);
        }
        return false;
    }

    public boolean contains(TypeKey typeKey) {
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            AnnotationItemKey itemKey = (AnnotationItemKey)this.get(i);
            if (itemKey == null || !ObjectsUtil.equals(typeKey, itemKey.getType())) continue;
            return true;
        }
        return false;
    }

    public AnnotationItemKey get(TypeKey typeKey) {
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            AnnotationItemKey itemKey = (AnnotationItemKey)this.get(i);
            if (itemKey == null || !ObjectsUtil.equals(typeKey, itemKey.getType())) continue;
            return itemKey;
        }
        return null;
    }

    public AnnotationSetKey add(AnnotationItemKey item) {
        if (item == null) {
            return this;
        }
        return this.remove(item.getType()).addUnchecked(item).sorted();
    }

    private AnnotationSetKey addUnchecked(AnnotationItemKey item) {
        return (AnnotationSetKey)super.add(item);
    }

    public AnnotationSetKey remove(AnnotationItemKey itemKey) {
        return (AnnotationSetKey)super.remove(itemKey);
    }

    public AnnotationSetKey remove(int index) {
        return (AnnotationSetKey)super.remove(index);
    }

    public AnnotationSetKey removeIf(Predicate<? super AnnotationItemKey> predicate) {
        return (AnnotationSetKey)super.removeIf(predicate);
    }

    public AnnotationSetKey remove(TypeKey typeKey) {
        return this.removeIf((T item) -> item.equalsType(typeKey));
    }

    public AnnotationSetKey set(int i, AnnotationItemKey item) {
        return (AnnotationSetKey)super.set(i, item);
    }

    public AnnotationSetKey sorted() {
        return (AnnotationSetKey)super.sorted();
    }

    public AnnotationSetKey clearDuplicates() {
        return (AnnotationSetKey)super.clearDuplicates();
    }

    public AnnotationSetKey clearDuplicates(Comparator<? super AnnotationItemKey> comparator) {
        return (AnnotationSetKey)super.clearDuplicates(comparator);
    }

    AnnotationSetKey newInstance(Key[] elements) {
        return AnnotationSetKey.createKey(elements);
    }

    @Override
    public AnnotationSetKey replaceKey(Key search, Key replace) {
        return (AnnotationSetKey)super.replaceKey(search, replace);
    }

    public void appendClass(SmaliWriter writer) throws IOException {
        int size = this.size();
        if (size == 0) {
            return;
        }
        writer.newLine();
        writer.newLine();
        writer.newLine();
        writer.appendComment("annotations");
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                writer.newLine();
            }
            writer.newLine();
            ((AnnotationItemKey)this.get(i)).append(writer);
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            writer.newLine();
            ((AnnotationItemKey)this.get(i)).append(writer);
        }
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof AnnotationSetKey)) {
            return 0;
        }
        return this.compareElements((AnnotationSetKey)obj);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AnnotationSetKey)) {
            return false;
        }
        return this.equalsElements((AnnotationSetKey)obj);
    }

    @Override
    public int hashCode() {
        return this.getHashCode();
    }

    public static AnnotationSetKey empty() {
        return EMPTY;
    }

    public static AnnotationSetKey of(AnnotationItemKey ... elements) {
        return AnnotationSetKey.createKey(elements);
    }

    private static AnnotationSetKey createKey(Key[] elements) {
        if (elements == null || elements.length == 0) {
            return AnnotationSetKey.empty();
        }
        if ((elements = AnnotationSetKey.removeNulls(elements)).length == 0) {
            return AnnotationSetKey.empty();
        }
        return new AnnotationSetKey(elements);
    }

    public static AnnotationSetKey create(Iterator<AnnotationItemKey> iterator) {
        ArrayCollection<AnnotationItemKey> elements = null;
        while (iterator.hasNext()) {
            AnnotationItemKey key = iterator.next();
            if (elements == null) {
                elements = new ArrayCollection<AnnotationItemKey>();
            }
            elements.add(key);
        }
        if (elements == null) {
            return AnnotationSetKey.empty();
        }
        return AnnotationSetKey.createKey(elements.toArrayFill(new Key[elements.size()]));
    }

    public static AnnotationSetKey combined(Iterator<AnnotationSetKey> iterator) {
        ArrayCollection elements = null;
        while (iterator.hasNext()) {
            AnnotationSetKey key = iterator.next();
            if (key.isEmpty()) continue;
            if (elements == null) {
                if (!iterator.hasNext()) {
                    return key;
                }
                elements = new ArrayCollection();
            }
            elements.addAll(key.iterator());
        }
        if (elements == null) {
            return AnnotationSetKey.empty();
        }
        return AnnotationSetKey.createKey(elements.toArrayFill(new Key[elements.size()]));
    }
}

