/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.common.AnnotationVisibility;
import com.reandroid.dex.key.AnnotationElementKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyList;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsStore;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Predicate;

public class AnnotationItemKey
extends KeyList<AnnotationElementKey>
implements Key,
Iterable<AnnotationElementKey> {
    private final AnnotationVisibility visibility;
    private final TypeKey type;

    private AnnotationItemKey(AnnotationVisibility visibility, TypeKey type, Key[] elements) {
        super(elements, true);
        this.visibility = visibility;
        this.type = type;
    }

    public boolean hasVisibility() {
        return this.getVisibility() != null;
    }

    public AnnotationVisibility getVisibility() {
        return this.visibility;
    }

    public TypeKey getType() {
        return this.type;
    }

    public AnnotationItemKey changeType(TypeKey typeKey) {
        if (typeKey.equals(this.getType())) {
            return this;
        }
        return AnnotationItemKey.createKey(this.getVisibility(), typeKey, this.getElements());
    }

    public AnnotationItemKey remove(String name) {
        return this.removeIf((T elementKey) -> ObjectsUtil.equals(elementKey.getName(), name));
    }

    public AnnotationItemKey rename(String name, String newName) {
        AnnotationItemKey result = this;
        AnnotationElementKey elementKey = result.get(name);
        if (elementKey == null) {
            return result;
        }
        int i = result.indexOf(elementKey);
        elementKey = elementKey.changeName(newName);
        return result.set(i, elementKey).sorted();
    }

    public AnnotationItemKey setValue(String name, Key value) {
        AnnotationItemKey result = this;
        result = result.getOrCreate(name);
        AnnotationElementKey elementKey = result.get(name);
        int i = result.indexOf(elementKey);
        elementKey = elementKey.changeValue(value);
        return result.set(i, elementKey);
    }

    public AnnotationItemKey getOrCreate(String name) {
        AnnotationElementKey elementKey = this.get(name);
        if (elementKey != null) {
            return this;
        }
        return this.add(AnnotationElementKey.create(name, null)).sorted();
    }

    public AnnotationItemKey changeVisibility(AnnotationVisibility visibility) {
        if (ObjectsUtil.equals(this.getVisibility(), visibility)) {
            return this;
        }
        return AnnotationItemKey.createKey(visibility, this.getType(), this.getElements());
    }

    public AnnotationElementKey get(String name) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            AnnotationElementKey elementKey = (AnnotationElementKey)this.get(i);
            if (elementKey == null || !ObjectsUtil.equals(name, elementKey.getName())) continue;
            return elementKey;
        }
        return null;
    }

    public Key getValue(String name) {
        AnnotationElementKey element = this.get(name);
        if (element != null) {
            return element.getValue();
        }
        return null;
    }

    public boolean containsElement(String name) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            AnnotationElementKey elementKey = (AnnotationElementKey)this.get(i);
            if (elementKey == null || !ObjectsUtil.equals(name, elementKey.getName())) continue;
            return true;
        }
        return false;
    }

    public AnnotationItemKey add(String name, Key value) {
        return this.add(AnnotationElementKey.create(name, value));
    }

    public AnnotationItemKey add(AnnotationElementKey item) {
        if (item == null) {
            return this;
        }
        return this.remove(item.getName()).addUnchecked(item).sorted();
    }

    private AnnotationItemKey addUnchecked(AnnotationElementKey item) {
        return (AnnotationItemKey)super.add(item);
    }

    public AnnotationItemKey remove(AnnotationElementKey itemKey) {
        return (AnnotationItemKey)super.remove(itemKey);
    }

    public AnnotationItemKey remove(int index) {
        return (AnnotationItemKey)super.remove(index);
    }

    public AnnotationItemKey removeIf(Predicate<? super AnnotationElementKey> predicate) {
        return (AnnotationItemKey)super.removeIf(predicate);
    }

    public AnnotationItemKey set(int i, AnnotationElementKey item) {
        return (AnnotationItemKey)super.set(i, item);
    }

    public AnnotationItemKey sorted() {
        return (AnnotationItemKey)super.sorted();
    }

    public AnnotationItemKey clearDuplicates() {
        return (AnnotationItemKey)super.clearDuplicates();
    }

    public AnnotationItemKey clearDuplicates(Comparator<? super AnnotationElementKey> comparator) {
        return (AnnotationItemKey)super.clearDuplicates(comparator);
    }

    AnnotationItemKey newInstance(Key[] elements) {
        return AnnotationItemKey.createKey(this.getVisibility(), this.getType(), elements);
    }

    public SmaliDirective getSmaliDirective() {
        if (this.hasVisibility()) {
            return SmaliDirective.ANNOTATION;
        }
        return SmaliDirective.SUB_ANNOTATION;
    }

    public Iterator<MethodKey> getMethods() {
        TypeKey typeKey = this.getType();
        return ComputeIterator.of(this.iterator(), elementKey -> elementKey.toMethod(typeKey));
    }

    @Override
    public AnnotationItemKey replaceKey(Key search, Key replace) {
        if (this.equals(search)) {
            return (AnnotationItemKey)replace;
        }
        AnnotationItemKey result = this;
        if (search instanceof MethodKey) {
            result = result.replaceMethodKeys((MethodKey)search, (MethodKey)replace);
        } else if (search.equals(this.getType())) {
            result = result.changeType((TypeKey)replace);
        }
        return (AnnotationItemKey)result.replaceElements(search, replace);
    }

    private AnnotationItemKey replaceMethodKeys(MethodKey search, MethodKey replace) {
        AnnotationElementKey element;
        String replaceName;
        String name;
        AnnotationItemKey result = this;
        TypeKey declaring = result.getType();
        if (!declaring.equals(search.getDeclaring())) {
            return result;
        }
        TypeKey replaceType = replace.getDeclaring();
        if (!declaring.equals(replaceType)) {
            result = result.changeType(replaceType);
        }
        if (!(name = search.getName()).equals(replaceName = replace.getName()) && !this.containsElement(replaceName) && (element = result.get(name)) != null) {
            result = result.set(this.indexOf(element), element.changeName(replaceName));
        }
        return result;
    }

    @Override
    public Iterator<? extends Key> mentionedKeys() {
        return CombiningIterator.singleTwo(this.getType(), super.mentionedKeys(), this.getMethods());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getSmaliDirective().append(writer);
        writer.appendOptional(this.getVisibility());
        this.getType().append(writer);
        writer.indentPlus();
        writer.appendAllWithDoubleNewLine(this.iterator());
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof AnnotationItemKey)) {
            return -1;
        }
        AnnotationItemKey itemKey = (AnnotationItemKey)obj;
        return CompareUtil.compare(this.getType(), itemKey.getType());
    }

    @Override
    int computeHash() {
        return ObjectsUtil.hash(this.getVisibility(), this.getType()) * 31 + super.computeHash();
    }

    public boolean equalsType(TypeKey typeKey) {
        return ObjectsUtil.equals(this.getType(), typeKey);
    }

    public boolean equalsMethod(MethodKey methodKey) {
        return methodKey != null && ObjectsUtil.equals(this.getType(), methodKey.getDeclaring()) && this.containsElement(methodKey.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AnnotationItemKey)) {
            return false;
        }
        AnnotationItemKey other = (AnnotationItemKey)obj;
        return this.hashCode() == other.hashCode() && ObjectsUtil.equals(this.getVisibility(), other.getVisibility()) && ObjectsUtil.equals(this.getType(), other.getType()) && this.equalsElements(other);
    }

    @Override
    public int hashCode() {
        return this.getHashCode();
    }

    public static AnnotationItemKey create(AnnotationVisibility visibility, TypeKey typeKey, AnnotationElementKey ... elements) {
        return AnnotationItemKey.createKey(visibility, typeKey, elements);
    }

    private static AnnotationItemKey createKey(AnnotationVisibility visibility, TypeKey typeKey, Key[] elements) {
        if (typeKey == null) {
            return null;
        }
        return new AnnotationItemKey(visibility, typeKey, AnnotationItemKey.removeNulls(elements));
    }

    public static AnnotationItemKey read(SmaliReader reader) throws IOException {
        Object[] elements;
        reader.skipWhitespacesOrComment();
        SmaliDirective directive = SmaliDirective.parse(reader);
        if (directive != SmaliDirective.ANNOTATION && directive != SmaliDirective.SUB_ANNOTATION) {
            throw new SmaliParseException("Expecting annotation directive", reader);
        }
        AnnotationVisibility visibility = null;
        if (directive == SmaliDirective.ANNOTATION && (visibility = AnnotationVisibility.parse(reader)) == null) {
            throw new SmaliParseException("Unrecognized annotation visibility", reader);
        }
        reader.skipWhitespacesOrComment();
        TypeKey typeKey = TypeKey.read(reader);
        reader.skipWhitespacesOrComment();
        Object elementList = null;
        while (!directive.isEnd(reader)) {
            int position = reader.position();
            AnnotationElementKey element = AnnotationElementKey.read(reader);
            if (AnnotationItemKey.containsElementName(elementList, element.getName())) {
                reader.position(position);
                throw new SmaliParseException("Duplicate element name: " + element.getName(), reader);
            }
            elementList = ObjectsStore.add(elementList, element);
            reader.skipWhitespacesOrComment();
        }
        SmaliParseException.expect(reader, directive, true);
        if (elementList != null) {
            elements = new Key[ObjectsStore.size(elementList)];
            ObjectsStore.collect(elementList, elements);
        } else {
            elements = null;
        }
        return AnnotationItemKey.createKey(visibility, typeKey, (Key[])elements);
    }

    private static boolean containsElementName(Object elementList, String name) {
        int size = ObjectsStore.size(elementList);
        for (int i = 0; i < size; ++i) {
            AnnotationElementKey elementKey = (AnnotationElementKey)ObjectsStore.get(elementList, i);
            if (!name.equals(elementKey.getName())) continue;
            return true;
        }
        return false;
    }

    public static AnnotationItemKey parse(String text) {
        throw new RuntimeException("AnnotationItemKey.parse not implemented");
    }
}

