/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.io;

import com.reandroid.dex.io.ByteReader;
import java.io.IOException;
import java.io.InputStream;

public class StreamUtil {
    public static ByteReader createByteReader(byte[] bytes, int offset) {
        return new ByteArrayReader(bytes, offset);
    }

    public static ByteReader createByteReader(byte[] bytes) {
        return new ByteArrayReader(bytes, 0);
    }

    public static ByteReader createByteReader(InputStream inputStream) {
        return new ByteInputStreamReader(inputStream);
    }

    static class ByteArrayReader
    implements ByteReader {
        private final byte[] bytes;
        private final int offset;
        private int index;

        ByteArrayReader(byte[] bytes, int offset) {
            this.bytes = bytes;
            this.offset = offset;
        }

        @Override
        public int read() throws IOException {
            int i = this.bytes[this.offset + this.index] & 0xFF;
            ++this.index;
            return i;
        }

        @Override
        public int count() {
            return this.index;
        }
    }

    static class ByteInputStreamReader
    implements ByteReader {
        private final InputStream inputStream;
        private int count;

        ByteInputStreamReader(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public int read() throws IOException {
            int i = this.inputStream.read();
            if (i == -1) {
                throw new IOException("Finished reading: " + this.inputStream);
            }
            ++this.count;
            return i;
        }

        @Override
        public int count() {
            return this.count;
        }
    }
}

