/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.dex.common.Register;
import com.reandroid.dex.common.RegisterType;
import com.reandroid.dex.common.RegistersTable;
import com.reandroid.dex.ins.RegistersSet;

public class RegisterReference
extends Register {
    private final RegistersSet registersSet;
    private final int index;

    public RegisterReference(RegistersTable registersTable, RegistersSet registersSet, int index) {
        super(0, false, registersTable);
        this.registersSet = registersSet;
        this.index = index;
    }

    public Editor toEditor() {
        return new Editor(this);
    }

    @Override
    public int getNumber() {
        int local;
        int register = this.getValue();
        if (register >= (local = this.getLocalRegistersCount())) {
            register -= local;
        }
        return register;
    }

    @Override
    public boolean isParameter() {
        return this.getValue() >= this.getLocalRegistersCount();
    }

    @Override
    public int getValue() {
        return this.getRegistersSet().getRegister(this.getIndex());
    }

    public void setRegisterValue(int register) {
        this.getRegistersSet().setRegister(this.getIndex(), register);
    }

    public int getIndex() {
        return this.index;
    }

    public int getLocalRegistersCount() {
        RegistersTable table = this.getRegistersTable();
        return table.getRegistersCount() - table.getParameterRegistersCount();
    }

    public RegistersSet getRegistersSet() {
        return this.registersSet;
    }

    public RegisterType getRegisterType() {
        return this.getRegistersSet().getRegisterFormat().get(this.getIndex());
    }

    public int getLimit() {
        return this.getRegistersSet().getRegisterLimit(this.getIndex());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegisterReference registerReference = (RegisterReference)obj;
        return this.isParameter() == registerReference.isParameter() && this.getNumber() == registerReference.getNumber();
    }

    public static class Editor
    extends RegisterReference {
        private final RegisterReference mBaseRegisterReference;
        private final int number;
        private final boolean parameter;

        public Editor(RegisterReference registerReference) {
            super(null, null, registerReference.getIndex());
            this.mBaseRegisterReference = registerReference;
            this.number = registerReference.getNumber();
            this.parameter = registerReference.isParameter();
        }

        public void apply() {
            RegisterReference baseRegisterReference = this.getBaseReg();
            baseRegisterReference.setRegisterValue(this.getValue());
        }

        private boolean isChanged() {
            RegisterReference baseRegisterReference = this.getBaseReg();
            return this.isParameter() == baseRegisterReference.isParameter() && this.getNumber() == baseRegisterReference.getNumber() && this.getValue() == baseRegisterReference.getValue();
        }

        @Override
        public int getValue() {
            int register = this.getNumber();
            if (this.isParameter()) {
                register += this.getLocalRegistersCount();
            }
            return register;
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public boolean isParameter() {
            return this.parameter;
        }

        @Override
        public int getIndex() {
            return this.getBaseReg().getIndex();
        }

        @Override
        public RegistersTable getRegistersTable() {
            return this.getBaseReg().getRegistersTable();
        }

        @Override
        public RegistersSet getRegistersSet() {
            return this.getBaseReg().getRegistersSet();
        }

        public RegisterReference getBaseReg() {
            return this.mBaseRegisterReference;
        }
    }
}

