/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.common.ArraySupplier;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsBlockList;
import com.reandroid.dex.ins.InsSparseSwitch;
import com.reandroid.dex.ins.InsSwitchPayload;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.PackedSwitchDataList;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliPayloadSparseSwitch;
import com.reandroid.dex.smali.model.SmaliSparseSwitchEntry;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.ArraySupplierIterator;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;

public class InsSparseSwitchData
extends InsSwitchPayload
implements ArraySupplier<SparseSwitchEntry> {
    private final ShortItem elementCount = new ShortItem();
    final CountedBlockList<IntegerItem> elements;
    final CountedBlockList<EntryKey> keys;
    boolean mSortRequired;

    public InsSparseSwitchData() {
        super(3, Opcode.SPARSE_SWITCH_PAYLOAD);
        Creator<EntryKey> entryKeyCreator = EntryKey::new;
        this.elements = new CountedBlockList<IntegerItem>(IntegerItem.CREATOR, this.elementCount);
        this.keys = new CountedBlockList<EntryKey>(entryKeyCreator, this.elementCount);
        this.addChild(1, this.elementCount);
        this.addChild(2, this.elements);
        this.addChild(3, this.keys);
    }

    @Override
    public Iterator<InsSwitchPayload.SwitchEntry> iterator() {
        return (Iterator)ObjectsUtil.cast(this.getLabels());
    }

    public SparseSwitchEntry newEntry() {
        int index = this.getCount();
        this.setCount(index + 1);
        return this.get(index);
    }

    @Override
    public SparseSwitchEntry get(int i) {
        if (i < 0 || i >= this.getCount()) {
            return null;
        }
        return new SparseSwitchEntry(this, (IntegerReference)this.elements.get(i), (EntryKey)this.keys.get(i));
    }

    public boolean remove(InsSwitchPayload.SwitchEntry entry) {
        if (!(entry instanceof SparseSwitchEntry)) {
            return false;
        }
        SparseSwitchEntry switchEntry = (SparseSwitchEntry)entry;
        InsBlockList insBlockList = this.getInsBlockList();
        insBlockList.link();
        boolean removed = this.elements.remove((IntegerItem)switchEntry.element);
        if (removed) {
            this.keys.remove(switchEntry.key);
        }
        insBlockList.unlink();
        return removed;
    }

    @Override
    public int getCount() {
        return this.elements.size();
    }

    public void setCount(int count) {
        int previous = this.getCount();
        boolean linked = false;
        InsBlockList insBlockList = this.getInsBlockList();
        if (count != previous && insBlockList != null) {
            linked = insBlockList.isLinked();
            insBlockList.link();
        }
        this.elements.setSize(count);
        this.keys.setSize(count);
        this.elementCount.set(count);
        if (insBlockList != null && !linked) {
            insBlockList.unlink();
        }
    }

    public void sort() {
        if (!this.mSortRequired) {
            return;
        }
        this.mSortRequired = false;
        Comparator comparator = (item1, item2) -> CompareUtil.compare(item1.get(), item2.get());
        if (!this.elements.needsSort(comparator)) {
            return;
        }
        this.elements.sort(comparator, this.keys);
    }

    public Iterator<SparseSwitchEntry> getLabels() {
        return new ArraySupplierIterator<SparseSwitchEntry>(this);
    }

    public int getBaseAddress() {
        InsSparseSwitch sparseSwitch = this.getSwitch();
        if (sparseSwitch == null) {
            return 0;
        }
        return sparseSwitch.getAddress();
    }

    public Opcode<InsSparseSwitch> getSwitchOpcode() {
        return Opcode.SPARSE_SWITCH;
    }

    @Override
    public InsSparseSwitch getSwitch() {
        return (InsSparseSwitch)super.getSwitch();
    }

    @Override
    protected void onPreRefresh() {
        this.sort();
        super.onPreRefresh();
    }

    void fromPackedSwitchData(PackedSwitchDataList packedSwitchDataList) {
        int length = packedSwitchDataList.size();
        this.setCount(length);
        for (int i = 0; i < length; ++i) {
            this.get(i).fromPackedSwitch((PackedSwitchDataList.PackedSwitchEntry)packedSwitchDataList.get(i));
        }
    }

    @Override
    public void merge(Ins ins) {
        InsSparseSwitchData switchData = (InsSparseSwitchData)ins;
        int size = switchData.getCount();
        this.setCount(size);
        for (int i = 0; i < size; ++i) {
            this.get(i).merge(switchData.get(i));
        }
    }

    @Override
    public void fromSmali(SmaliInstruction smaliInstruction) {
        this.validateOpcode(smaliInstruction);
        SmaliPayloadSparseSwitch smaliPayload = (SmaliPayloadSparseSwitch)smaliInstruction;
        int count = smaliPayload.getCount();
        this.setCount(count);
        for (int i = 0; i < count; ++i) {
            this.get(i).fromSmali((SmaliSparseSwitchEntry)smaliPayload.getEntry(i));
        }
        this.mSortRequired = true;
    }

    @Override
    void toSmaliEntries(SmaliInstruction instruction) {
        super.toSmaliEntries(instruction);
        SmaliPayloadSparseSwitch smaliPayload = (SmaliPayloadSparseSwitch)instruction;
        int count = this.getCount();
        for (int i = 0; i < count; ++i) {
            smaliPayload.addEntry(this.get(i).toSmali());
        }
    }

    @Override
    public void appendCode(SmaliWriter writer) throws IOException {
        writer.append('.');
        writer.append(this.getSmaliDirective().getName());
        int size = this.getCount();
        writer.indentPlus();
        for (int i = 0; i < size; ++i) {
            this.get(i).append(writer);
        }
        writer.indentMinus();
        writer.newLine();
        this.getSmaliDirective().appendEnd(writer);
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.SPARSE_SWITCH;
    }

    public static class SparseSwitchEntry
    implements InsSwitchPayload.SwitchEntry {
        private final InsSparseSwitchData payload;
        private final IntegerReference element;
        private final EntryKey key;

        public SparseSwitchEntry(InsSparseSwitchData payload, IntegerReference element, EntryKey key) {
            this.payload = payload;
            this.element = element;
            this.key = key;
        }

        @Override
        public InsSparseSwitchData getPayload() {
            return this.payload;
        }

        @Override
        public int get() {
            return this.element.get();
        }

        @Override
        public void set(int value) {
            if (value != this.element.get()) {
                this.element.set(value);
                this.payload.mSortRequired = true;
            }
        }

        @Override
        public Ins getTargetIns() {
            Ins targetIns = this.key.getTargetIns();
            if (targetIns == null) {
                this.setTargetIns(this.findTargetIns());
                targetIns = this.key.getTargetIns();
            }
            return targetIns;
        }

        @Override
        public void setTargetIns(Ins targetIns) {
            Ins ins = this.key.getTargetIns();
            if (targetIns != ins) {
                this.key.setTargetIns(targetIns);
                if (targetIns != null) {
                    targetIns.addExtraLine(this);
                }
            }
        }

        public int getKey() {
            return this.key.get();
        }

        public void setKey(int value) {
            this.key.set(value);
        }

        @Override
        public int getSortOrder() {
            return 5;
        }

        @Override
        public int getAddress() {
            return this.payload.getAddress();
        }

        @Override
        public int getTargetAddress() {
            return this.getKey() + this.payload.getBaseAddress();
        }

        @Override
        public void setTargetAddress(int targetAddress) {
            this.setKey(targetAddress - this.payload.getBaseAddress());
        }

        @Override
        public String getLabelName() {
            return HexUtil.toHex(":sswitch_", this.getTargetAddress(), 1);
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.newLine();
            int value = this.get();
            writer.appendHex(value);
            writer.append(" -> ");
            writer.appendLabelName(this.getLabelName());
            writer.appendResourceIdComment(value);
        }

        @Override
        public void appendExtra(SmaliWriter writer) throws IOException {
            writer.appendLabelName(this.getLabelName());
            writer.appendComment(HexUtil.toSignedHex(this.get()));
        }

        public void removeSelf() {
            this.payload.remove(this);
        }

        public void fromPackedSwitch(PackedSwitchDataList.PackedSwitchEntry packedSwitchEntry) {
            this.set(packedSwitchEntry.get());
            Ins ins = packedSwitchEntry.getTargetIns();
            this.setTargetAddress(ins.getAddress());
            this.setTargetIns(ins);
            ins.addExtraLine(this);
        }

        public void merge(SparseSwitchEntry data) {
            this.set(data.get());
            this.setKey(data.getKey());
        }

        public void fromSmali(SmaliSparseSwitchEntry smaliEntry) {
            this.set(smaliEntry.getValue());
            this.setKey(smaliEntry.getRelativeOffset());
        }

        public SmaliSparseSwitchEntry toSmali() {
            SmaliSparseSwitchEntry entry = new SmaliSparseSwitchEntry();
            entry.getLabel().setLabelName(this.getLabelName());
            entry.setValue(this.get());
            return entry;
        }

        public int hashCode() {
            return ObjectsUtil.hash(this.payload, this.element);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SparseSwitchEntry data = (SparseSwitchEntry)obj;
            return this.element == data.element && this.payload == data.payload;
        }

        public String toString() {
            return HexUtil.toHex8(this.get()) + " -> " + this.getKey();
        }
    }

    static class EntryKey
    extends IntegerItem {
        private Ins targetIns;

        EntryKey() {
        }

        public Ins getTargetIns() {
            return this.targetIns;
        }

        public void setTargetIns(Ins targetIns) {
            this.targetIns = targetIns;
        }
    }
}

