/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.item.ByteArray;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsBlockList;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.SizeXIns;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class InsGoto
extends SizeXIns
implements Label {
    private Opcode<?> opcode;

    public InsGoto(Opcode<?> opcode) {
        super(opcode);
        this.opcode = opcode;
    }

    @Override
    public int getData() {
        int size = this.getOpcode().size();
        if (size == 2) {
            return this.getByteSigned();
        }
        if (size == 4) {
            return this.getShortSigned();
        }
        return this.getInteger();
    }

    @Override
    public void setData(int data) {
        int size = this.getOpcode().size();
        if (size == 2) {
            this.setByte(1, data);
        } else if (size == 4) {
            this.setShort(2, data);
        } else {
            this.setInteger(data);
        }
    }

    @Override
    public int getTargetAddress() {
        return this.getAddress() + this.getData();
    }

    @Override
    public void setTargetAddress(int targetAddress) {
        int data = targetAddress - this.getAddress();
        if (!this.canFitOpcode(data)) {
            Ins targetIns = null;
            InsBlockList insBlockList = this.getInsBlockList();
            if (insBlockList != null) {
                targetIns = insBlockList.getAtAddress(targetAddress);
            }
            this.ensureFittingOpcode(data);
            if (targetIns != null) {
                targetAddress = targetIns.getAddress();
            }
            data = targetAddress - this.getAddress();
        }
        this.setData(data);
    }

    @Override
    public String getLabelName() {
        return HexUtil.toHex(":goto_", this.getTargetAddress(), 1);
    }

    @Override
    public void appendCode(SmaliWriter writer) throws IOException {
        writer.append(this.getOpcode().getName());
        writer.append(' ');
        writer.appendLabelName(this.getLabelName());
    }

    @Override
    public int getSortOrder() {
        return 5;
    }

    @Override
    public int getCodeUnits() {
        return this.getOpcode().size() / 2;
    }

    @Override
    public Opcode<?> getOpcode() {
        return this.opcode;
    }

    private boolean canFitOpcode(int data) {
        int size = this.getOpcode().size();
        if (size == 2) {
            return data == (byte)data;
        }
        if (size == 4) {
            return data == (short)data;
        }
        return true;
    }

    private void ensureFittingOpcode(int data) {
        Opcode<InsGoto> opcode = null;
        int size = this.getOpcode().size();
        if (size == 2 && data != (byte)data) {
            opcode = data == (short)data ? Opcode.GOTO_16 : Opcode.GOTO_32;
        } else if (size == 4 && data != (short)data) {
            opcode = Opcode.GOTO_32;
        }
        if (opcode != null) {
            this.setOpcode(opcode);
        }
    }

    public void setOpcode(Opcode<InsGoto> opcode) {
        if (opcode == this.opcode) {
            return;
        }
        int data = this.getData();
        InsBlockList insBlockList = this.getInsBlockList();
        if (insBlockList != null) {
            insBlockList.link();
        }
        this.opcode = opcode;
        ByteArray byteArray = this.getValueBytes();
        byteArray.setSize(0);
        byteArray.setSize(opcode.size());
        byteArray.putShort(0, opcode.getValue());
        this.setData(data);
        if (insBlockList != null) {
            insBlockList.unlink();
        }
    }
}

