/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.LongReference;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.dex.base.DexBlockAlign;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.Ins22c;
import com.reandroid.dex.ins.InsArrayDataList;
import com.reandroid.dex.ins.InsBlockList;
import com.reandroid.dex.ins.InsFillArrayData;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.PayloadData;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliInstructionOperand;
import com.reandroid.dex.smali.model.SmaliPayloadArray;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.InstanceIterator;
import java.io.IOException;
import java.util.Iterator;

public class InsArrayData
extends PayloadData
implements SmaliRegion {
    private final DexBlockAlign blockAlign;
    private final InsArrayDataList entryList;

    public InsArrayData() {
        super(4, Opcode.ARRAY_PAYLOAD);
        ShortItem widthReference = new ShortItem();
        IntegerItem countReference = new IntegerItem();
        this.entryList = new InsArrayDataList(widthReference, (IntegerReference)countReference);
        this.blockAlign = new DexBlockAlign(this.entryList);
        this.blockAlign.setAlignment(2);
        this.addChild(1, widthReference);
        this.addChild(2, countReference);
        this.addChild(3, this.entryList);
        this.addChild(4, this.blockAlign);
    }

    public Iterator<InsFillArrayData> getInsFillArrayData() {
        InsBlockList insBlockList = this.getInsBlockList();
        if (insBlockList == null) {
            return EmptyIterator.of();
        }
        insBlockList.link();
        return InstanceIterator.of(this.getExtraLines(), InsFillArrayData.class);
    }

    public int size() {
        return this.getEntryList().size();
    }

    public void setSize(int size) {
        this.getEntryList().setSize(size);
        this.refreshAlignment();
    }

    public void clear() {
        this.getEntryList().clear();
        this.refreshAlignment();
    }

    public boolean isEmpty() {
        return this.getEntryList().isEmpty();
    }

    public LongReference get(int i) {
        return (LongReference)this.getEntryList().get(i);
    }

    public Iterator<LongReference> iterator() {
        return (Iterator)ObjectsUtil.cast(this.getEntryList().iterator());
    }

    public int getWidth() {
        return this.getEntryList().getWidth();
    }

    public void setWidth(int width) {
        this.getEntryList().setWidth(width);
        this.refreshAlignment();
    }

    public void put(int index, long value) {
        int changed = this.size();
        this.getEntryList().put(index, value);
        if (changed != this.size()) {
            this.refreshAlignment();
        }
    }

    public void addValue(long value) {
        this.getEntryList().addValue(value);
        this.refreshAlignment();
    }

    public void set(long[] values) {
        this.getEntryList().clear();
        this.addValues(values);
    }

    public void addValues(long[] values) {
        this.getEntryList().addValues(values);
        this.refreshAlignment();
    }

    public void addValues(int[] values) {
        this.getEntryList().addValues(values);
        this.refreshAlignment();
    }

    public void addValues(short[] values) {
        this.getEntryList().addValues(values);
        this.refreshAlignment();
    }

    public void addValues(byte[] values) {
        this.getEntryList().addValues(values);
        this.refreshAlignment();
    }

    public void addValues(char[] values) {
        this.getEntryList().addValues(values);
        this.refreshAlignment();
    }

    public void addValues(float[] values) {
        this.getEntryList().addValues(values);
        this.refreshAlignment();
    }

    public void addValues(double[] values) {
        this.getEntryList().addValues(values);
        this.refreshAlignment();
    }

    public long[] getValuesAsLong() {
        return this.getEntryList().getValues();
    }

    public int[] getValuesAsInt() {
        return this.getEntryList().getValuesAsInt();
    }

    public short[] getValuesAsShort() {
        return this.getEntryList().getValuesAsShort();
    }

    public byte[] getValuesAsByte() {
        return this.getEntryList().getValuesAsByte();
    }

    public char[] getValuesAsChar() {
        return this.getEntryList().getValuesAsChar();
    }

    public float[] getValuesAsFloat() {
        return this.getEntryList().getValuesAsFloat();
    }

    public double[] getValuesAsDouble() {
        return this.getEntryList().getValuesAsDouble();
    }

    @Override
    public Iterator<IntegerReference> getReferences() {
        return (Iterator)ObjectsUtil.cast(this.getEntryList().iterator());
    }

    InsArrayDataList getEntryList() {
        return this.entryList;
    }

    public void refreshAlignment() {
        this.blockAlign.align(this);
    }

    private TypeKey findNewArrayType() {
        Iterator<InsFillArrayData> iterator = this.getInsFillArrayData();
        while (iterator.hasNext()) {
            InsFillArrayData fillArrayData = iterator.next();
            Ins22c ins22c = fillArrayData.findNewArrayLazy();
            if (ins22c == null) continue;
            return (TypeKey)ins22c.getKey();
        }
        return null;
    }

    @Override
    public void appendCode(SmaliWriter writer) throws IOException {
        this.getSmaliDirective().append(writer);
        writer.appendInteger(this.getWidth());
        writer.indentPlus();
        this.getEntryList().append(this.findNewArrayType(), writer);
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
    }

    @Override
    public void merge(Ins ins) {
        InsArrayData coming = (InsArrayData)ins;
        this.getEntryList().merge(coming.getEntryList());
        this.refreshAlignment();
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.ARRAY_DATA;
    }

    @Override
    public void fromSmali(SmaliInstruction smaliInstruction) {
        this.validateOpcode(smaliInstruction);
        this.getEntryList().fromSmali((SmaliPayloadArray)smaliInstruction);
        this.refreshAlignment();
    }

    @Override
    void toSmaliOperand(SmaliInstruction instruction) {
        super.toSmaliOperand(instruction);
        SmaliInstructionOperand.SmaliDecimalOperand operand = (SmaliInstructionOperand.SmaliDecimalOperand)instruction.getOperand();
        operand.setNumber(this.getWidth());
    }

    @Override
    void toSmaliEntries(SmaliInstruction instruction) {
        super.toSmaliEntries(instruction);
        this.getEntryList().toSmali((SmaliPayloadArray)instruction);
    }
}

