/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.dex.base.DexException;
import com.reandroid.dex.common.OperandType;
import com.reandroid.dex.common.RegisterFormat;
import com.reandroid.dex.data.FixedDexContainerWithTool;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.ins.ExceptionLabel;
import com.reandroid.dex.ins.ExtraLine;
import com.reandroid.dex.ins.ExtraLineList;
import com.reandroid.dex.ins.InsBlockList;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliCodeSet;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliLabel;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.InstanceIterator;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;

public class Ins
extends FixedDexContainerWithTool
implements SmaliFormat {
    private final Opcode<?> opcode;
    private ExtraLineList extraLineList;
    private Ins targetIns;

    Ins(int childesCount, Opcode<?> opcode) {
        super(childesCount);
        this.opcode = opcode;
        this.extraLineList = ExtraLineList.EMPTY;
    }

    Ins(Opcode<?> opcode) {
        this(1, opcode);
    }

    public MethodDef getMethodDef() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            return instructionList.getMethodDef();
        }
        return null;
    }

    public MethodKey getMethodKey() {
        MethodDef methodDef = this.getMethodDef();
        if (methodDef != null) {
            return methodDef.getKey();
        }
        return null;
    }

    public Ins edit() {
        MethodDef methodDef = this.getMethodDef();
        InstructionList current = methodDef.getInstructionList();
        methodDef.edit();
        InstructionList update = methodDef.getInstructionList();
        if (current != update) {
            return update.get(this.getIndex());
        }
        return this;
    }

    InsBlockList getInsBlockList() {
        return this.getParentInstance(InsBlockList.class);
    }

    public InstructionList getInstructionList() {
        return this.getParentInstance(InstructionList.class);
    }

    public void updateTargetAddress() {
        if (this instanceof Label) {
            Ins target = this.getTargetIns();
            if (target == null) {
                throw new NullPointerException("Null target: " + this + ", " + this.getMethodKey());
            }
            ((Label)((Object)this)).setTargetAddress(target.getAddress());
        }
    }

    public void transferExtraLinesTo(Ins destination) {
        destination.extraLineList = ExtraLineList.add(this.extraLineList, destination.getExtraLines());
        Iterator<ExtraLine> iterator = destination.getExtraLines();
        while (iterator.hasNext()) {
            ExtraLine extraLine = iterator.next();
            extraLine.setTargetIns(null);
            extraLine.setTargetIns(destination);
        }
        Ins target = this.targetIns;
        if (target != null && destination instanceof Label) {
            destination.setTargetIns(target);
        }
        this.clearExtraLines();
    }

    public void replace(Ins ins) {
        if (ins == null || ins == this) {
            return;
        }
        InstructionList instructionList = this.getInstructionList();
        if (instructionList == null) {
            return;
        }
        instructionList.replace(this, ins);
    }

    public <T1 extends Ins> T1 replace(Opcode<T1> opcode) {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList == null) {
            throw new DexException("Missing parent " + InstructionList.class.getSimpleName());
        }
        return instructionList.replace(this, opcode);
    }

    public <T1 extends Ins> T1 createNext(Opcode<T1> opcode) {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList == null) {
            throw new DexException("Parent " + this.getClass().getSimpleName() + " == null");
        }
        return instructionList.createAt(this.getIndex() + 1, opcode);
    }

    public void moveTo(int index) {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList == null) {
            throw new DexException("Parent " + this.getClass().getSimpleName() + " == null");
        }
        instructionList.moveTo(this, index);
    }

    public boolean is(Opcode<?> opcode) {
        return opcode == this.getOpcode();
    }

    public Opcode<?> getOpcode() {
        return this.opcode;
    }

    public RegisterFormat getRegisterFormat() {
        return this.getOpcode().getRegisterFormat();
    }

    public int getCodeUnits() {
        return this.countBytes() / 2;
    }

    public int getOutSize() {
        return 0;
    }

    public int getAddress() {
        InsBlockList insBlockList = this.getInsBlockList();
        if (insBlockList != null) {
            return insBlockList.addressOf(this);
        }
        return -1;
    }

    void linkTargetIns() {
        Ins targetIns = this.targetIns;
        if (targetIns == null) {
            this.setTargetIns(this.findTargetIns());
        }
        if (this instanceof Label && this.targetIns == null) {
            throw new NullPointerException("Missing target: " + this + ", " + this.getMethodKey());
        }
    }

    void unLinkTargetIns() {
        Ins targetIns = this.targetIns;
        if (targetIns != null) {
            this.setTargetIns(null);
        }
        this.clearExtraLines();
    }

    public Ins getTargetIns() {
        Ins targetIns = this.ensureTargetNotRemoved();
        if (targetIns == null) {
            targetIns = this.findTargetIns();
            this.setTargetIns(targetIns);
            targetIns = this.targetIns;
        }
        return targetIns;
    }

    public void setTargetIns(Ins targetIns) {
        if (targetIns == this) {
            return;
        }
        if (targetIns != this.targetIns) {
            this.targetIns = targetIns;
            if (targetIns != null) {
                ((Label)((Object)this)).setTargetAddress(targetIns.getAddress());
                targetIns.addExtraLine((Label)((Object)this));
            }
        }
    }

    private Ins ensureTargetNotRemoved() {
        Ins target = this.targetIns;
        if (target != null && target.isRemoved()) {
            target = null;
            this.targetIns = null;
        }
        return target;
    }

    private Ins findTargetIns() {
        InsBlockList insBlockList;
        if (this instanceof Label && (insBlockList = this.getInsBlockList()) != null) {
            int targetAddress = ((Label)((Object)this)).getTargetAddress();
            Ins target = insBlockList.getAtAddress(targetAddress);
            if (targetAddress != 0 || target != this) {
                return target;
            }
        }
        return null;
    }

    public void addExtraLine(ExtraLine extraLine) {
        if (extraLine != this) {
            this.extraLineList = ExtraLineList.add(this.extraLineList, extraLine);
        }
    }

    public Iterator<ExtraLine> getExtraLines() {
        return this.extraLineList.iterator();
    }

    public <T1> Iterator<T1> getExtraLines(Class<T1> instance) {
        return this.extraLineList.iterator(instance);
    }

    public void clearExtraLines() {
        this.extraLineList = ExtraLineList.EMPTY;
    }

    public boolean hasExtraLines() {
        return !this.extraLineList.isEmpty();
    }

    private void appendExtraLines(SmaliWriter writer) throws IOException {
        Iterator<ExtraLine> iterator = this.getExtraLines();
        ExtraLine extraLine = null;
        boolean hasHandler = false;
        ExtraLine previous = null;
        while (iterator.hasNext()) {
            extraLine = iterator.next();
            if (extraLine.isEqualExtraLine(previous)) continue;
            writer.newLine();
            extraLine.appendExtra(writer);
            if (!hasHandler) {
                hasHandler = extraLine.getSortOrder() == 3;
            }
            previous = extraLine;
        }
        if (hasHandler && extraLine.getSortOrder() >= 3) {
            writer.newLine();
        }
    }

    public void replaceKeys(Key search, Key replace) {
    }

    public Iterator<IdItem> usedIds() {
        return EmptyIterator.of();
    }

    public boolean isRemoved() {
        return this.getParent() == null;
    }

    public void merge(Ins ins) {
        throw new RuntimeException("merge method not implemented, opcode = " + this.getOpcode());
    }

    public void fromSmali(SmaliInstruction smaliInstruction) {
        throw new RuntimeException("fromSmali method not implemented, opcode = " + this.getOpcode());
    }

    public SmaliInstruction toSmali() {
        return this.toSmali(new SmaliCodeSet());
    }

    public SmaliInstruction toSmali(SmaliCodeSet smaliCodeSet) {
        SmaliInstruction instruction = smaliCodeSet.newInstruction(this.getOpcode());
        this.toSmali(instruction);
        return instruction;
    }

    private void toSmali(SmaliInstruction instruction) {
        if (instruction.getOperandType() != OperandType.NONE) {
            this.toSmaliOperand(instruction);
        }
        if (instruction.getRegisterFormat() != RegisterFormat.NONE) {
            this.toSmaliRegisters(instruction);
        }
        if (this.hasExtraLines() && instruction.getCodeSet() != null) {
            this.toSmaliExtraLines(instruction);
        }
        this.toSmaliOthers(instruction);
    }

    void toSmaliOperand(SmaliInstruction instruction) {
    }

    void toSmaliRegisters(SmaliInstruction instruction) {
    }

    void toSmaliExtraLines(SmaliInstruction instruction) {
        SmaliCodeSet smaliCodeSet = instruction.getCodeSet();
        Iterator<Label> iterator = InstanceIterator.of(this.getExtraLines(), Label.class, label -> !(label instanceof ExceptionLabel));
        Label previous = null;
        int index = smaliCodeSet.indexOf(instruction);
        while (iterator.hasNext()) {
            Label extraLine = iterator.next();
            if (extraLine.isEqualExtraLine(previous)) continue;
            SmaliLabel smaliLabel = new SmaliLabel();
            smaliCodeSet.add(index, smaliLabel);
            smaliLabel.setLabelName(extraLine.getLabelName());
            ++index;
            previous = extraLine;
        }
    }

    void toSmaliOthers(SmaliInstruction instruction) {
    }

    void validateOpcode(SmaliInstruction smaliInstruction) {
        if (this.getOpcode() != smaliInstruction.getOpcode()) {
            throw new DexException("Mismatch opcode " + this.getOpcode() + " vs " + smaliInstruction.getOpcode());
        }
    }

    @Override
    public final void append(SmaliWriter writer) throws IOException {
        this.appendExtraLines(writer);
        writer.newLine();
        this.appendCode(writer);
    }

    public void appendCode(SmaliWriter writer) throws IOException {
        writer.append(this.getOpcode().getName());
        writer.append(' ');
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        SmaliWriter smaliWriter = new SmaliWriter(writer);
        try {
            this.appendCode(smaliWriter);
            smaliWriter.close();
            return writer.toString().trim();
        }
        catch (Throwable exception) {
            return exception.toString();
        }
    }

    static int toSigned(int unsigned, int width) {
        int half = width / 2;
        if (unsigned <= half) {
            return unsigned;
        }
        return unsigned - width - 1;
    }
}

