/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.header;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.DirectStreamReader;
import com.reandroid.arsc.base.OffsetSupplier;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.header.CountAndOffset;
import com.reandroid.dex.header.DexChecksum;
import com.reandroid.dex.header.DexContainerInfo;
import com.reandroid.dex.header.DexVersion;
import com.reandroid.dex.header.Endian;
import com.reandroid.dex.header.Magic;
import com.reandroid.dex.header.Signature;
import com.reandroid.dex.header.UnknownHeaderBytes;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.sections.SpecialItem;
import com.reandroid.utils.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class DexHeader
extends SpecialItem
implements OffsetSupplier,
DirectStreamReader {
    public final Magic magic = new Magic();
    public final DexVersion version = new DexVersion();
    public final DexChecksum checksum = new DexChecksum();
    public final Signature signature = new Signature();
    public final IntegerReference fileSize = new IntegerItem();
    public final IntegerReference headerSize = new IntegerItem();
    public final Endian endian = new Endian();
    public final IntegerReference map = new IntegerItem();
    public final CountAndOffset string_id = new CountAndOffset();
    public final CountAndOffset type_id = new CountAndOffset();
    public final CountAndOffset proto_id = new CountAndOffset();
    public final CountAndOffset field_id = new CountAndOffset();
    public final CountAndOffset method_id = new CountAndOffset();
    public final CountAndOffset class_id = new CountAndOffset();
    public final CountAndOffset data = new CountAndOffset();
    public final DexContainerInfo containerInfo = new DexContainerInfo();
    public final UnknownHeaderBytes unknown = new UnknownHeaderBytes();

    public DexHeader() {
        super(17);
        this.addChildBlock(0, this.magic);
        this.addChildBlock(1, this.version);
        this.addChildBlock(2, this.checksum);
        this.addChildBlock(3, this.signature);
        this.addChildBlock(4, (Block)((Object)this.fileSize));
        this.addChildBlock(5, (Block)((Object)this.headerSize));
        this.addChildBlock(6, this.endian);
        this.addChildBlock(7, (Block)((Object)this.map));
        this.addChildBlock(8, this.string_id);
        this.addChildBlock(9, this.type_id);
        this.addChildBlock(10, this.proto_id);
        this.addChildBlock(11, this.field_id);
        this.addChildBlock(12, this.method_id);
        this.addChildBlock(13, this.class_id);
        this.addChildBlock(14, this.data);
        this.addChildBlock(15, this.containerInfo);
        this.addChildBlock(16, this.unknown);
        this.setOffsetReference(this.containerInfo.getOffsetReference());
    }

    public SectionType<DexHeader> getSectionType() {
        return SectionType.HEADER;
    }

    public int getVersion() {
        return this.version.getVersionAsInteger();
    }

    public void setVersion(int version) {
        this.version.setVersionAsInteger(version);
    }

    public CountAndOffset get(SectionType<?> sectionType) {
        if (sectionType == SectionType.STRING_ID) {
            return this.string_id;
        }
        if (sectionType == SectionType.TYPE_ID) {
            return this.type_id;
        }
        if (sectionType == SectionType.PROTO_ID) {
            return this.proto_id;
        }
        if (sectionType == SectionType.FIELD_ID) {
            return this.field_id;
        }
        if (sectionType == SectionType.METHOD_ID) {
            return this.method_id;
        }
        if (sectionType == SectionType.CLASS_ID) {
            return this.class_id;
        }
        return null;
    }

    @Override
    public IntegerReference getOffsetReference() {
        return this.containerInfo.getOffsetReference();
    }

    @Override
    public void setOffsetReference(IntegerReference reference) {
        if (reference != this.containerInfo.getOffsetReference()) {
            throw new RuntimeException("Header already has offset reference");
        }
    }

    public int getFileSize() {
        return this.fileSize.get();
    }

    @Override
    protected boolean isValidOffset(int offset) {
        return offset >= 0;
    }

    public boolean isClassDefinitionOrderEnforced() {
        return this.version.isClassDefinitionOrderEnforced();
    }

    public boolean isMultiLayoutVersion() {
        return this.version.isMultiLayoutVersion();
    }

    @Override
    public int readBytes(InputStream inputStream) throws IOException {
        int result = 0;
        int size = 17;
        for (int i = 0; i < size; ++i) {
            Block block = this.getChildBlockAt(i);
            result += ((DirectStreamReader)((Object)block)).readBytes(inputStream);
        }
        return result;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.nonCheckRead(reader);
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.headerSize.set(this.countBytes());
    }

    public boolean updateChecksum() {
        return this.checksum.update();
    }

    public void updateSignature() {
        this.signature.update();
    }

    public String toString() {
        return "Header {magic=" + this.magic + ", version=" + this.version + ", checksum=" + this.checksum + ", signature=" + this.signature + ", fileSize=" + this.fileSize + ", headerSize=" + this.headerSize + ", endian=" + this.endian + ", map=" + this.map + ", strings=" + this.string_id + ", type=" + this.type_id + ", proto=" + this.proto_id + ", field=" + this.field_id + ", method=" + this.method_id + ", clazz=" + this.class_id + ", data=" + this.data + ", container-v41" + this.containerInfo + ", unknown=" + this.unknown + '}';
    }

    public static DexHeader readHeader(File file) throws IOException {
        InputStream inputStream = FileUtil.inputStream(file);
        DexHeader dexHeader = DexHeader.readHeader(inputStream);
        inputStream.close();
        return dexHeader;
    }

    public static DexHeader readHeader(InputStream inputStream) throws IOException {
        DexHeader dexHeader = new DexHeader();
        dexHeader.magic.setDisableVerification(true);
        int read = dexHeader.readBytes(inputStream);
        if (read < dexHeader.countBytes()) {
            throw new IOException("Few bytes to read header: " + read);
        }
        return dexHeader;
    }

    public static DexHeader readHeader(byte[] bytes) throws IOException {
        DexHeader dexHeader = new DexHeader();
        dexHeader.magic.setDisableVerification(true);
        if (bytes.length < dexHeader.countBytes()) {
            throw new IOException("Few bytes to read header: " + bytes.length);
        }
        dexHeader.readBytes(new BlockReader(bytes));
        return dexHeader;
    }
}

