/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.debug;

import com.reandroid.dex.debug.DebugElement;
import com.reandroid.dex.debug.DebugElementType;
import com.reandroid.dex.debug.DebugStartLocal;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.reference.Base1Ule128IdItemReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliDebugLocal;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;

public class DebugStartLocalExtended
extends DebugStartLocal {
    private final Base1Ule128IdItemReference<StringId> mSignature = new Base1Ule128IdItemReference<StringId>(SectionType.STRING_ID);

    public DebugStartLocalExtended() {
        super(1, DebugElementType.START_LOCAL_EXTENDED);
        this.addChild(4, this.mSignature);
    }

    @Override
    public boolean isValid() {
        return !this.isRemoved() && this.mSignature.getItem() != null;
    }

    public String getSignature() {
        StringId stringId = (StringId)this.mSignature.getItem();
        if (stringId != null) {
            return stringId.getString();
        }
        return null;
    }

    public StringKey getSignatureKey() {
        return (StringKey)this.mSignature.getKey();
    }

    public void setSignature(String signature) {
        this.mSignature.setKey(StringKey.create(signature));
    }

    public void setSignature(StringKey key) {
        this.mSignature.setKey(key);
    }

    @Override
    public void appendExtra(SmaliWriter writer) throws IOException {
        if (this.isValid()) {
            super.appendExtra(writer);
            writer.append(", ");
            this.mSignature.append(writer);
        }
    }

    public DebugElementType<DebugStartLocalExtended> getElementType() {
        return DebugElementType.START_LOCAL_EXTENDED;
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return CombiningIterator.two(super.usedIds(), SingleIterator.of(this.mSignature.getItem()));
    }

    @Override
    public void merge(DebugElement element) {
        super.merge(element);
        DebugStartLocalExtended coming = (DebugStartLocalExtended)element;
        this.mSignature.setKey(coming.mSignature.getKey());
    }

    @Override
    public void fromSmali(Smali smali) {
        super.fromSmali(smali);
        this.setSignature(((SmaliDebugLocal)smali).getSignature());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DebugStartLocalExtended debug = (DebugStartLocalExtended)obj;
        return this.getFlag() == debug.getFlag() && this.getRegisterNumber() == debug.getRegisterNumber() && ObjectsUtil.equals(this.getName(), debug.getName()) && ObjectsUtil.equals(this.getType(), debug.getType()) && ObjectsUtil.equals(this.getSignature(), debug.getSignature());
    }

    @Override
    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.getFlag();
        hash = hash * 31 + this.getRegisterNumber();
        hash = hash * 31 + ObjectsUtil.hash(this.getName(), this.getType(), this.getSignature());
        return hash;
    }

    @Override
    public String toString() {
        return super.toString() + ", " + this.mSignature;
    }
}

