/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.common.ArraySupplier;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.data.CodeItem;
import com.reandroid.dex.data.DebugInfo;
import com.reandroid.dex.data.Def;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.data.MethodParameter;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.MethodId;
import com.reandroid.dex.id.ProtoId;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.TryBlock;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.program.MethodProgram;
import com.reandroid.dex.reference.DataItemUle128Reference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.dex.smali.model.SmaliMethodParameter;
import com.reandroid.utils.collection.ArraySupplierIterator;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.util.Iterator;
import java.util.Objects;

public class MethodDef
extends Def<MethodId>
implements MethodProgram {
    private final DataItemUle128Reference<CodeItem> codeOffset = new DataItemUle128Reference<CodeItem>(SectionType.CODE, UsageMarker.USAGE_DEFINITION);

    public MethodDef() {
        super(1, SectionType.METHOD_ID);
        this.addChild(2, this.codeOffset);
    }

    @Override
    public MethodKey getKey() {
        MethodId id = (MethodId)this.getId();
        if (id != null) {
            return id.getKey();
        }
        return null;
    }

    @Override
    public ElementType getElementType() {
        return ElementType.METHOD;
    }

    public String getName() {
        MethodId methodId = (MethodId)this.getId();
        if (methodId != null) {
            return methodId.getName();
        }
        return null;
    }

    public void setName(String name) {
        if (Objects.equals(this.getName(), name)) {
            return;
        }
        ((MethodId)this.getId()).setName(name);
    }

    public int getParametersCount() {
        MethodId methodId = (MethodId)this.getId();
        if (methodId != null) {
            return methodId.getParametersCount();
        }
        return 0;
    }

    public int getParameterRegistersCount() {
        MethodId methodId = (MethodId)this.getId();
        if (methodId != null) {
            int count = methodId.getParameterRegistersCount();
            if (!this.isStatic()) {
                ++count;
            }
            return count;
        }
        return 0;
    }

    public MethodParameter getParameter(int index) {
        if (index < 0 || index >= this.getParametersCount()) {
            return null;
        }
        return new MethodParameter(this, index);
    }

    public Iterator<MethodParameter> getParameters() {
        return ArraySupplierIterator.of(new ArraySupplier<MethodParameter>(){

            @Override
            public MethodParameter get(int i) {
                return MethodDef.this.getParameter(i);
            }

            @Override
            public int getCount() {
                return MethodDef.this.getParametersCount();
            }
        });
    }

    @Override
    void onRemove() {
        CodeItem codeItem = (CodeItem)this.codeOffset.getItem();
        if (codeItem != null) {
            codeItem.setMethodDef(null);
            this.codeOffset.setItem(null);
        }
        super.onRemove();
    }

    public void removeParameter(int index) {
        MethodParameter parameter = this.getParameter(index);
        if (parameter == null) {
            return;
        }
        parameter.onRemoved();
        MethodKey methodKey = this.getKey();
        if (methodKey == null) {
            return;
        }
        methodKey = methodKey.removeParameter(index);
        this.setItem(methodKey);
    }

    public void setDebugInfo(DebugInfo debugInfo) {
        CodeItem codeItem = this.getCodeItem();
        if (codeItem != null) {
            codeItem.setDebugInfo(debugInfo);
        }
    }

    public DebugInfo getDebugInfo() {
        CodeItem codeItem = this.getCodeItem();
        if (codeItem != null) {
            return codeItem.getDebugInfo();
        }
        return null;
    }

    public DebugInfo getOrCreateDebugInfo() {
        return this.getOrCreateCodeItem().getOrCreateDebugInfo();
    }

    public ProtoId getProtoId() {
        MethodId methodId = (MethodId)this.getId();
        if (methodId != null) {
            return methodId.getProtoId();
        }
        return null;
    }

    public Iterator<Ins> getInstructions() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            return instructionList.iterator();
        }
        return EmptyIterator.of();
    }

    public Ins getInstruction(int i) {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            return instructionList.get(i);
        }
        return null;
    }

    public Ins getInstructionAt(int address) {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            return instructionList.getAtAddress(address);
        }
        return null;
    }

    public int getInstructionsCount() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            return instructionList.getCount();
        }
        return 0;
    }

    public InstructionList getOrCreateInstructionList() {
        return this.getOrCreateCodeItem().getInstructionList();
    }

    public InstructionList getInstructionList() {
        CodeItem codeItem = this.getCodeItem();
        if (codeItem != null) {
            return codeItem.getInstructionList();
        }
        return null;
    }

    public TryBlock getTryBlock() {
        CodeItem codeItem = this.getCodeItem();
        if (codeItem != null) {
            return codeItem.getTryBlock();
        }
        return null;
    }

    public TryBlock getOrCreateTryBlock() {
        return this.getOrCreateCodeItem().getOrCreateTryBlock();
    }

    public CodeItem getOrCreateCodeItem() {
        CodeItem current = (CodeItem)this.codeOffset.getItem();
        CodeItem codeItem = this.codeOffset.getOrCreateUniqueItem(this);
        if (current == null) {
            codeItem.setMethodDef(this);
            int registers = this.getParameterRegistersCount();
            codeItem.setRegistersCount(registers);
            codeItem.setParameterRegistersCount(registers);
        }
        return codeItem;
    }

    public CodeItem getCodeItem() {
        CodeItem codeItem = (CodeItem)this.codeOffset.getItem();
        if (codeItem != null) {
            codeItem.setMethodDef(this);
        }
        return codeItem;
    }

    public void clearCode() {
        this.codeOffset.setItem(null);
    }

    public void clearDebug() {
        CodeItem codeItem = this.getCodeItem();
        if (codeItem != null) {
            codeItem.removeDebugInfo();
        }
    }

    private void linkCodeItem() {
        CodeItem codeItem = (CodeItem)this.codeOffset.getItem();
        if (codeItem != null) {
            codeItem.addUniqueUser(this);
            codeItem.setMethodDef(this);
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        this.linkCodeItem();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        MethodKey methodKey = this.getKey();
        if (methodKey == null) {
            throw new IOException("Null MethodKey");
        }
        writer.onWriteMethod(methodKey);
        writer.newLine();
        this.getSmaliDirective().append(writer);
        writer.appendModifiers(this.getModifiers());
        methodKey.appendDefinition(writer);
        writer.indentPlus();
        CodeItem codeItem = this.getCodeItem();
        if (codeItem != null) {
            codeItem.appendRegistersCount(writer);
        }
        writer.appendAll(this.getParameters(), false);
        this.getAnnotation().append(writer);
        if (codeItem != null) {
            codeItem.getInstructionList().append(writer);
        }
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
        writer.setCurrentRegistersTable(null);
    }

    @Override
    public void replaceKeys(Key search, Key replace) {
        super.replaceKeys(search, replace);
        CodeItem codeItem = this.getCodeItem();
        if (codeItem != null) {
            codeItem.replaceKeys(search, replace);
        }
    }

    @Override
    public void edit() {
        CodeItem shared = (CodeItem)this.codeOffset.getItem();
        CodeItem unique = this.codeOffset.getUniqueItem(this);
        if (unique != null) {
            unique.setMethodDef(this);
            if (shared != unique) {
                unique.edit();
                shared.getInstructionList().onEditing(unique.getInstructionList());
            }
            unique.flattenTryItems();
        }
    }

    @Override
    public void editInternal(Block user) {
        this.edit();
    }

    @Override
    public Iterator<IdItem> usedIds() {
        CodeItem codeItem = this.getCodeItem();
        Iterator<Object> iterator = codeItem == null ? EmptyIterator.of() : codeItem.usedIds();
        return CombiningIterator.singleOne(this.getId(), iterator);
    }

    @Override
    public void merge(Def<?> def) {
        super.merge(def);
        MethodDef comingMethod = (MethodDef)def;
        CodeItem comingCode = comingMethod.getCodeItem();
        if (comingCode != null) {
            this.codeOffset.setKey(comingCode.getKey());
        }
    }

    @Override
    public void fromSmali(Smali smali) {
        SmaliMethod smaliMethod = (SmaliMethod)smali;
        this.setKey(smaliMethod.getKey());
        this.setAccessFlagsValue(smaliMethod.getAccessFlagsValue());
        this.addHiddenApiFlags(smaliMethod.getHiddenApiFlags());
        if (smaliMethod.hasInstructions()) {
            this.getOrCreateCodeItem().fromSmali(smaliMethod);
        }
        if (smaliMethod.hasAnnotation()) {
            this.setAnnotation(smaliMethod.getAnnotationSetKey());
        }
        Iterator<SmaliMethodParameter> iterator = smaliMethod.getParameters();
        while (iterator.hasNext()) {
            SmaliMethodParameter smaliMethodParameter = iterator.next();
            int index = smaliMethodParameter.getDefinitionIndex();
            if (index < 0) {
                MethodKey methodKey = smaliMethod.getKey();
                throw new RuntimeException("Parameter out of range, class = " + methodKey.getDeclaring() + ", method = " + methodKey.getName() + methodKey.getProto() + "\n" + smaliMethodParameter);
            }
            MethodParameter parameter = this.getParameter(index);
            parameter.fromSmali(smaliMethodParameter);
        }
        this.linkCodeItem();
    }

    @Override
    public SmaliMethod toSmali() {
        SmaliMethod smaliMethod = new SmaliMethod();
        smaliMethod.setKey(this.getKey());
        smaliMethod.setAccessFlags(AccessFlag.valuesOfField(this.getAccessFlagsValue()));
        smaliMethod.setHiddenApiFlags(this.getHiddenApiFlags());
        smaliMethod.setAnnotation(this.getAnnotationKeys());
        CodeItem codeItem = this.getCodeItem();
        if (codeItem != null) {
            codeItem.toSmali(smaliMethod);
        }
        return smaliMethod;
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.METHOD;
    }

    public String toString() {
        if (this.isReading()) {
            return this.getSmaliDirective() + " " + Modifier.toString(this.getModifiers()) + this.getKey();
        }
        MethodId methodId = (MethodId)this.getId();
        if (methodId != null) {
            return this.getSmaliDirective() + " " + Modifier.toString(this.getModifiers()) + methodId.toString();
        }
        return this.getSmaliDirective() + " " + Modifier.toString(this.getAccessFlags()) + " " + this.getRelativeIdValue();
    }
}

