/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.key.ArrayKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyList;
import com.reandroid.dex.reference.IntegerDataReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.ComputeIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Predicate;

public class IntegerDataItemList<T extends DataItem>
extends DataItem
implements Iterable<T> {
    private final CountedBlockList<IntegerDataReference<T>> referenceList;
    private final DexPositionAlign positionAlign;

    public IntegerDataItemList(SectionType<T> sectionType, int usageType, DexPositionAlign positionAlign) {
        super(3);
        this.positionAlign = positionAlign;
        IntegerItem countReference = new IntegerItem();
        this.referenceList = new CountedBlockList<T>(new ReferenceCreator<T>(sectionType, usageType), countReference);
        this.addChildBlock(0, countReference);
        this.addChildBlock(1, this.referenceList);
        this.addChildBlock(2, positionAlign);
    }

    @Override
    public KeyList<?> getKey() {
        Key[] elements = new Key[this.size()];
        this.getItemKeys(elements);
        return ArrayKey.create(elements);
    }

    public void setKey(Key key) {
        KeyList keyList = (KeyList)key;
        int size = keyList.size();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            this.getReference(i).setKey((Key)keyList.get(i));
        }
    }

    public int size() {
        return this.referenceList.size();
    }

    public void setSize(int size) {
        this.referenceList.setSize(size);
    }

    public void clear() {
        this.setSize(0);
    }

    private void ensureSize(int size) {
        this.referenceList.ensureSize(size);
    }

    private IntegerDataReference<T> createNext() {
        return (IntegerDataReference)this.referenceList.createNext();
    }

    private IntegerDataReference<T> getReference(int i) {
        return (IntegerDataReference)this.referenceList.get(i);
    }

    private IntegerDataReference<T> getOrCreateReference(int i) {
        this.ensureSize(i + 1);
        return (IntegerDataReference)this.referenceList.get(i);
    }

    public T addNewItem(Key key) {
        IntegerDataReference<T> item = this.createNext();
        item.setKey(key);
        return (T)item.getItem();
    }

    public void addNewItem(T item) {
        IntegerDataReference<T> reference = this.createNext();
        reference.setItem(item);
    }

    public T addNewItem() {
        return this.createNext().getOrCreate();
    }

    public T getOrCreateAt(int index) {
        return this.getOrCreateReference(index).getOrCreate();
    }

    public Key getItemKey(int i) {
        IntegerDataReference<T> reference = this.getReference(i);
        if (reference != null) {
            return reference.getKey();
        }
        return null;
    }

    public T setItemKeyAt(int index, Key key) {
        IntegerDataReference<T> reference = this.getOrCreateReference(index);
        reference.setKey(key);
        return (T)reference.getItem();
    }

    public void clearAt(int index) {
        IntegerDataReference<Object> reference = this.getReference(index);
        if (reference != null) {
            reference.setItem((Object)null);
        }
    }

    void getItemKeys(Key[] out) {
        int length = out.length;
        for (int i = 0; i < length; ++i) {
            out[i] = this.getItemKey(i);
        }
    }

    @Override
    public void removeSelf() {
        this.clear();
        super.removeSelf();
    }

    public void remove(T item) {
        this.removeIf(t -> t == item);
    }

    public boolean removeIf(Predicate<? super T> filter) {
        return this.referenceList.removeIf(reference -> filter.test(reference.getItem()));
    }

    void removeNulls() {
        this.referenceList.removeIf(reference -> reference.getItem() == null);
    }

    @Override
    public Iterator<T> iterator() {
        return ComputeIterator.of(this.referenceList.iterator(), IntegerDataReference::getItem);
    }

    public T getItem(int i) {
        IntegerDataReference<T> reference = this.getReference(i);
        if (reference != null) {
            return (T)reference.getItem();
        }
        return null;
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public boolean sort(Comparator<? super T> comparator) {
        this.removeNulls();
        return this.referenceList.sort((ref1, ref2) -> comparator.compare(ref1.getItem(), ref2.getItem()));
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.removeNulls();
    }

    @Override
    public void editInternal(Block user) {
        user = this;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.getReference(i).editInternal(user);
        }
    }

    public DexPositionAlign getPositionAlign() {
        return this.positionAlign;
    }

    public int hashCode() {
        int hash = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            hash = hash * 31 + ObjectsUtil.hash(this.getItem(i));
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerDataItemList itemList = (IntegerDataItemList)obj;
        int size = this.size();
        if (size != itemList.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (ObjectsUtil.equals(this.getItem(i), itemList.getItem(i))) continue;
            return false;
        }
        return true;
    }

    static class ReferenceCreator<T extends DataItem>
    implements Creator<IntegerDataReference<T>> {
        private final SectionType<T> sectionType;
        private final int usageType;

        ReferenceCreator(SectionType<T> sectionType, int usageType) {
            this.sectionType = sectionType;
            this.usageType = usageType;
        }

        @Override
        public IntegerDataReference<T> newInstance() {
            return new IntegerDataReference<T>(this.sectionType, this.usageType);
        }
    }
}

