/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.base.Ule128Item;
import com.reandroid.dex.common.HiddenApiFlag;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.data.Def;
import com.reandroid.dex.data.HiddenApiFlagValueList;
import com.reandroid.dex.data.HiddenApiRestrictions;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public class HiddenApiFlagValue
extends Ule128Item
implements BlockRefresh,
Iterable<HiddenApiFlag>,
SmaliFormat,
Comparable<HiddenApiFlagValue> {
    private Def<?> def;

    public HiddenApiFlagValue() {
        this.set(HiddenApiFlag.NO_RESTRICTION);
    }

    Def<?> getDef() {
        return this.def;
    }

    HiddenApiFlagValue newCompact() {
        return new Compact(this);
    }

    void linkDef(Def<?> def) {
        this.def = def;
        def.linkHiddenApiFlagValueInternal(this);
    }

    public void removeSelf() {
        HiddenApiFlagValueList flagValueList = this.getParentInstance(HiddenApiFlagValueList.class);
        if (flagValueList != null) {
            flagValueList.remove(this);
        }
    }

    public boolean isEmpty() {
        Def<?> def = this.getDef();
        return def == null || def.isRemoved();
    }

    public boolean isRemoved() {
        return this.getParentInstance(HiddenApiRestrictions.class) == null;
    }

    public boolean isNoRestriction() {
        return this.isEmpty() || this.get() == HiddenApiFlag.NO_RESTRICTION;
    }

    public HiddenApiFlag getRestriction() {
        return HiddenApiFlag.restrictionOf(this.get());
    }

    public HiddenApiFlag getDomain() {
        return HiddenApiFlag.domainOf(this.get());
    }

    public void add(HiddenApiFlag flag) {
        int restrict = HiddenApiFlag.NO_RESTRICTION;
        int domain = 0;
        if (flag.isDomainFlag()) {
            HiddenApiFlag keep = this.getRestriction();
            if (keep != null) {
                restrict = keep.getValue();
            }
            domain = flag.getValue();
        } else {
            HiddenApiFlag keep = this.getDomain();
            if (keep != null) {
                domain = keep.getValue();
            }
            restrict = flag.getValue();
        }
        this.set(domain | restrict);
    }

    public void remove(HiddenApiFlag flag) {
        int restrict = HiddenApiFlag.NO_RESTRICTION;
        int domain = 0;
        if (flag.isDomainFlag()) {
            HiddenApiFlag keep = this.getRestriction();
            if (keep != null) {
                restrict = keep.getValue();
            }
        } else {
            HiddenApiFlag keep = this.getDomain();
            if (keep != null) {
                domain = keep.getValue();
            }
        }
        this.set(domain | restrict);
    }

    public void clear() {
        this.set(HiddenApiFlag.NO_RESTRICTION);
    }

    @Override
    public Iterator<HiddenApiFlag> iterator() {
        return HiddenApiFlag.valuesOf(this.get());
    }

    @Override
    public void refresh() {
        Def<?> def = this.def;
        if (def == null) {
            this.set(HiddenApiFlag.NO_RESTRICTION);
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.appendModifiers(this.iterator());
    }

    @Override
    public int compareTo(HiddenApiFlagValue hiddenApiFlagValue) {
        if (hiddenApiFlagValue == null) {
            return -1;
        }
        if (hiddenApiFlagValue == this) {
            return 0;
        }
        return SectionTool.compareIndex(this.def, hiddenApiFlagValue.def);
    }

    public int hashCode() {
        return this.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HiddenApiFlagValue)) {
            return false;
        }
        HiddenApiFlagValue flagValue = (HiddenApiFlagValue)obj;
        return this.get() == flagValue.get();
    }

    @Override
    public String toString() {
        return Modifier.toString(this.iterator());
    }

    static class Compact
    extends HiddenApiFlagValue {
        private final HiddenApiFlagValue source;

        Compact(HiddenApiFlagValue source) {
            this.source = source;
        }

        @Override
        public void onReadBytes(BlockReader reader) throws IOException {
        }

        @Override
        public int countBytes() {
            return 0;
        }

        @Override
        public int get() {
            return this.source.get();
        }

        @Override
        public void set(int value) {
            this.source.set(value);
        }

        @Override
        protected void writeValue(int value) {
        }

        @Override
        protected int onWriteBytes(OutputStream stream) throws IOException {
            return 0;
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public byte[] getBytes() {
            return null;
        }
    }
}

