/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.base.Ule128Item;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.ArrayKey;
import com.reandroid.dex.key.ArrayValueKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.NullValue;
import com.reandroid.dex.value.SectionValue;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.InstanceIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Predicate;

public class EncodedArray
extends DataItem
implements KeyReference,
Iterable<DexValueBlock<?>> {
    private final Ule128Item valuesCountReference = new Ule128Item();
    private final BlockList<DexValueBlock<?>> valueList = new BlockList();
    private static final Creator<DexValueBlock<?>> CREATOR = () -> NullValue.PLACE_HOLDER;

    public EncodedArray() {
        super(2);
        this.valueList.setCreator(CREATOR);
        this.addChildBlock(0, this.valuesCountReference);
        this.addChildBlock(1, this.valueList);
    }

    @Override
    public ArrayValueKey getKey() {
        int size = this.size();
        Key[] keys = new Key[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.get(i).getKey();
        }
        return this.checkKey(ArrayValueKey.of(keys));
    }

    @Override
    public void setKey(Key key) {
        ArrayKey arrayKey = (ArrayKey)key;
        this.clear();
        int size = arrayKey.size();
        for (int i = 0; i < size; ++i) {
            this.add((Key)arrayKey.get(i));
        }
    }

    public SectionType<EncodedArray> getSectionType() {
        return SectionType.ENCODED_ARRAY;
    }

    public DexValueBlock<?> get(int i) {
        return this.getValueList().get(i);
    }

    public Key getValueKey(int i) {
        DexValueBlock<?> value = this.get(i);
        if (value != null) {
            return value.getKey();
        }
        return null;
    }

    public <T1 extends IdItem> SectionValue<T1> getOrCreate(SectionType<T1> sectionType, int i) {
        return this.getOrCreate(DexValueType.get(sectionType), i);
    }

    public <T1 extends DexValueBlock<?>> T1 getOrCreate(DexValueType<T1> valueType, int i) {
        BlockList<DexValueBlock<?>> array = this.getValueList();
        array.ensureSize(i + 1);
        Block value = array.get(i);
        if (value == null || value == NullValue.PLACE_HOLDER || ((DexValueBlock)value).getValueType() != valueType) {
            value = valueType.newInstance();
            array.set(i, (DexValueBlock<?>)value);
        }
        return (T1)value;
    }

    public int size() {
        return this.getValueList().getCount();
    }

    public void add(Key key) {
        Block valueBlock = DexValueType.forKey(key).newInstance();
        this.add((DexValueBlock<?>)valueBlock);
        ((DexValueBlock)valueBlock).setKey(key);
    }

    public void add(DexValueBlock<?> value) {
        this.getValueList().add(value);
    }

    public boolean remove(int index) {
        return this.getValueList().remove(index) != null;
    }

    public boolean remove(DexValueBlock<?> value) {
        return this.getValueList().remove(value);
    }

    public boolean removeIf(Predicate<? super DexValueBlock<?>> filter) {
        return this.getValueList().removeIf(filter);
    }

    public void set(int i, DexValueBlock<?> value) {
        this.ensureSize(i + 1);
        this.getValueList().set(i, value);
    }

    public void clear() {
        this.getValueList().clearChildes();
    }

    public void ensureSize(int size) {
        if (size > this.size()) {
            this.setSize(size);
        }
    }

    public void setSize(int size) {
        if (size < 0) {
            throw new IndexOutOfBoundsException("Invalid size: " + size);
        }
        this.valuesCountReference.set(size);
        BlockList<DexValueBlock<?>> valueList = this.getValueList();
        if (size == 0) {
            valueList.setSize(0);
            return;
        }
        int current = valueList.size();
        if (size <= current) {
            if (size < current) {
                valueList.setSize(size);
            }
            return;
        }
        NullValue placeHolder = NullValue.PLACE_HOLDER;
        int remain = size - current;
        valueList.ensureCapacity(remain);
        for (int i = 0; i < remain; ++i) {
            valueList.add(placeHolder);
        }
    }

    @Override
    public Iterator<DexValueBlock<?>> iterator() {
        return this.getValueList().iterator();
    }

    public <T1 extends DexValueBlock<?>> Iterator<T1> iterator(Class<T1> instance) {
        return InstanceIterator.of(this.iterator(), instance);
    }

    public <T1 extends DexValueBlock<?>> Iterator<T1> iterator(Class<T1> instance, Predicate<? super T1> filter) {
        return InstanceIterator.of(this.iterator(), instance, filter);
    }

    public Iterator<DexValueBlock<?>> iterator(int start, int length) {
        return this.getValueList().iterator(start, length);
    }

    public Iterator<DexValueBlock<?>> clonedIterator() {
        return this.getValueList().clonedIterator();
    }

    private BlockList<DexValueBlock<?>> getValueList() {
        return this.valueList;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.valuesCountReference.onReadBytes(reader);
        BlockList<DexValueBlock<?>> valueList = this.getValueList();
        int count = this.valuesCountReference.get();
        valueList.ensureCapacity(count);
        for (int i = 0; i < count; ++i) {
            DexValueBlock<?> dexValue = DexValueType.create(reader);
            valueList.add(dexValue);
            dexValue.onReadBytes(reader);
        }
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.valuesCountReference.set(this.size());
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return new IterableIterator<DexValueBlock<?>, IdItem>(this.iterator()){

            @Override
            public Iterator<IdItem> iterator(DexValueBlock<?> element) {
                return element.usedIds();
            }
        };
    }

    @Override
    public void copyFrom(DataItem item) {
        EncodedArray other = (EncodedArray)item;
        this.merge(other);
    }

    public void merge(EncodedArray array) {
        int size = array.size();
        this.getValueList().ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            DexValueBlock<?> coming = array.get(i);
            Object valueBlock = this.getOrCreate(coming.getValueType(), i);
            ((DexValueBlock)valueBlock).merge(coming);
        }
    }

    public int hashCode() {
        int hash = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            hash = hash * 31 + this.get(i).hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EncodedArray array = (EncodedArray)obj;
        int size = this.size();
        if (size != array.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (ObjectsUtil.equals(this.get(i), array.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        Iterator<DexValueBlock<?>> iterator = this.iterator();
        boolean appendOnce = false;
        while (iterator.hasNext()) {
            if (appendOnce) {
                builder.append(", ");
            }
            builder.append(iterator.next());
            appendOnce = true;
        }
        builder.append(']');
        return builder.toString();
    }
}

