/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.base.Ule128Item;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.debug.DebugElement;
import com.reandroid.dex.debug.DebugParameter;
import com.reandroid.dex.debug.DebugSequence;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.DataKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class DebugInfo
extends DataItem
implements KeyReference {
    private final Ule128Item lineStart = new Ule128Item(true);
    private final Ule128Item debugParameterCount = new Ule128Item();
    private BlockList<DebugParameter> debugParametersArray;
    private final DebugSequence debugSequence = new DebugSequence(this.lineStart);
    private final DataKey<DebugInfo> debugKey;
    private static final Creator<DebugParameter> CREATOR = DebugParameter::new;

    public DebugInfo() {
        super(4);
        this.addChildBlock(0, this.lineStart);
        this.addChildBlock(1, this.debugParameterCount);
        this.addChildBlock(3, this.debugSequence);
        this.debugKey = new DataKey<DebugInfo>(this);
    }

    public void removeInvalidElements() {
        DebugSequence debugSequence = this.getDebugSequence();
        if (debugSequence != null) {
            debugSequence.removeInvalid();
        }
    }

    @Override
    public DataKey<DebugInfo> getKey() {
        return this.debugKey;
    }

    @Override
    public void setKey(Key key) {
        DataKey debugKey = (DataKey)key;
        this.merge((DebugInfo)debugKey.getItem());
    }

    public SectionType<DebugInfo> getSectionType() {
        return SectionType.DEBUG_INFO;
    }

    public int getParameterCount() {
        if (this.debugParametersArray != null) {
            return this.debugParametersArray.size();
        }
        return 0;
    }

    public DebugParameter getDebugParameter(int index) {
        BlockList<DebugParameter> debugParametersArray = this.debugParametersArray;
        if (debugParametersArray != null) {
            return debugParametersArray.get(index);
        }
        return null;
    }

    public DebugParameter getOrCreateDebugParameter(int index) {
        BlockList<DebugParameter> debugParametersArray = this.initParametersArray();
        debugParametersArray.ensureSize(index + 1);
        return debugParametersArray.get(index);
    }

    public void removeDebugParameter(int index) {
        BlockList<DebugParameter> parameterNames = this.debugParametersArray;
        if (parameterNames == null) {
            return;
        }
        DebugParameter parameter = parameterNames.get(index);
        if (parameter == null) {
            return;
        }
        if (index == parameterNames.getCount() - 1) {
            parameterNames.remove(parameter);
        } else {
            parameter.set(0);
        }
        parameterNames.refresh();
    }

    public Iterator<DebugParameter> getParameters() {
        if (this.debugParametersArray != null) {
            return this.debugParametersArray.iterator();
        }
        return EmptyIterator.of();
    }

    public Iterator<DebugElement> getExtraLines() {
        return this.getDebugSequence().getExtraLines();
    }

    public DebugSequence getDebugSequence() {
        return this.debugSequence;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.lineStart.onReadBytes(reader);
        this.debugParameterCount.onReadBytes(reader);
        if (this.debugParameterCount.get() > 0) {
            BlockList<DebugParameter> array = this.initParametersArray();
            array.setSize(this.debugParameterCount.get());
            array.readChildes(reader);
        }
        this.debugSequence.onReadBytes(reader);
    }

    private BlockList<DebugParameter> initParametersArray() {
        BlockList<DebugParameter> debugParametersArray = this.debugParametersArray;
        if (debugParametersArray == null) {
            debugParametersArray = new BlockList();
            this.debugParametersArray = debugParametersArray;
            this.addChildBlock(2, debugParametersArray);
            debugParametersArray.setCreator(CREATOR);
        }
        return debugParametersArray;
    }

    public void onRemove() {
        BlockList<DebugParameter> array = this.debugParametersArray;
        if (array != null) {
            this.debugParametersArray = null;
            array.clearChildes();
        }
        this.debugSequence.clear();
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.removeInvalidElements();
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        int count = 0;
        if (this.debugParametersArray != null) {
            count = this.debugParametersArray.size();
        }
        this.debugParameterCount.set(count);
    }

    @Override
    public Iterator<IdItem> usedIds() {
        IterableIterator<DebugParameter, IdItem> iterator1 = new IterableIterator<DebugParameter, IdItem>(this.getParameters()){

            @Override
            public Iterator<IdItem> iterator(DebugParameter element) {
                return element.usedIds();
            }
        };
        return CombiningIterator.two(iterator1, this.getDebugSequence().usedIds());
    }

    public void merge(DebugInfo debugInfo) {
        if (debugInfo == this) {
            return;
        }
        this.lineStart.set(debugInfo.lineStart.get());
        int count = debugInfo.getParameterCount();
        this.debugParameterCount.set(count);
        if (count != 0) {
            BlockList<DebugParameter> array = this.initParametersArray();
            array.setSize(count);
            for (int i = 0; i < count; ++i) {
                DebugParameter comingParameter = debugInfo.getDebugParameter(i);
                DebugParameter parameter = array.get(i);
                parameter.merge(comingParameter);
            }
        }
        this.getDebugSequence().merge(debugInfo.getDebugSequence());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DebugInfo debugInfo = (DebugInfo)obj;
        return this.lineStart.get() == this.lineStart.get() && Objects.equals(this.debugParametersArray, debugInfo.debugParametersArray) && Objects.equals(this.debugSequence, debugInfo.debugSequence);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.lineStart.get();
        BlockList<DebugParameter> array = this.debugParametersArray;
        hash *= 31;
        if (array != null) {
            hash += array.hashCode();
        }
        hash *= 31;
        return hash += this.debugSequence.hashCode();
    }

    public String toString() {
        return "DebugInfo{lineStart=" + this.lineStart.get() + ", parameterCount=" + this.debugParameterCount.get() + ", sequence=(" + this.debugSequence + ")}";
    }
}

