/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.base.Ule128Item;
import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.data.Def;
import com.reandroid.dex.data.DefArray;
import com.reandroid.dex.data.FieldDef;
import com.reandroid.dex.data.FieldDefArray;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.data.MethodDefArray;
import com.reandroid.dex.data.StaticFieldDefArray;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliClass;
import com.reandroid.dex.smali.model.SmaliDef;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;

public class ClassData
extends DataItem
implements SmaliFormat {
    private final Ule128Item staticFieldsCount = new Ule128Item();
    private final Ule128Item instanceFieldsCount = new Ule128Item();
    private final Ule128Item directMethodsCount = new Ule128Item();
    private final Ule128Item virtualMethodCount = new Ule128Item();
    private StaticFieldDefArray staticFields;
    private FieldDefArray instanceFields;
    private MethodDefArray directMethods;
    private MethodDefArray virtualMethods;
    private ClassId mClassId;

    public ClassData() {
        super(8);
        this.addChildBlock(0, this.staticFieldsCount);
        this.addChildBlock(1, this.instanceFieldsCount);
        this.addChildBlock(2, this.directMethodsCount);
        this.addChildBlock(3, this.virtualMethodCount);
    }

    public SectionType<ClassData> getSectionType() {
        return SectionType.CLASS_DATA;
    }

    public void remove(Key key) {
        Def<?> def = this.get(key);
        if (def != null) {
            def.removeSelf();
        }
    }

    public Def<?> get(Key key) {
        if (key instanceof FieldKey) {
            return this.getField((FieldKey)key);
        }
        if (key instanceof MethodKey) {
            return this.getMethod((MethodKey)key);
        }
        if (key != null) {
            throw new RuntimeException("Unknown key type: " + key.getClass() + ", '" + key + "'");
        }
        return null;
    }

    public FieldDef getField(FieldKey key) {
        FieldDef fieldDef = null;
        FieldDefArray fieldDefArray = this.staticFields;
        if (fieldDefArray != null) {
            fieldDef = (FieldDef)fieldDefArray.get(key);
        }
        if (fieldDef == null && (fieldDefArray = this.instanceFields) != null) {
            fieldDef = (FieldDef)fieldDefArray.get(key);
        }
        return fieldDef;
    }

    public MethodDef getMethod(MethodKey key) {
        MethodDef methodDef = null;
        MethodDefArray methodDefArray = this.directMethods;
        if (methodDefArray != null) {
            methodDef = (MethodDef)methodDefArray.get(key);
        }
        if (methodDef == null && (methodDefArray = this.virtualMethods) != null) {
            methodDef = (MethodDef)methodDefArray.get(key);
        }
        return methodDef;
    }

    public FieldDef getOrCreateStatic(FieldKey fieldKey) {
        FieldDef fieldDef = (FieldDef)this.initStaticFieldsArray().getOrCreate(fieldKey);
        fieldDef.addAccessFlag(AccessFlag.STATIC);
        return fieldDef;
    }

    public FieldDef getOrCreateInstance(FieldKey fieldKey) {
        return (FieldDef)this.initInstanceFieldsArray().getOrCreate(fieldKey);
    }

    public MethodDef getOrCreateDirect(MethodKey methodKey) {
        return (MethodDef)this.initDirectMethodsArray().getOrCreate(methodKey);
    }

    public MethodDef getOrCreateVirtual(MethodKey methodKey) {
        return (MethodDef)this.initVirtualMethodsArray().getOrCreate(methodKey);
    }

    public Iterator<FieldDef> getFields() {
        return new CombiningIterator(this.getStaticFields(), this.getInstanceFields());
    }

    public Iterator<MethodDef> getMethods() {
        return new CombiningIterator(this.getDirectMethods(), this.getVirtualMethods());
    }

    public Iterator<MethodDef> getDirectMethods() {
        MethodDefArray methodDefArray = this.directMethods;
        if (methodDefArray == null) {
            return EmptyIterator.of();
        }
        return methodDefArray.arrayIterator();
    }

    public Iterator<MethodDef> getVirtualMethods() {
        MethodDefArray methodDefArray = this.virtualMethods;
        if (methodDefArray == null) {
            return EmptyIterator.of();
        }
        return methodDefArray.arrayIterator();
    }

    public Iterator<FieldDef> getStaticFields() {
        StaticFieldDefArray fieldDefArray = this.staticFields;
        if (fieldDefArray == null) {
            return EmptyIterator.of();
        }
        return fieldDefArray.arrayIterator();
    }

    public Iterator<FieldDef> getInstanceFields() {
        FieldDefArray fieldDefArray = this.instanceFields;
        if (fieldDefArray == null) {
            return EmptyIterator.of();
        }
        return fieldDefArray.arrayIterator();
    }

    public StaticFieldDefArray getStaticFieldsArray() {
        return this.staticFields;
    }

    public FieldDefArray getInstanceFieldsArray() {
        return this.instanceFields;
    }

    public MethodDefArray getDirectMethodsArray() {
        return this.directMethods;
    }

    public MethodDefArray getVirtualMethodArray() {
        return this.virtualMethods;
    }

    private FieldDefArray initStaticFieldsArray() {
        StaticFieldDefArray defArray = this.staticFields;
        if (defArray == null) {
            this.staticFields = defArray = new StaticFieldDefArray(this.staticFieldsCount);
            this.addChildBlock(4, this.staticFields);
            defArray.setClassId(this.getClassId());
        }
        return defArray;
    }

    private FieldDefArray initInstanceFieldsArray() {
        FieldDefArray defArray = this.instanceFields;
        if (defArray == null) {
            this.instanceFields = defArray = new FieldDefArray(this.instanceFieldsCount);
            this.addChildBlock(5, this.instanceFields);
            defArray.setClassId(this.getClassId());
        }
        return defArray;
    }

    private MethodDefArray initDirectMethodsArray() {
        MethodDefArray defArray = this.directMethods;
        if (defArray == null) {
            this.directMethods = defArray = new MethodDefArray(this.directMethodsCount);
            this.addChildBlock(6, defArray);
            defArray.setClassId(this.getClassId());
        }
        return defArray;
    }

    private MethodDefArray initVirtualMethodsArray() {
        MethodDefArray defArray = this.virtualMethods;
        if (defArray == null) {
            this.virtualMethods = defArray = new MethodDefArray(this.virtualMethodCount);
            this.addChildBlock(7, defArray);
            defArray.setClassId(this.getClassId());
        }
        return defArray;
    }

    private Iterator<DefArray<?>> getDefArrays() {
        return CombiningIterator.four(SingleIterator.of(this.staticFields), SingleIterator.of(this.instanceFields), SingleIterator.of(this.directMethods), SingleIterator.of(this.virtualMethods));
    }

    public ClassId getClassId() {
        return this.mClassId;
    }

    public void setClassId(ClassId classId) {
        this.mClassId = classId;
        Iterator<DefArray<?>> iterator = this.getDefArrays();
        while (iterator.hasNext()) {
            iterator.next().setClassId(classId);
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        if (this.staticFieldsCount.get() != 0) {
            this.initStaticFieldsArray().onReadBytes(reader);
        }
        if (this.instanceFieldsCount.get() != 0) {
            this.initInstanceFieldsArray().onReadBytes(reader);
        }
        if (this.directMethodsCount.get() != 0) {
            this.initDirectMethodsArray().onReadBytes(reader);
        }
        if (this.virtualMethodCount.get() != 0) {
            this.initVirtualMethodsArray().onReadBytes(reader);
        }
    }

    @Override
    public boolean isBlank() {
        return ClassData.isNullOrEmpty(this.staticFields) && ClassData.isNullOrEmpty(this.instanceFields) && ClassData.isNullOrEmpty(this.directMethods) && ClassData.isNullOrEmpty(this.virtualMethods);
    }

    @Override
    public void removeSelf() {
        super.removeSelf();
        Iterator<DefArray<?>> iterator = this.getDefArrays();
        while (iterator.hasNext()) {
            iterator.next().clearChildes();
        }
        this.setClassId(null);
    }

    public void replaceKeys(Key search, Key replace) {
        Iterator<DefArray<?>> iterator = this.getDefArrays();
        while (iterator.hasNext()) {
            iterator.next().replaceKeys(search, replace);
        }
    }

    @Override
    public void editInternal(Block user) {
        if (this.staticFields != null) {
            this.staticFields.editInternal(user);
        }
        if (this.instanceFields != null) {
            this.instanceFields.editInternal(user);
        }
        if (this.directMethods != null) {
            this.directMethods.editInternal(user);
        }
        if (this.virtualMethods != null) {
            this.virtualMethods.editInternal(user);
        }
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return new IterableIterator<DefArray<?>, IdItem>(this.getDefArrays()){

            @Override
            public Iterator<IdItem> iterator(DefArray<?> element) {
                return element.usedIds();
            }
        };
    }

    public void merge(ClassData classData) {
        MethodDefArray methodsArray;
        FieldDefArray defArray;
        ClassId classId = this.getClassId();
        if (!ClassData.isNullOrEmpty(classData.staticFields)) {
            defArray = this.initStaticFieldsArray();
            defArray.setClassId(classId);
            defArray.merge(classData.staticFields);
        }
        if (!ClassData.isNullOrEmpty(classData.instanceFields)) {
            defArray = this.initInstanceFieldsArray();
            defArray.setClassId(classId);
            defArray.merge(classData.instanceFields);
        }
        if (!ClassData.isNullOrEmpty(classData.directMethods)) {
            methodsArray = this.initDirectMethodsArray();
            methodsArray.setClassId(classId);
            methodsArray.merge(classData.directMethods);
        }
        if (!ClassData.isNullOrEmpty(classData.virtualMethods)) {
            methodsArray = this.initVirtualMethodsArray();
            methodsArray.setClassId(classId);
            methodsArray.merge(classData.virtualMethods);
        }
    }

    public void fromSmali(SmaliClass smaliClass) throws IOException {
        Iterator<SmaliDef> iterator = smaliClass.getStaticFields();
        if (iterator.hasNext()) {
            this.initStaticFieldsArray().fromSmali(iterator);
        }
        if ((iterator = smaliClass.getInstanceFields()).hasNext()) {
            this.initInstanceFieldsArray().fromSmali(iterator);
        }
        if ((iterator = smaliClass.getDirectMethods()).hasNext()) {
            this.initDirectMethodsArray().fromSmali(iterator);
        }
        if ((iterator = smaliClass.getVirtualMethods()).hasNext()) {
            this.initVirtualMethodsArray().fromSmali(iterator);
        }
    }

    public void toSmali(SmaliClass smaliClass) {
        if (this.staticFields != null) {
            smaliClass.addFields((Iterator)ObjectsUtil.cast(this.staticFields.toSmali()));
        }
        if (this.instanceFields != null) {
            smaliClass.addFields((Iterator)ObjectsUtil.cast(this.instanceFields.toSmali()));
        }
        if (this.directMethods != null) {
            smaliClass.addMethods((Iterator)ObjectsUtil.cast(this.directMethods.toSmali()));
        }
        if (this.virtualMethods != null) {
            smaliClass.addMethods((Iterator)ObjectsUtil.cast(this.virtualMethods.toSmali()));
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.appendOptional(this.staticFields, "static fields");
        writer.appendOptional(this.instanceFields, "instance fields");
        writer.appendOptional(this.directMethods, "direct methods");
        writer.appendOptional(this.virtualMethods, "virtual methods");
    }

    public String toString() {
        return "staticFieldsCount=" + this.staticFieldsCount + ", instanceFieldCount=" + this.instanceFieldsCount + ", directMethodCount=" + this.directMethodsCount + ", virtualMethodCount=" + this.virtualMethodCount;
    }

    private static boolean isNullOrEmpty(DefArray<?> defArray) {
        return defArray == null || defArray.size() == 0;
    }
}

