/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.item.ByteItem;
import com.reandroid.dex.base.Ule128Item;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.AnnotationVisibility;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.data.AnnotationElement;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.AnnotationElementKey;
import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyReference;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.AnnotatedProgram;
import com.reandroid.dex.reference.Ule128IdItemReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliAnnotationElement;
import com.reandroid.dex.smali.model.SmaliAnnotationItem;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Predicate;

public class AnnotationItem
extends DataItem
implements Comparable<AnnotationItem>,
Iterable<AnnotationElement>,
KeyReference,
SmaliRegion {
    private final ByteItem visibility;
    private final Ule128IdItemReference<TypeId> typeId;
    private final CountedBlockList<AnnotationElement> annotationElements;
    private final boolean mValueEntry;

    public AnnotationItem(boolean valueEntry) {
        super(valueEntry ? 3 : 4);
        this.mValueEntry = valueEntry;
        ByteItem visibility = valueEntry ? null : new ByteItem();
        this.visibility = visibility;
        this.typeId = new Ule128IdItemReference<TypeId>(SectionType.TYPE_ID, UsageMarker.USAGE_ANNOTATION);
        Ule128Item elementsCount = new Ule128Item();
        this.annotationElements = new CountedBlockList<AnnotationElement>(AnnotationElement.CREATOR, elementsCount);
        int i = 0;
        if (!valueEntry) {
            this.addChildBlock(i++, visibility);
        }
        this.addChildBlock(i++, this.typeId);
        this.addChildBlock(i++, elementsCount);
        this.addChildBlock(i, this.annotationElements);
    }

    public AnnotationItem() {
        this(false);
    }

    public SectionType<AnnotationItem> getSectionType() {
        return SectionType.ANNOTATION_ITEM;
    }

    public boolean removeIf(Predicate<AnnotationElement> filter) {
        return this.annotationElements.removeIf(filter);
    }

    public void remove(AnnotationElement element) {
        this.annotationElements.remove(element);
    }

    public void clear() {
        this.annotationElements.clearChildes();
    }

    public AnnotationElement getOrCreateElement(String name) {
        AnnotationElement element = this.getElement(name);
        if (element != null) {
            return element;
        }
        element = this.createNewElement();
        element.setName(name);
        element.getOrCreateValue(DexValueType.NULL);
        return element;
    }

    public AnnotationElement createNewElement() {
        return (AnnotationElement)this.annotationElements.createNext();
    }

    public boolean containsName(String name) {
        for (AnnotationElement element : this) {
            if (!name.equals(element.getName())) continue;
            return true;
        }
        return false;
    }

    public DexValueBlock<?> getElementValue(String name) {
        AnnotationElement element = this.getElement(name);
        if (element != null) {
            return element.getValueBlock();
        }
        return null;
    }

    public AnnotationElement getElement(String name) {
        for (AnnotationElement element : this) {
            if (!name.equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    public AnnotationElementKey[] getElements() {
        int length = this.getElementsCount();
        AnnotationElementKey[] results = new AnnotationElementKey[length];
        for (int i = 0; i < length; ++i) {
            results[i] = this.getElement(i).getKey();
        }
        return results;
    }

    public void addElement(AnnotationElementKey element) {
        this.createNewElement().setKey(element);
    }

    public String[] getNames() {
        CountedBlockList<AnnotationElement> elements = this.annotationElements;
        int length = elements.size();
        if (length == 0) {
            return null;
        }
        String[] results = new String[length];
        for (int i = 0; i < length; ++i) {
            results[i] = ((AnnotationElement)elements.get(i)).getName();
        }
        return results;
    }

    @Override
    public AnnotationItemKey getKey() {
        return this.checkKey(AnnotationItemKey.create(this.getVisibility(), this.getType(), this.getElements()));
    }

    @Override
    public void setKey(Key key) {
        AnnotationItemKey itemKey = (AnnotationItemKey)key;
        this.setVisibility(itemKey.getVisibility());
        this.setType(itemKey.getType());
        this.clear();
        for (AnnotationElementKey elementKey : itemKey) {
            this.addElement(elementKey);
        }
    }

    @Override
    public Iterator<AnnotationElement> iterator() {
        return this.annotationElements.iterator();
    }

    public Iterator<AnnotationElement> clonedIterator() {
        return this.annotationElements.clonedIterator();
    }

    public int getElementsCount() {
        return this.annotationElements.size();
    }

    public boolean isEmpty() {
        return this.annotationElements.size() == 0;
    }

    public AnnotationElement getElement(int index) {
        return (AnnotationElement)this.annotationElements.get(index);
    }

    public boolean isValueEntry() {
        return this.mValueEntry;
    }

    public AnnotationVisibility getVisibility() {
        if (!this.isValueEntry()) {
            return AnnotationVisibility.valueOf(this.visibility.get());
        }
        return null;
    }

    public void setVisibility(AnnotationVisibility visibility) {
        int value = visibility != null ? visibility.getValue() : 0;
        this.setVisibility(value);
    }

    public void setVisibility(int visibility) {
        if (this.visibility != null) {
            this.visibility.set((byte)visibility);
        }
    }

    public int getVisibilityValue() {
        if (this.visibility == null) {
            return -1;
        }
        return this.visibility.get();
    }

    public TypeKey getType() {
        return (TypeKey)this.typeId.getKey();
    }

    public TypeId getTypeId() {
        return (TypeId)this.typeId.getItem();
    }

    public void setType(String type) {
        this.setType(TypeKey.create(type));
    }

    public void setType(TypeKey typeKey) {
        this.typeId.setKey(typeKey);
    }

    public void replaceKeys(Key search, Key replace) {
        AnnotationItemKey update;
        AnnotationItemKey itemKey = this.getKey();
        if (itemKey != (update = itemKey.replaceKey(search, replace))) {
            this.setKey(update);
        }
    }

    @Override
    public Iterator<IdItem> usedIds() {
        TypeKey typeKey = this.getType();
        if (typeKey.getTypeName().startsWith("Ldalvik/annotation/")) {
            return EmptyIterator.of();
        }
        return CombiningIterator.singleOne(this.getTypeId(), new IterableIterator<AnnotationElement, IdItem>(this.iterator()){

            @Override
            public Iterator<IdItem> iterator(AnnotationElement element) {
                return element.usedIds();
            }
        });
    }

    @Override
    public void editInternal(Block user) {
        super.editInternal(user);
    }

    public AnnotatedProgram asAnnotated() {
        return new WarpedAnnotation(this);
    }

    public void merge(AnnotationItem annotationItem) {
        if (annotationItem == this) {
            return;
        }
        this.setVisibility(annotationItem.getVisibilityValue());
        this.setType(annotationItem.getType());
        this.annotationElements.ensureCapacity(annotationItem.getElementsCount());
        for (AnnotationElement coming : annotationItem) {
            this.createNewElement().merge(coming);
        }
    }

    public void fromSmali(SmaliAnnotationItem smaliAnnotationItem) {
        this.setType(smaliAnnotationItem.getType());
        this.setVisibility(smaliAnnotationItem.getVisibility());
        Iterator iterator = smaliAnnotationItem.iterator();
        while (iterator.hasNext()) {
            SmaliAnnotationElement smaliAnnotationElement = (SmaliAnnotationElement)iterator.next();
            AnnotationElement element = this.createNewElement();
            element.fromSmali(smaliAnnotationElement);
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getSmaliDirective().append(writer);
        writer.appendOptional(this.getVisibility());
        this.getTypeId().append(writer);
        writer.indentPlus();
        writer.appendAllWithDoubleNewLine(this.iterator());
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        if (this.isValueEntry()) {
            return SmaliDirective.SUB_ANNOTATION;
        }
        return SmaliDirective.ANNOTATION;
    }

    @Override
    public int compareTo(AnnotationItem other) {
        if (other == null) {
            return -1;
        }
        if (other == this) {
            return 0;
        }
        int i = SectionTool.compareIdx(this.getTypeId(), other.getTypeId());
        if (i != 0) {
            return i;
        }
        return CompareUtil.compare(this.getVisibilityValue(), other.getVisibilityValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationItem item = (AnnotationItem)obj;
        if (!ObjectsUtil.equals(this.getType(), item.getType())) {
            return false;
        }
        if (this.getVisibilityValue() != item.getVisibilityValue()) {
            return false;
        }
        return this.annotationElements.equals(item.annotationElements);
    }

    public int hashCode() {
        return ObjectsUtil.hash(this.getVisibility(), this.getType(), this.annotationElements);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('@');
        builder.append(this.getType());
        boolean appendOnce = false;
        for (AnnotationElement element : this) {
            if (appendOnce) {
                builder.append(", ");
            } else {
                builder.append('(');
            }
            builder.append(element);
            appendOnce = true;
        }
        if (appendOnce) {
            builder.append(')');
        }
        return builder.toString();
    }

    static class WarpedAnnotation
    implements AnnotatedProgram {
        private final AnnotationItem mItem;

        public WarpedAnnotation(AnnotationItem item) {
            this.mItem = item;
        }

        private AnnotationItemKey getItemKey() {
            if (!this.mItem.isRemoved()) {
                return this.mItem.getKey();
            }
            return null;
        }

        @Override
        public AnnotationSetKey getAnnotation() {
            AnnotationItemKey key = this.getItemKey();
            if (key != null) {
                return AnnotationSetKey.of(key);
            }
            return AnnotationSetKey.empty();
        }

        @Override
        public void setAnnotation(AnnotationSetKey annotationSet) {
            if (annotationSet.isEmpty()) {
                return;
            }
            if (this.mItem.isRemoved()) {
                throw new IllegalArgumentException("AnnotationItem was removed");
            }
            if (annotationSet.size() > 1) {
                throw new IllegalArgumentException("Multiple AnnotationItem");
            }
            this.mItem.setKey((Key)annotationSet.get(0));
        }

        @Override
        public void clearAnnotations() {
            this.mItem.removeSelf();
        }

        @Override
        public boolean hasAnnotations() {
            return !this.mItem.isRemoved();
        }

        @Override
        public boolean hasAnnotation(TypeKey typeKey) {
            AnnotationItemKey itemKey = this.getItemKey();
            return itemKey != null && itemKey.getType().equals(typeKey);
        }

        @Override
        public AnnotationItemKey getAnnotation(TypeKey typeKey) {
            AnnotationItemKey itemKey = this.getItemKey();
            if (itemKey != null && itemKey.getType().equals(typeKey)) {
                return itemKey;
            }
            return null;
        }

        @Override
        public boolean removeAnnotation(TypeKey typeKey) {
            AnnotationItemKey itemKey = this.getItemKey();
            if (itemKey != null && itemKey.getType().equals(typeKey)) {
                this.clearAnnotations();
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAnnotationIf(Predicate<? super AnnotationItemKey> predicate) {
            AnnotationItemKey itemKey = this.getItemKey();
            if (itemKey != null && predicate.test(itemKey)) {
                this.clearAnnotations();
                return true;
            }
            return false;
        }
    }
}

