/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.data.AnnotationItem;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.key.AnnotationElementKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyReference;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.reference.StringUle128Reference;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliAnnotationElement;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.NullValue;
import com.reandroid.utils.collection.CombiningIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class AnnotationElement
extends DataItem
implements KeyReference,
Comparable<AnnotationElement>,
SmaliFormat {
    private final StringUle128Reference elementName = new StringUle128Reference(StringId.USAGE_METHOD_NAME);
    public static final Creator<AnnotationElement> CREATOR = AnnotationElement::new;

    public AnnotationElement() {
        super(2);
        this.addChildBlock(0, this.elementName);
    }

    @Override
    public AnnotationElementKey getKey() {
        return AnnotationElementKey.create(this.getName(), this.getValue());
    }

    @Override
    public void setKey(Key key) {
        AnnotationElementKey elementKey = (AnnotationElementKey)key;
        this.setName(elementKey.getName());
        this.setValue(elementKey.getValue());
    }

    public Key getValue() {
        DexValueBlock<?> valueBlock = this.getValueBlock();
        if (valueBlock != null) {
            return valueBlock.getKey();
        }
        return null;
    }

    public void setValue(Key value) {
        Block valueBlock = DexValueType.forKey(value).newInstance();
        this.setValue((DexValueBlock<?>)valueBlock);
        ((DexValueBlock)valueBlock).setKey(value);
    }

    public DexValueBlock<?> getValueBlock() {
        return (DexValueBlock)this.getChildBlockAt(1);
    }

    public <T1 extends DexValueBlock<?>> T1 getValue(DexValueType<T1> valueType) {
        DexValueBlock<T1> value = this.getValueBlock();
        if (value != null && value.is(valueType)) {
            return (T1)value;
        }
        return null;
    }

    public <T1 extends DexValueBlock<?>> T1 getOrCreateValue(DexValueType<T1> valueType) {
        Block value = this.getValueBlock();
        if (value == null || value == NullValue.PLACE_HOLDER || ((DexValueBlock)value).getValueType() != valueType) {
            value = valueType.newInstance();
            this.setValue((DexValueBlock<?>)value);
        }
        return (T1)value;
    }

    public void setValue(DexValueBlock<?> dexValue) {
        this.addChildBlock(1, dexValue);
    }

    public boolean is(DexValueType<?> valueType) {
        return this.getValueType() == valueType;
    }

    public boolean is(MethodKey methodKey) {
        return methodKey != null && methodKey.equalsIgnoreReturnType(this.getMethodKey());
    }

    public DexValueType<?> getValueType() {
        DexValueBlock<?> value = this.getValueBlock();
        if (value != null) {
            return value.getValueType();
        }
        return null;
    }

    public String getName() {
        return this.elementName.getString();
    }

    public void setName(String name) {
        this.elementName.setString(name);
    }

    public StringId getNameId() {
        return (StringId)this.elementName.getItem();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.elementName.onReadBytes(reader);
        DexValueBlock<?> value = DexValueType.create(reader);
        this.setValue(value);
        value.onReadBytes(reader);
    }

    public void replaceKeys(Key search, Key replace) {
        this.getValueBlock().replaceKeys(search, replace);
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return CombiningIterator.singleOne(this.getNameId(), this.getValueBlock().usedIds());
    }

    public void merge(AnnotationElement element) {
        if (element == this) {
            return;
        }
        this.setName(element.getName());
        DexValueBlock<?> coming = element.getValueBlock();
        Object value = this.getOrCreateValue(coming.getValueType());
        ((DexValueBlock)value).merge(coming);
    }

    public void fromSmali(SmaliAnnotationElement element) {
        this.setName(element.getName());
        SmaliValue smaliValue = element.getValue();
        Object value = this.getOrCreateValue(smaliValue.getValueType());
        ((DexValueBlock)value).fromSmali(smaliValue);
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(this.getName());
        writer.append(" = ");
        this.getValueBlock().append(writer);
    }

    @Override
    public int compareTo(AnnotationElement other) {
        if (other == null) {
            return -1;
        }
        if (other == this) {
            return 0;
        }
        return SectionTool.compareIdx(this.getNameId(), other.getNameId());
    }

    public TypeKey getDataTypeKey() {
        DexValueBlock<?> valueBlock = this.getValueBlock();
        if (valueBlock != null) {
            return valueBlock.getDataTypeKey();
        }
        return null;
    }

    public TypeKey getParentType() {
        AnnotationItem parent = this.getParentInstance(AnnotationItem.class);
        if (parent != null) {
            return parent.getType();
        }
        return null;
    }

    public MethodKey getMethodKey() {
        return MethodKey.create(this.getParentType(), this.getName(), ProtoKey.emptyParameters(this.getDataTypeKey()));
    }

    @Override
    public Iterator<Key> usedKeys() {
        return CombiningIterator.singleOne(this.getMethodKey(), super.usedKeys());
    }

    public int hashCode() {
        int hash = 1;
        Object obj = this.getName();
        hash *= 31;
        if (obj != null) {
            hash += obj.hashCode();
        }
        obj = this.getValueBlock();
        hash *= 31;
        if (obj != null) {
            hash += obj.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationElement element = (AnnotationElement)obj;
        if (!Objects.equals(this.getName(), element.getName())) {
            return false;
        }
        return Objects.equals(this.getValueBlock(), element.getValueBlock());
    }

    public String toString() {
        return this.getName() + " = " + this.getValueBlock();
    }
}

