/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dalvik;

import com.reandroid.dex.common.AnnotationVisibility;
import com.reandroid.dex.dalvik.DalvikAnnotation;
import com.reandroid.dex.key.AnnotationElementKey;
import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.ArrayKey;
import com.reandroid.dex.key.ArrayValueKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyList;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.AnnotatedProgram;
import com.reandroid.dex.program.MethodProgram;
import com.reandroid.utils.StringsUtil;

public class DalvikThrows
extends DalvikAnnotation {
    private DalvikThrows(AnnotatedProgram annotatedProgram) {
        super(annotatedProgram, TypeKey.DALVIK_Throws);
    }

    public void add(TypeKey typeKey) {
        KeyList arrayKey = this.getThrows();
        if (!arrayKey.contains(typeKey)) {
            arrayKey = arrayKey.add(typeKey);
            this.setThrows((ArrayKey<TypeKey>)arrayKey);
        }
    }

    public boolean contains(TypeKey typeKey) {
        return this.getThrows().contains(typeKey);
    }

    public boolean remove(TypeKey typeKey) {
        KeyList arrayKey = this.getThrows();
        if (arrayKey.contains(typeKey)) {
            arrayKey = arrayKey.remove(typeKey);
            this.setThrows((ArrayKey<TypeKey>)arrayKey);
            return true;
        }
        return false;
    }

    public ArrayKey<TypeKey> getThrows() {
        Key key = this.readValue(Key.DALVIK_value);
        if (!(key instanceof ArrayKey)) {
            return ArrayKey.empty();
        }
        return (ArrayKey)key;
    }

    public void setThrows(ArrayKey<TypeKey> typeKeys) {
        this.writeValue(Key.DALVIK_value, ArrayValueKey.create(typeKeys));
    }

    @Override
    public MethodProgram getAnnotatedProgram() {
        return (MethodProgram)super.getAnnotatedProgram();
    }

    @Override
    public String toString() {
        return StringsUtil.join(this.getThrows().iterator(), (Object)", ");
    }

    public static DalvikThrows of(AnnotatedProgram annotatedProgram) {
        if (annotatedProgram.hasAnnotation(TypeKey.DALVIK_Throws)) {
            return new DalvikThrows(annotatedProgram);
        }
        return null;
    }

    public static DalvikThrows getOrCreate(AnnotatedProgram annotatedProgram) {
        if (!annotatedProgram.hasAnnotation(TypeKey.DALVIK_Throws)) {
            annotatedProgram.addAnnotation(AnnotationItemKey.create(AnnotationVisibility.SYSTEM, TypeKey.DALVIK_Throws, AnnotationElementKey.create(Key.DALVIK_value, ArrayValueKey.empty())));
        }
        return DalvikThrows.of(annotatedProgram);
    }
}

