/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dalvik;

import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.AnnotatedProgram;

public class DalvikAnnotation {
    private final AnnotatedProgram annotatedProgram;
    private final TypeKey annotationType;

    protected DalvikAnnotation(AnnotatedProgram annotatedProgram, TypeKey annotationType) {
        this.annotatedProgram = annotatedProgram;
        this.annotationType = annotationType;
    }

    public AnnotationItemKey getKey() {
        return this.getAnnotatedProgram().getAnnotation(this.getAnnotationType());
    }

    public void setKey(AnnotationItemKey key) {
        if (!this.getAnnotationType().equals(key.getType())) {
            throw new IllegalArgumentException("Different annotation type: " + this.getAnnotationType() + ", " + key.getType());
        }
        this.getAnnotatedProgram().addAnnotation(key);
    }

    public TypeKey getAnnotationType() {
        return this.annotationType;
    }

    public AnnotatedProgram getAnnotatedProgram() {
        return this.annotatedProgram;
    }

    Key readValue(String name) {
        return this.getKey().getValue(name);
    }

    void writeValue(String name, Key value) {
        this.setKey(this.getKey().add(name, value));
    }

    public String toString() {
        return this.getKey().toString();
    }
}

