/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.base;

public class DexException
extends RuntimeException {
    private static final int MAX_TRACE = 15;

    public DexException(String message) {
        super(message);
    }

    public DexException(String message, Throwable cause) {
        super(message, cause);
    }

    public DexException(Throwable cause) {
        super(cause);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        DexException.append(this, builder);
        return builder.toString();
    }

    private static void append(Throwable throwable, StringBuilder builder) {
        if (throwable == null) {
            return;
        }
        builder.append(throwable.getClass().getName());
        builder.append(": ");
        builder.append(throwable.getMessage());
        StackTraceElement[] traceElements = throwable.getStackTrace();
        int length = traceElements.length;
        if (length > 15) {
            length = 15;
        }
        for (int i = 0; i < length; ++i) {
            DexException.append(traceElements[i], builder);
        }
        Throwable cause = throwable.getCause();
        if (cause == null || cause == throwable) {
            return;
        }
        builder.append("Caused by: ");
        DexException.append(cause, builder);
    }

    private static void append(StackTraceElement element, StringBuilder builder) {
        if (element == null) {
            return;
        }
        builder.append("\n\tat ");
        builder.append(element.getClassName());
        builder.append('.');
        builder.append(element.getMethodName());
        builder.append('(');
        builder.append(element.getFileName());
        builder.append(':');
        builder.append(element.getLineNumber());
        builder.append(')');
    }
}

