/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.common;

import com.reandroid.utils.HexUtil;

public interface IntegerArray {
    public static final int[] EMPTY = new int[0];

    public int get(int var1);

    public int size();

    public void setSize(int var1);

    public void put(int var1, int var2);

    public static int[] toArray(IntegerArray array) {
        if (IntegerArray.isEmpty(array)) {
            return EMPTY;
        }
        int size = array.size();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = array.get(i);
        }
        return result;
    }

    public static String toString(IntegerArray array) {
        return IntegerArray.toString(array, false, 0, 10);
    }

    public static String toString(IntegerArray array, boolean hex) {
        return IntegerArray.toString(array, hex, 0, 10);
    }

    public static String toString(IntegerArray array, int start) {
        return IntegerArray.toString(array, false, start, 10);
    }

    public static String toString(IntegerArray array, boolean hex, int start) {
        return IntegerArray.toString(array, hex, start, 10);
    }

    public static String toString(IntegerArray array, boolean hex, int start, int limit) {
        int max;
        if (array == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("size=");
        int size = array.size() - start;
        builder.append(size);
        if (start > 0) {
            builder.append(", start=");
            builder.append(start);
        }
        if ((max = size) > limit) {
            max = limit;
        }
        for (int i = 0; i < max; ++i) {
            if (i == 0) {
                builder.append(" [");
            } else {
                builder.append(", ");
            }
            int value = array.get(i);
            if (hex) {
                builder.append(HexUtil.toHex(value, 2));
                continue;
            }
            builder.append(value);
        }
        if (size > max) {
            builder.append(", +");
            builder.append(size - max);
            builder.append(" more");
        }
        if (size > 0) {
            builder.append(']');
        }
        return builder.toString();
    }

    public static int hashCode(IntegerArray array) {
        if (IntegerArray.isEmpty(array)) {
            return 0;
        }
        int result = 1;
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            result += array.get(i) * 31;
        }
        return result;
    }

    public static boolean equals(IntegerArray array1, IntegerArray array2) {
        if (array1 == array2) {
            return true;
        }
        if (IntegerArray.isEmpty(array1)) {
            return IntegerArray.isEmpty(array2);
        }
        if (IntegerArray.isEmpty(array2)) {
            return IntegerArray.isEmpty(array1);
        }
        int size = array1.size();
        if (size != array2.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (array1.get(i) == array2.get(i)) continue;
            return false;
        }
        return true;
    }

    public static IntegerArray subArray(final IntegerArray integerArray, final int offset, final int size) {
        if (IntegerArray.isEmpty(integerArray)) {
            return integerArray;
        }
        if (offset == 0 && size == integerArray.size()) {
            return integerArray;
        }
        return new IntegerArray(){

            @Override
            public int get(int i) {
                return integerArray.get(offset + i);
            }

            @Override
            public int size() {
                return size;
            }

            @Override
            public void setSize(int size2) {
            }

            @Override
            public void put(int i, int value) {
            }

            public String toString() {
                return IntegerArray.toString(this);
            }
        };
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(IntegerArray array) {
        return array == null || array.size() == 0;
    }
}

