/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.common;

import com.reandroid.common.Origin;

public interface DiagnosticMessage {
    public Type type();

    default public String getTag() {
        return null;
    }

    default public Origin getSource() {
        return null;
    }

    public static enum Type {
        INFO("I"),
        WARN("W"),
        ERROR("E"),
        VERBOSE("V"),
        DEBUG("D");

        String simpleName;

        private Type(String simpleName) {
            this.simpleName = simpleName;
        }

        public String getName() {
            return this.simpleName;
        }
    }

    public static class StringMessage
    implements DiagnosticMessage {
        private final Type type;
        private final Origin source;
        private final String tag;
        private final String message;

        public StringMessage(Type type, Origin source, String tag, String message) {
            this.type = type;
            this.source = source;
            this.tag = tag;
            this.message = message;
        }

        public StringMessage(Type type, String tag, String message) {
            this(type, null, tag, message);
        }

        public StringMessage(Type type, String message) {
            this(type, null, null, message);
        }

        @Override
        public Type type() {
            return this.type;
        }

        @Override
        public Origin getSource() {
            return this.source;
        }

        @Override
        public String getTag() {
            return this.tag;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            Origin source;
            StringBuilder builder = new StringBuilder();
            builder.append(this.type().getName());
            builder.append(": ");
            String tag = this.getTag();
            if (tag != null) {
                builder.append(tag);
                builder.append(" : ");
            }
            if ((source = this.getSource()) != null) {
                builder.append(source);
                builder.append(", ");
            }
            builder.append(this.getMessage());
            return builder.toString();
        }
    }
}

