/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.common;

import java.io.IOException;
import java.io.InputStream;

public class BytesInputStream
extends InputStream {
    private final byte[] array;
    private final int offset;
    private final int length;
    private int position;
    private int mark;

    public BytesInputStream(byte[] array, int offset, int length) {
        int available;
        if (offset >= array.length) {
            offset = array.length - 1;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (length > (available = array.length - offset)) {
            length = available;
        }
        this.array = array;
        this.offset = offset;
        this.length = length;
    }

    public BytesInputStream(byte[] array) {
        this(array, 0, array.length);
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] toByteArray() {
        if (this.offset == 0 && this.position == 0 && this.length == this.array.length) {
            return this.array;
        }
        int size = this.length - this.position;
        byte[] bytes = new byte[size];
        System.arraycopy(this.array, this.offset + this.position, bytes, 0, size);
        return bytes;
    }

    public byte[] getArray() {
        return this.array;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.mark = readLimit;
    }

    @Override
    public void close() throws IOException {
        this.position = this.length;
    }

    @Override
    public void reset() throws IOException {
        this.position = this.mark;
    }

    @Override
    public long skip(long amount) throws IOException {
        if (amount <= 0L) {
            return amount;
        }
        int skip = (int)amount;
        int available = this.available();
        if (skip > available) {
            skip = available;
        }
        this.position += skip;
        return skip;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        int available = this.available();
        if (available <= 0) {
            return -1;
        }
        if (length > available) {
            length = available;
        }
        System.arraycopy(this.array, this.offset + this.position, bytes, offset, length);
        this.position += length;
        return length;
    }

    @Override
    public int read() throws IOException {
        if (this.available() <= 0) {
            return -1;
        }
        byte i = this.array[this.offset + this.position];
        ++this.position;
        return i & 0xFF;
    }

    @Override
    public int available() {
        return this.length - this.position;
    }
}

