/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.model;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.pool.SpecStringPool;
import com.reandroid.arsc.pool.TypeStringPool;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.FilterIterator;
import java.util.Iterator;

public class ResourceType
implements Comparable<ResourceType>,
Iterable<ResourceEntry> {
    private final PackageBlock packageBlock;
    private final int id;

    public ResourceType(PackageBlock packageBlock, int id) {
        this.packageBlock = packageBlock;
        this.id = id;
    }

    public ResourceType(SpecTypePair specTypePair) {
        this(specTypePair.getPackageBlock(), specTypePair.getId());
    }

    public ResourceEntry get(int resourceId) {
        if (resourceId == 0 || resourceId >>> 24 != this.getPackageId()) {
            return null;
        }
        int t = this.getId();
        if (t == 0 || (resourceId >> 16 & 0xFF) != t) {
            return null;
        }
        if ((resourceId & 0xFFFF) > this.size()) {
            return null;
        }
        return new ResourceEntry(this.getPackageBlock(), resourceId);
    }

    public int getIdentifier(String name) {
        SpecStringPool specStringPool = this.getPackageBlock().getSpecStringPool();
        return specStringPool.resolveResourceId(this.getId(), name);
    }

    @Override
    public Iterator<ResourceEntry> iterator() {
        return FilterIterator.of(this.getResources(), ResourceEntry::isDefined);
    }

    public int size() {
        SpecTypePair specTypePair = this.getSpecTypePair();
        if (specTypePair != null) {
            return specTypePair.getHighestEntryCount();
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.size() == 0 || !this.iterator().hasNext();
    }

    private Iterator<ResourceEntry> getResources() {
        SpecTypePair specTypePair = this.getSpecTypePair();
        if (specTypePair != null) {
            return specTypePair.getResources();
        }
        return EmptyIterator.of();
    }

    private SpecTypePair getSpecTypePair() {
        return this.getPackageBlock().getSpecTypePair(this.getId());
    }

    public String getName() {
        return this.getPackageBlock().typeNameOf(this.getId());
    }

    public void setName(String name) {
        int typeId;
        TypeStringPool typeStringPool = this.getPackageBlock().getTypeStringPool();
        TypeString typeString = typeStringPool.getById(typeId = this.getId());
        if (typeString == null) {
            typeStringPool.getOrCreate(typeId, name);
        } else {
            typeString.set(name);
        }
    }

    public PackageBlock getPackageBlock() {
        return this.packageBlock;
    }

    public int getId() {
        return this.id;
    }

    public int getPackageId() {
        return this.getPackageBlock().getId();
    }

    @Override
    public int compareTo(ResourceType resourceType) {
        if (resourceType == null) {
            return -1;
        }
        if (resourceType == this) {
            return 0;
        }
        int i = CompareUtil.compare(this.getPackageId(), resourceType.getPackageId());
        if (i == 0) {
            i = CompareUtil.compare(this.getId(), resourceType.getId());
        }
        return i;
    }

    public int hashCode() {
        return this.getPackageId() << 24 | this.getId() << 16;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceType)) {
            return false;
        }
        ResourceType other = (ResourceType)obj;
        return this.getPackageBlock() == other.getPackageBlock();
    }

    public String toString() {
        return this.getName();
    }
}

