/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.list;

import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.item.StyleItem;
import com.reandroid.arsc.list.OffsetBlockList;
import com.reandroid.arsc.list.OffsetReferenceList;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.utils.CompareUtil;
import java.util.Comparator;
import java.util.Iterator;

public class StyleItemList
extends OffsetBlockList<StyleItem> {
    private boolean stringsLinked;

    public StyleItemList(IntegerReference start, OffsetReferenceList<?> offsetReferenceList) {
        super(start, offsetReferenceList, StyleItem.CREATOR);
    }

    public boolean sort() {
        return this.sort(CompareUtil.getComparableComparator());
    }

    @Override
    public boolean sort(Comparator<? super StyleItem> comparator) {
        if (!this.isSortingAllowed()) {
            return false;
        }
        boolean sorted = super.sort(comparator);
        if (this.adjustIndexes() && super.sort(comparator)) {
            sorted = true;
        }
        this.trimLastIf(StyleItem::isEmpty);
        return sorted;
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.sort();
    }

    @Override
    public void onPreRemove(StyleItem item) {
        item.onRemoved();
        super.onPreRemove(item);
    }

    public void linkStyleStringsInternal() {
        if (!this.stringsLinked) {
            this.stringsLinked = true;
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                ((StyleItem)this.get(i)).linkStringsInternal();
            }
        }
    }

    private boolean isSortingAllowed() {
        StringPool stringPool = this.getParentInstance(StringPool.class);
        if (stringPool != null) {
            return !stringPool.getStringsArray().isSortRequired();
        }
        return false;
    }

    private boolean adjustIndexes() {
        Iterator iterator = this.clonedIterator();
        boolean adjusted = false;
        while (iterator.hasNext()) {
            int index;
            StyleItem styleItem = (StyleItem)iterator.next();
            StringItem stringItem = styleItem.getStringItemInternal();
            if (stringItem == null || (index = stringItem.getIndex()) == styleItem.getIndex()) continue;
            this.moveTo(styleItem, index);
            adjusted = true;
        }
        if (adjusted) {
            this.getParentInstance(StringPool.class).linkStylesInternal();
        }
        return adjusted;
    }
}

