/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.list;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.header.TypeHeader;
import com.reandroid.arsc.item.ByteItem;
import com.reandroid.arsc.item.OffsetItem;
import com.reandroid.arsc.list.EntryItemOffsetList;
import com.reandroid.arsc.list.OffsetBlockList;
import com.reandroid.arsc.pool.SpecStringPool;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.CompareUtil;
import java.util.Iterator;
import java.util.function.Predicate;

public class EntryItemList
extends OffsetBlockList<Entry>
implements JSONConvert<JSONArray> {
    private final TypeHeader header;
    private static final Predicate<Entry> NON_NULL_PREDICATE = entry -> !entry.isNull();

    public EntryItemList(TypeHeader header, EntryItemOffsetList offsetList) {
        super(header.getEntriesStart(), offsetList, Entry.CREATOR);
        this.header = header;
        header.setOffsetTypeChangedListener(this::onOffsetTypeChanged);
    }

    public Entry getEntry(int entryId) {
        int index = this.isSparse() ? this.getEntryIndex(entryId) : entryId;
        return (Entry)this.get(index);
    }

    public Entry getOrCreate(int entryId) {
        Entry entry = this.getEntry(entryId);
        if (entry == null) {
            entry = this.isSparse() ? this.createSparse(entryId) : (Entry)this.createAt(entryId);
        }
        return entry;
    }

    private Entry createSparse(int entryId) {
        EntryItemOffsetList offsetList = this.getOffsetReferenceList();
        int index = offsetList.findSortPoint(entryId);
        OffsetItem offsetItem = (OffsetItem)offsetList.createAt(index);
        offsetItem.setIdx(entryId);
        return (Entry)this.createAt(index);
    }

    public Entry getEntry(String entryName) {
        if (entryName == null) {
            return null;
        }
        TypeBlock typeBlock = this.getParentInstance(TypeBlock.class);
        if (typeBlock == null) {
            return null;
        }
        PackageBlock packageBlock = typeBlock.getPackageBlock();
        if (packageBlock == null) {
            return null;
        }
        Iterator<Entry> iterator = packageBlock.getEntries(typeBlock.getTypeName(), entryName);
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (entry.getParentInstance(EntryItemList.class) != this) continue;
            return entry;
        }
        return null;
    }

    public boolean isEmptyEntries() {
        return !this.iterator(true).hasNext();
    }

    public int countNonNull() {
        return this.countIf(NON_NULL_PREDICATE);
    }

    public void removeAllNull(int start) {
        this.trimLastIf(start, Entry::isNull);
    }

    public Boolean hasComplexEntry() {
        Iterator<Entry> iterator = this.iterator(true);
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (entry.isComplex()) {
                return true;
            }
            ResValue resValue = entry.getResValue();
            ValueType valueType = resValue.getValueType();
            if (valueType == null || valueType == ValueType.REFERENCE || valueType == ValueType.NULL) continue;
            return false;
        }
        return null;
    }

    public Iterator<Entry> iterator(boolean skipNullBlock) {
        if (!skipNullBlock) {
            return this.iterator();
        }
        return this.iterator(NON_NULL_PREDICATE);
    }

    public int getHighestEntryId() {
        if (this.isSparse()) {
            return this.getOffsetReferenceList().getHighestIdx();
        }
        return this.size() - 1;
    }

    public int getEntryId(int index) {
        if (this.isSparse()) {
            return ((OffsetItem)this.getOffsetReferenceList().get(index)).getIdx();
        }
        return index;
    }

    public int getEntryIndex(int entryId) {
        if (this.isSparse()) {
            return this.getOffsetReferenceList().indexOfIdx(entryId);
        }
        return entryId;
    }

    public boolean isSparse() {
        return this.getOffsetReferenceList().isSparse();
    }

    public int getOffsetType() {
        return this.getOffsetReferenceList().getOffsetType();
    }

    public void setOffsetType(int offsetType) {
        this.header.setOffsetType(offsetType);
    }

    public void sort() {
        if (this.isSparse()) {
            EntryItemOffsetList offsetList = this.getOffsetReferenceList();
            offsetList.sort(CompareUtil.getComparableComparator(), this);
        }
    }

    public EntryItemOffsetList getOffsetReferenceList() {
        return (EntryItemOffsetList)super.getOffsetReferenceList();
    }

    void onOffsetTypeChanged(int offsetType) {
        if (this.getOffsetReferenceList().setOffsetType(offsetType, this)) {
            this.buildOffsetList();
        }
    }

    @Override
    public void onPreRemove(Entry item) {
        item.setNull(true);
        super.onPreRemove(item);
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        ByteItem flags = this.header.getFlags();
        flags.set(flags.get() & 0xFFFFFFFC | this.getOffsetType());
    }

    public void linkTableStringsInternal(TableStringPool tableStringPool) {
        Iterator<Entry> iterator = this.iterator(true);
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            entry.linkTableStringsInternal(tableStringPool);
        }
    }

    public void linkSpecStringsInternal(SpecStringPool specStringPool) {
        Iterator<Entry> iterator = this.iterator(true);
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            entry.linkSpecStringsInternal(specStringPool);
        }
    }

    public void merge(EntryItemList itemList) {
        if (itemList != null && itemList != this) {
            Iterator<Entry> iterator = itemList.iterator(true);
            while (iterator.hasNext()) {
                Entry comingBlock = iterator.next();
                Entry existingBlock = this.getOrCreate(comingBlock.getId());
                existingBlock.merge(comingBlock);
            }
            this.buildOffsetList();
        }
    }

    @Override
    public JSONArray toJson() {
        JSONArray jsonArray = new JSONArray(this.size());
        Iterator<Entry> iterator = this.iterator(true);
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            JSONObject jsonObject = entry.toJson();
            if (jsonObject == null) continue;
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        this.clear();
        if (json != null) {
            int length = json.length();
            if (!this.isSparse()) {
                this.setSize(length);
            }
            String idKey = "id";
            for (int i = 0; i < length; ++i) {
                JSONObject jsonObject = json.getJSONObject(i);
                int entryId = jsonObject.getInt(idKey);
                this.getOrCreate(entryId).fromJson(jsonObject);
            }
        }
        this.buildOffsetList();
    }
}

