/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.StringReference;
import com.reandroid.utils.StringsUtil;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;

public abstract class StringBlock
extends BlockItem
implements StringReference {
    private String mCache = StringsUtil.EMPTY;
    public static final CharsetDecoder UTF8_DECODER = StandardCharsets.UTF_8.newDecoder();

    public StringBlock() {
        super(0);
    }

    @Override
    public String get() {
        return this.mCache;
    }

    @Override
    public void set(String text) {
        this.set(text, true);
    }

    public void set(String text, boolean notify) {
        boolean firstTime;
        if (text == null || text.length() == 0) {
            text = StringsUtil.EMPTY;
        }
        String old = this.mCache;
        boolean bl = firstTime = this.countBytes() == 0;
        if (firstTime) {
            old = null;
        } else if (text.equals(old)) {
            return;
        }
        this.writeStringBytes(text);
        if (notify) {
            this.onStringChanged(old, text);
        }
    }

    protected void writeStringBytes(String text) {
        this.mCache = text;
        byte[] bytes = this.encodeString(text);
        this.setBytesInternal(bytes, false);
    }

    @Override
    protected void onBytesChanged() {
        this.mCache = this.decodeString(this.getBytesInternal());
    }

    protected void onStringChanged(String old, String text) {
    }

    protected abstract String decodeString(byte[] var1);

    protected abstract byte[] encodeString(String var1);

    public int compareTo(StringBlock stringBlock) {
        if (stringBlock == null) {
            return -1;
        }
        return StringsUtil.compareStrings(this.get(), stringBlock.get());
    }

    public String toString() {
        return this.get();
    }
}

