/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.header;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockContainer;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.container.ExpandableBlockContainer;
import com.reandroid.arsc.io.BlockLoad;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.ByteArray;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.utils.HexBytesWriter;
import com.reandroid.utils.HexUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class HeaderBlock
extends ExpandableBlockContainer
implements BlockLoad {
    private final ShortItem mType;
    private final ShortItem mHeaderSize;
    private final IntegerItem mChunkSize;
    private HeaderLoaded mHeaderLoaded;
    private final ByteArray extraBytes;

    public HeaderBlock(short type) {
        super(3);
        this.mType = new ShortItem(type);
        this.mHeaderSize = new ShortItem();
        this.mChunkSize = new IntegerItem();
        this.extraBytes = new ByteArray();
        this.addChild(this.mType);
        this.addChild(this.mHeaderSize);
        this.addChild(this.mChunkSize);
        this.mType.setBlockLoad(this);
        this.mHeaderSize.setBlockLoad(this);
        this.mChunkSize.setBlockLoad(this);
    }

    public HeaderBlock(ChunkType chunkType) {
        this(chunkType.ID);
    }

    public int getMinimumSize() {
        return this.countBytes();
    }

    public ByteArray getExtraBytes() {
        return this.extraBytes;
    }

    public void setHeaderLoaded(HeaderLoaded headerLoaded) {
        this.mHeaderLoaded = headerLoaded;
    }

    public ChunkType getChunkType() {
        return ChunkType.get(this.mType.getShort());
    }

    public short getType() {
        return this.mType.getShort();
    }

    public void setType(ChunkType chunkType) {
        short type = chunkType == null ? (short)0 : chunkType.ID;
        this.setType(type);
    }

    public void setType(short type) {
        this.mType.set(type);
    }

    public int getHeaderSize() {
        return this.mHeaderSize.unsignedInt();
    }

    public void setHeaderSize(short headerSize) {
        this.mHeaderSize.set(headerSize);
    }

    public int getChunkSize() {
        return this.mChunkSize.get();
    }

    public void setChunkSize(int chunkSize) {
        this.mChunkSize.set(chunkSize);
    }

    public final void refreshHeader() {
        this.refreshHeaderSize();
        this.refreshChunkSize();
    }

    private void refreshHeaderSize() {
        this.setHeaderSize((short)this.countBytes());
    }

    private void refreshChunkSize() {
        Block parent = this.getParent();
        if (parent == null) {
            return;
        }
        int count = parent.countBytes();
        this.setChunkSize(count);
    }

    public int readBytes(InputStream inputStream) throws IOException {
        int result = this.onReadBytes(inputStream);
        super.notifyBlockLoad();
        return result;
    }

    private int onReadBytes(InputStream inputStream) throws IOException {
        int readCount = this.readBytes(inputStream, this);
        int difference = this.getHeaderSize() - readCount;
        this.initExtraBytes(this.extraBytes, difference);
        if (this.extraBytes.size() > 0) {
            readCount += this.extraBytes.readBytes(inputStream);
        }
        return readCount;
    }

    private int readBytes(InputStream inputStream, Block block) throws IOException {
        int result = 0;
        if (block instanceof BlockItem) {
            result = ((BlockItem)block).readBytes(inputStream);
        } else if (block instanceof BlockList) {
            List childes = ((BlockList)block).getChildes();
            for (Block child : childes) {
                result += this.readBytes(inputStream, child);
            }
        } else if (block instanceof BlockContainer) {
            Block[] childes;
            for (Block child : childes = ((BlockContainer)block).getChildes()) {
                result += this.readBytes(inputStream, child);
            }
        } else {
            throw new IOException("Can not read block type: " + block.getClass());
        }
        return result;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int start = reader.getPosition();
        super.onReadBytes(reader);
        int readActual = reader.getPosition() - start;
        int difference = this.getHeaderSize() - readActual;
        this.initExtraBytes(this.extraBytes, difference);
        if (this.extraBytes.size() > 0) {
            this.extraBytes.readBytes(reader);
        }
    }

    @Override
    public void onBlockLoaded(BlockReader reader, Block sender) throws IOException {
        if (sender == this.mType) {
            this.onChunkTypeLoaded(this.mType.getShort());
        } else if (sender == this.mHeaderSize) {
            this.onHeaderSizeLoaded(this.mHeaderSize.unsignedInt());
        } else if (sender == this.mChunkSize) {
            this.onChunkSizeLoaded(this.mHeaderSize.unsignedInt(), this.mChunkSize.get());
        }
    }

    @Override
    protected void onRefreshed() {
    }

    @Override
    protected void refreshChildes() {
    }

    void initExtraBytes(ByteArray extraBytes, int difference) {
        if (difference == 0) {
            return;
        }
        if (extraBytes.getParent() == null) {
            this.addChild(extraBytes);
        }
        extraBytes.setSize(difference);
    }

    void onChunkTypeLoaded(short chunkType) {
        HeaderLoaded headerLoaded = this.mHeaderLoaded;
        if (headerLoaded != null) {
            headerLoaded.onChunkTypeLoaded(chunkType);
        }
    }

    void onHeaderSizeLoaded(int size) {
        HeaderLoaded headerLoaded = this.mHeaderLoaded;
        if (headerLoaded != null) {
            headerLoaded.onHeaderSizeLoaded(size);
        }
    }

    void onChunkSizeLoaded(int headerSize, int chunkSize) {
        HeaderLoaded headerLoaded = this.mHeaderLoaded;
        if (headerLoaded != null) {
            headerLoaded.onChunkSizeLoaded(headerSize, chunkSize);
        }
    }

    public String toHex() {
        return HexBytesWriter.toHex(this.getBytes());
    }

    public String toString() {
        short t = this.getType();
        ChunkType type = ChunkType.get(t);
        StringBuilder builder = new StringBuilder();
        if (type != null) {
            builder.append(type.toString());
        } else {
            builder.append("Unknown type=");
            builder.append(HexUtil.toHex4(t));
        }
        builder.append("{ValueHeader=");
        builder.append(this.getHeaderSize());
        builder.append(", Chunk=");
        builder.append(this.getChunkSize());
        builder.append("}");
        return builder.toString();
    }

    public static interface HeaderLoaded {
        public void onChunkTypeLoaded(short var1);

        public void onHeaderSizeLoaded(int var1);

        public void onChunkSizeLoaded(int var1, int var2);
    }
}

