/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.container;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.base.BlockLocator;
import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.Swappable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class BlockList<T extends Block>
extends Block
implements BlockRefresh,
Swappable {
    private ArrayCollection<T> mItems = ArrayCollection.empty();
    private Creator<? extends T> mCreator;
    private static final BlockList<?> empty_list = new BlockList<Block>(){

        @Override
        public boolean add(Block item) {
            throw new IllegalArgumentException("Empty BlockList");
        }

        @Override
        public void add(int index, Block item) {
            throw new IllegalArgumentException("Empty BlockList");
        }

        @Override
        public void ensureCapacity(int capacity) {
            if (capacity != 0) {
                throw new IllegalArgumentException("Empty BlockList");
            }
        }

        @Override
        public void setSize(int size, boolean notify) {
            if (size != 0) {
                throw new IllegalArgumentException("Empty BlockList");
            }
        }

        @Override
        public int size() {
            return 0;
        }
    };

    public BlockList(Creator<? extends T> creator) {
        this.mCreator = creator;
    }

    public BlockList() {
        this(null);
    }

    public Creator<? extends T> getCreator() {
        return this.mCreator;
    }

    public void setCreator(Creator<? extends T> creator) {
        this.mCreator = creator;
        if (this.mItems.isImmutableEmpty()) {
            return;
        }
        this.updateCreator();
    }

    public void ensureSize(int size) {
        if (size > this.size()) {
            this.setSize(size);
        }
    }

    public void setSize(int size) {
        this.setSize(size, false);
    }

    public void setSize(int size, boolean notify) {
        if (size == 0 && !notify) {
            this.lockList();
        } else if (this.mCreator != null || size < this.size()) {
            this.unlockList();
            this.mItems.setSize(size, notify);
            if (size == 0) {
                this.lockList();
            }
        }
    }

    public void setElements(T[] elements) {
        if (elements == null || elements.length == 0) {
            this.lockList();
            return;
        }
        this.unlockList();
        Creator<T> creator = this.getCreator();
        int length = elements.length;
        for (int i = 0; i < length; ++i) {
            T item = elements[i];
            if (item == null && creator != null) {
                elements[i] = item = creator.newInstanceAt(i);
            }
            this.onItemCreated(i, item);
        }
        this.mItems.setElements(elements);
        this.onChanged();
    }

    void onItemCreated(int index, T item) {
        if (item == null) {
            return;
        }
        ((Block)item).setIndex(index);
        ((Block)item).setParent(this);
    }

    public T createAt(int index) {
        Creator<T> creator = this.getCreator();
        this.ensureSize(index);
        T item = creator.newInstanceAt(index);
        this.add(index, item);
        return item;
    }

    public T createNext() {
        Creator<T> creator = this.getCreator();
        T item = creator.newInstanceAt(this.size());
        this.add(item);
        return item;
    }

    public T getFirst() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            T item = this.get(i);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public T getLast() {
        int size;
        for (int i = size = this.size() - 1; i >= 0; --i) {
            T item = this.get(i);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public Iterator<T> clonedIterator() {
        return this.mItems.clonedIterator();
    }

    public Iterator<T> clonedIterator(int start) {
        return this.clonedIterator(start, this.size() - start);
    }

    public Iterator<T> clonedIterator(int start, int length) {
        return this.mItems.clonedIterator(start, length);
    }

    public Iterator<T> arrayIterator() {
        return this.mItems.arrayIterator();
    }

    public Iterator<T> iterator() {
        return this.mItems.iterator();
    }

    public Iterator<T> iterator(int start, int length) {
        return this.mItems.iterator(start, length);
    }

    public Iterator<T> iterator(Predicate<? super T> filter) {
        return this.mItems.iterator(filter);
    }

    public <T1> Iterator<T1> iterator(Class<T1> instance) {
        return this.mItems.iterator(instance);
    }

    public Iterator<T> reversedIterator() {
        return this.mItems.reversedIterator();
    }

    public int lastIndexOf(T item) {
        return this.mItems.lastIndexOf(item);
    }

    public int countIf(Predicate<? super T> predicate) {
        return this.mItems.count(predicate);
    }

    public int countFromLast(Predicate<? super T> predicate) {
        return this.mItems.countFromLast(predicate);
    }

    public ArrayCollection<T> subListIf(Predicate<? super T> predicate) {
        return this.mItems.subListIf(predicate);
    }

    public void clearChildes() {
        if (this.mItems.isEmpty()) {
            return;
        }
        Object lock = this.onRemoveRequestStarted();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.remove(this.size() - 1, false);
        }
        this.lockList();
        this.onChanged();
        this.onRemoveRequestCompleted(lock);
    }

    public void destroy() {
        this.mItems.clear();
        this.lockList();
        this.onChanged();
    }

    public boolean sort(Comparator<? super T> comparator) {
        if (this.size() < 2) {
            return false;
        }
        boolean sorted = this.mItems.sort(comparator, (int i, int j) -> {
            T item1 = this.get(i);
            T item2 = this.get(j);
            if (item1 != null) {
                ((Block)item1).setIndex(i);
            }
            if (item2 != null) {
                ((Block)item2).setIndex(j);
            }
        });
        if (sorted) {
            this.updateIndex();
        }
        return sorted;
    }

    public boolean sort(Comparator<? super T> comparator, Swappable swappable) {
        if (this.size() < 2) {
            return false;
        }
        if (this.mItems.sort(comparator, swappable)) {
            return this.updateIndex();
        }
        return false;
    }

    public boolean needsSort(Comparator<? super T> comparator) {
        if (comparator == null) {
            return false;
        }
        int length = this.size();
        if (length < 2) {
            return false;
        }
        T previous = this.get(0);
        for (int i = 1; i < length; ++i) {
            T item = this.get(i);
            if (comparator.compare(previous, item) > 0) {
                return true;
            }
            previous = item;
        }
        return false;
    }

    public boolean removeAll(Collection<?> collection) {
        return this.removeAllIndexes(this.toIndexArray(collection));
    }

    private int[] toIndexArray(Collection<?> collection) {
        int[] results = new int[collection.size()];
        int i = 0;
        ArrayCollection<T> items = this.mItems;
        int size = items.size();
        for (Object obj : collection) {
            Block block;
            int index;
            if (obj == null || (index = (block = (Block)obj).getIndex()) < 0 || index >= size || block != items.get(index)) continue;
            results[i] = index;
            ++i;
        }
        int length = results.length;
        while (i < length) {
            results[i] = -1;
            ++i;
        }
        return results;
    }

    public boolean removeAllIndexes(int[] indexes) {
        Object lock = this.onRemoveRequestStarted();
        this.mItems.removeAllIndexes(indexes);
        this.updateIndex();
        this.onRemoveRequestCompleted(lock);
        return true;
    }

    public boolean removeIf(Predicate<? super T> filter) {
        Object lock = this.onRemoveRequestStarted();
        boolean removed = this.mItems.removeIf(filter);
        if (removed) {
            this.updateIndex();
        }
        this.onRemoveRequestCompleted(lock);
        return removed;
    }

    public void trimLastIf(Predicate<? super T> predicate) {
        this.trimLastIf(0, predicate);
    }

    public void trimLastIf(int start, Predicate<? super T> predicate) {
        int i;
        int size = this.size();
        int end = i - this.mItems.countFromLast(start, predicate);
        for (i = size - 1; i > end; --i) {
            this.remove(i);
        }
    }

    public T remove(int index) {
        Object lock = this.onRemoveRequestStarted();
        T item = this.remove(index, true);
        this.onRemoveRequestCompleted(lock);
        return item;
    }

    private T remove(int index, boolean updateIndex) {
        Block item = (Block)this.mItems.remove(index);
        if (item == null) {
            return null;
        }
        item.setParent(null);
        item.setIndex(-1);
        if (updateIndex) {
            this.updateIndex(index);
        }
        this.onChanged();
        return (T)item;
    }

    public boolean remove(T item) {
        boolean removed;
        if (item == null) {
            return false;
        }
        int index = this.mItems.indexOfExact(item, ((Block)item).getIndex());
        if (index < 0) {
            index = this.mItems.indexOfExact(item);
        }
        if (index < 0) {
            return false;
        }
        Object lock = this.onRemoveRequestStarted();
        boolean bl = removed = this.mItems.remove(index) != null;
        if (removed) {
            this.updateIndex(index);
            ((Block)item).setIndex(-1);
            ((Block)item).setParent(null);
        }
        this.onChanged();
        this.onRemoveRequestCompleted(lock);
        return removed;
    }

    public int indexOf(T item) {
        if (item == null) {
            return -1;
        }
        int index = this.mItems.indexOfExact(item, ((Block)item).getIndex());
        if (index < 0) {
            index = this.mItems.indexOfExact(item);
        }
        return index;
    }

    protected void notifyPreRemove(T item) {
        if (item != null && ((Block)item).getParent() == this) {
            this.onPreRemove(item);
            ((Block)item).setIndex(-1);
            ((Block)item).setParent(null);
        }
    }

    public void onPreRemove(T item) {
    }

    protected Object onRemoveRequestStarted() {
        return null;
    }

    protected void onRemoveRequestCompleted(Object lock) {
    }

    @Override
    public boolean swap(int i, int j) {
        if (i == j) {
            return false;
        }
        return this.swap(this.get(i), this.get(j));
    }

    public boolean swap(T item1, T item2) {
        if (item1 == item2 || item1 == null || item2 == null) {
            return false;
        }
        int i1 = ((Block)item1).getIndex();
        int i2 = ((Block)item2).getIndex();
        this.mItems.swap(i1, i2);
        ((Block)item1).setIndex(i2);
        ((Block)item2).setIndex(i1);
        return true;
    }

    public void moveTo(T item, int index) {
        if (index < 0) {
            index = 0;
        }
        int i = this.mItems.indexOfExact(item, ((Block)item).getIndex());
        Object lock = this.onRemoveRequestStarted();
        this.mItems.move(item, index);
        this.updateIndex(i, index);
        this.onRemoveRequestCompleted(lock);
    }

    public boolean transferTo(T item, BlockList<? super T> destination) {
        if (item == null || destination == null || destination == this) {
            return false;
        }
        int i = this.mItems.indexOfExact(item, ((Block)item).getIndex());
        if (i < 0) {
            return false;
        }
        Object lock = this.onRemoveRequestStarted();
        this.mItems.removeSilent(i);
        boolean moved = destination.add(item);
        this.onRemoveRequestCompleted(lock);
        return moved;
    }

    public boolean transferTo(int index, BlockList<? super T> destination) {
        if (index < 0 || destination == null || destination == this) {
            return false;
        }
        Object lock = this.onRemoveRequestStarted();
        Block item = (Block)this.mItems.removeSilent(index);
        boolean moved = destination.add(item);
        this.onRemoveRequestCompleted(lock);
        return moved;
    }

    public void set(int index, T item) {
        if (item == null) {
            return;
        }
        this.unlockList();
        ((Block)item).setIndex(index);
        ((Block)item).setParent(this);
        this.mItems.set(index, item);
        this.onChanged();
    }

    public void addAll(int index, T[] items) {
        if (items == null) {
            return;
        }
        int length = items.length;
        if (length == 0) {
            return;
        }
        this.unlockList();
        this.mItems.addAll(index, items);
        for (int i = 0; i < length; ++i) {
            T item = items[i];
            if (item == null) continue;
            ((Block)item).setIndex(index);
            ((Block)item).setParent(this);
            ++index;
        }
        this.updateIndex(index);
        this.onChanged();
    }

    public void add(int index, T item) {
        if (item == null) {
            return;
        }
        this.unlockList();
        ((Block)item).setIndex(index);
        ((Block)item).setParent(this);
        this.mItems.add(index, item);
        this.updateIndex(index);
        this.onChanged();
    }

    private boolean updateIndex() {
        return this.updateIndex(0);
    }

    private boolean updateIndex(int start) {
        return this.updateIndex(start, this.size());
    }

    private boolean updateIndex(int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (start > end) {
            int i = start;
            start = end;
            end = i;
        }
        boolean changed = false;
        int count = this.size();
        if (++end > count) {
            end = count;
        }
        List<T> items = this.getChildes();
        for (int i = start; i < end; ++i) {
            Block item = (Block)items.get(i);
            if (item.getIndex() == i) continue;
            item.setIndex(i);
            changed = true;
        }
        return changed;
    }

    public boolean add(T item) {
        if (item == null) {
            return false;
        }
        this.unlockList();
        int index = this.size();
        ((Block)item).setIndex(index);
        ((Block)item).setParent(this);
        boolean result = this.mItems.add(item);
        this.onChanged();
        return result;
    }

    public T get(int i) {
        if (i >= this.mItems.size() || i < 0) {
            return null;
        }
        return (T)((Block)this.mItems.get(i));
    }

    public int getCount() {
        return this.size();
    }

    public int size() {
        return this.mItems.size();
    }

    public void ensureCapacity(int capacity) {
        this.unlockList();
        this.mItems.ensureCapacity(capacity);
    }

    public void trimToSize() {
        this.mItems.trimToSize();
        if (this.mItems.size() == 0) {
            this.lockList();
        }
    }

    public boolean contains(Object obj) {
        return this.mItems.contains(obj);
    }

    public boolean containsExact(Object obj) {
        return this.mItems.containsExact(obj);
    }

    public Object[] toArray() {
        return this.mItems.toArray();
    }

    public <T1> T1[] toArray(T1[] ts) {
        return this.mItems.toArray(ts);
    }

    public List<T> getChildes() {
        return this.mItems;
    }

    private void lockList() {
        if (this.mItems.isImmutableEmpty()) {
            return;
        }
        this.mItems = ArrayCollection.empty();
    }

    private void unlockList() {
        if (!this.mItems.isImmutableEmpty()) {
            return;
        }
        this.mItems = new ArrayCollection();
        this.updateCreator();
        this.mItems.setMonitor(this.getMonitor());
    }

    protected ArrayCollection.Monitor<T> getMonitor() {
        return new ArrayCollection.Monitor<T>(){

            @Override
            public void onAdd(int i, T item) {
            }

            @Override
            public void onRemoved(int i, T item) {
                BlockList.this.notifyPreRemove(item);
            }
        };
    }

    private void updateCreator() {
        Creator<T> creator = this.getCreator();
        if (creator == null) {
            this.mItems.setInitializer(null);
            return;
        }
        ArrayCollection.Initializer<Block> initializer = index -> {
            Object item = creator.newInstanceAt(index);
            this.onItemCreated(index, item);
            return item;
        };
        this.mItems.setInitializer(initializer);
    }

    @Override
    public final void refresh() {
        if (this.isNull()) {
            return;
        }
        this.trimToSize();
        this.onPreRefresh();
        this.refreshChildes();
        this.onRefreshed();
        this.onChanged();
    }

    protected void onPreRefresh() {
    }

    protected void onRefreshed() {
        this.onChanged();
    }

    public void onChanged() {
        this.mItems.onChanged();
    }

    protected void refreshChildes() {
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (!(item instanceof BlockRefresh)) continue;
            ((BlockRefresh)item).refresh();
        }
    }

    @Override
    public byte[] getBytes() {
        byte[] results = null;
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            results = BlockList.addBytes(results, ((Block)iterator.next()).getBytes());
        }
        return results;
    }

    @Override
    public int countBytes() {
        int result = 0;
        int size = this.size();
        if (size != 0) {
            if (this.hasSimilarEntries()) {
                result = size * ((Block)this.get(0)).countBytes();
            } else {
                for (int i = 0; i < size; ++i) {
                    result += ((Block)this.get(i)).countBytes();
                }
            }
        }
        return result;
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        if (counter.FOUND) {
            return;
        }
        counter.setCurrent(this);
        if (counter.END == this) {
            counter.FOUND = true;
            return;
        }
        if (this.skipIndividualCounting(counter)) {
            counter.addCount(this.countBytes());
            return;
        }
        int size = this.size();
        for (int i = 0; i < size && !counter.FOUND; ++i) {
            T item = this.get(i);
            if (item == null) continue;
            ((Block)item).onCountUpTo(counter);
        }
    }

    private boolean skipIndividualCounting(BlockCounter counter) {
        if (this.size() == 0) {
            return true;
        }
        if (counter instanceof BlockLocator) {
            return false;
        }
        Block end = counter.END;
        if (end == null) {
            return true;
        }
        if (!this.hasSimilarEntries()) {
            return false;
        }
        return this.get(0).getClass() != end.getClass();
    }

    protected boolean hasSimilarEntries() {
        return false;
    }

    public void readChildes(BlockReader reader) throws IOException {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            T item = this.get(i);
            ((Block)item).readBytes(reader);
        }
        this.onChanged();
    }

    @Override
    protected int onWriteBytes(OutputStream stream) throws IOException {
        int result = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            T item = this.get(i);
            if (item == null) continue;
            result += ((Block)item).writeBytes(stream);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockList blockList = (BlockList)obj;
        return this.mItems.equals(blockList.mItems);
    }

    public int hashCode() {
        return this.mItems.hashCode();
    }

    public String toString() {
        return "size=" + this.size();
    }

    public static boolean isImmutableEmpty(Object blockList) {
        return empty_list == blockList;
    }

    public static <T1 extends Block> BlockList<T1> empty() {
        return empty_list;
    }

    public static JSONArray toJsonArray(BlockList<? extends JSONConvert<?>> blockList) {
        int size = blockList.size();
        if (size == 0) {
            return null;
        }
        JSONArray jsonArray = new JSONArray(size);
        for (int i = 0; i < size; ++i) {
            jsonArray.put(i, blockList.get(i).toJson());
        }
        return jsonArray;
    }
}

