/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import com.reandroid.arsc.coder.ValueCoder;

public class XmlSanitizer {
    public static String escapeQuote(String text) {
        text = XmlSanitizer.quoteWhitespace(text);
        text = XmlSanitizer.escapeSpecialCharacter(text);
        return text;
    }

    public static String unEscapeUnQuote(String text) {
        if (text == null || text.length() < 2) {
            return text;
        }
        char first = text.charAt(0);
        if (first == '\"') {
            return XmlSanitizer.unQuoteWhitespace(text);
        }
        return XmlSanitizer.unEscapeSpecialCharacter(text);
    }

    public static String escapeSpecialCharacter(String text) {
        if (XmlSanitizer.shouldEscapeSpecial(text)) {
            text = '\\' + text;
        }
        return text;
    }

    public static String escapeDecodedValue(String text) {
        if (XmlSanitizer.shouldEscapeDecoded(text) || XmlSanitizer.shouldEscapeSpecial(text)) {
            text = '\\' + text;
        }
        return text;
    }

    public static String unEscapeSpecialCharacter(String text) {
        if (XmlSanitizer.shouldUnEscape(text)) {
            text = text.substring(1);
        }
        return text;
    }

    public static String quoteWhitespace(String text) {
        if (!XmlSanitizer.shouldQuote(text)) {
            return text;
        }
        return "\"" + text + "\"";
    }

    public static String unQuoteWhitespace(String text) {
        if (!XmlSanitizer.shouldUnQuote(text)) {
            return text;
        }
        return text.substring(1, text.length() - 1);
    }

    private static boolean shouldUnEscape(String text) {
        if (text == null || text.length() < 2) {
            return false;
        }
        if (text.charAt(0) != '\\') {
            return false;
        }
        return XmlSanitizer.isAlreadyEscaped(text, 1) || XmlSanitizer.looksDecoded(text, 1) || XmlSanitizer.startsWithSpecialCharacter(text, 1);
    }

    private static boolean shouldEscapeSpecial(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        return XmlSanitizer.isAlreadyEscaped(text, 0) || XmlSanitizer.startsWithSpecialCharacter(text, 0);
    }

    private static boolean shouldEscapeDecoded(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        return XmlSanitizer.looksDecoded(text, 0);
    }

    private static boolean isAlreadyEscaped(String text, int offset) {
        int len = text.length();
        if (len <= offset) {
            return false;
        }
        return text.charAt(offset) == '\\';
    }

    private static boolean looksDecoded(String text, int offset) {
        int len = text.length();
        if (len <= offset || len > 14) {
            return false;
        }
        if (!XmlSanitizer.looksNumber(text, offset) && !XmlSanitizer.isBoolean(text, offset)) {
            return false;
        }
        return ValueCoder.encode(text.substring(offset)) != null;
    }

    private static boolean isBoolean(String text, int offset) {
        return "true".equals(text = text.substring(offset)) || "false".equals(text);
    }

    private static boolean looksNumber(String text, int offset) {
        char ch = text.charAt(offset);
        if (XmlSanitizer.isNumber(ch)) {
            return true;
        }
        if (++offset == text.length() || ch != '-') {
            return false;
        }
        ch = text.charAt(offset);
        return XmlSanitizer.isNumber(ch);
    }

    private static boolean isNumber(char ch) {
        return ch <= '9' && ch >= '0';
    }

    private static boolean startsWithSpecialCharacter(String text, int offset) {
        if (text.length() < offset + 2) {
            return false;
        }
        return XmlSanitizer.isSpecialCharacter(text.charAt(offset));
    }

    private static boolean shouldUnQuote(String text) {
        if (text == null || text.length() < 3) {
            return false;
        }
        if (text.charAt(0) != '\"' || text.charAt(text.length() - 1) != '\"') {
            return false;
        }
        return XmlSanitizer.isWhiteSpace(text, 1) || XmlSanitizer.isQuotedWhiteSpace(text, 1);
    }

    private static boolean shouldQuote(String text) {
        if (text == null) {
            return false;
        }
        return XmlSanitizer.isWhiteSpace(text, 0) || XmlSanitizer.isQuotedWhiteSpace(text, 0);
    }

    private static boolean isQuotedWhiteSpace(String text, int offset) {
        if (text == null) {
            return false;
        }
        int len = text.length();
        if (len <= offset) {
            return false;
        }
        len = len - offset - 1;
        if (text.charAt(offset) != '\"') {
            return false;
        }
        if (text.charAt(len) != '\"') {
            return false;
        }
        return XmlSanitizer.isWhiteSpace(text, offset + 1);
    }

    private static boolean isWhiteSpace(String text, int offset) {
        if (text == null) {
            return false;
        }
        int len = text.length() - 1;
        if (len <= offset) {
            return false;
        }
        char[] chars = text.toCharArray();
        len = chars.length - offset;
        for (int i = offset; i < len; ++i) {
            if (XmlSanitizer.isWhiteSpace(chars[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhiteSpace(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private static boolean isSpecialCharacter(char ch) {
        switch (ch) {
            case '#': 
            case '?': 
            case '@': {
                return true;
            }
        }
        return false;
    }
}

