/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public class ThreeByteCharsetDecoder
extends CharsetDecoder {
    public static final ThreeByteCharsetDecoder INSTANCE = new ThreeByteCharsetDecoder();

    public ThreeByteCharsetDecoder() {
        super(StandardCharsets.UTF_8, 1.0f, 1.0f);
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
        return src.hasArray() && dst.hasArray() ? this.decodeArrayLoop(src, dst) : this.decodeBufferLoop(src, dst);
    }

    private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
        int start;
        byte[] srcBytes = src.array();
        int sourcePosition = src.arrayOffset() + src.position();
        int sourceLimit = src.arrayOffset() + src.limit();
        char[] dstChars = dst.array();
        int dstPosition = dst.arrayOffset() + dst.position();
        int dstLimit = dst.arrayOffset() + dst.limit();
        int min = dstLimit - dstPosition;
        if (min < (start = (min = sourceLimit - sourcePosition))) {
            start = min;
        }
        start = dstPosition + start;
        while (dstPosition < start && srcBytes[sourcePosition] >= 0) {
            dstChars[dstPosition++] = (char)srcBytes[sourcePosition++];
        }
        while (sourcePosition < sourceLimit) {
            byte b1 = srcBytes[sourcePosition];
            if (b1 < 0) {
                if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                    if (sourceLimit - sourcePosition < 2 || dstPosition >= dstLimit) {
                        return ThreeByteCharsetDecoder.xFlow(src, sourcePosition, sourceLimit, dst, dstPosition, 2);
                    }
                    byte b2 = srcBytes[sourcePosition + 1];
                    if (ThreeByteCharsetDecoder.isNotContinuation(b2)) {
                        return ThreeByteCharsetDecoder.malformedForLength(src, sourcePosition, dst, dstPosition);
                    }
                    dstChars[dstPosition++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                    sourcePosition += 2;
                    continue;
                }
                if (b1 >> 4 != -2) {
                    return ThreeByteCharsetDecoder.malformed(src, sourcePosition, dst, dstPosition, 1);
                }
                int srcRemaining = sourceLimit - sourcePosition;
                if (srcRemaining < 3 || dstPosition >= dstLimit) {
                    if (srcRemaining > 1 && ThreeByteCharsetDecoder.isMalformed3_2(b1, srcBytes[sourcePosition + 1])) {
                        return ThreeByteCharsetDecoder.malformedForLength(src, sourcePosition, dst, dstPosition);
                    }
                    return ThreeByteCharsetDecoder.xFlow(src, sourcePosition, sourceLimit, dst, dstPosition, 3);
                }
                byte b2 = srcBytes[sourcePosition + 1];
                byte b3 = srcBytes[sourcePosition + 2];
                if (ThreeByteCharsetDecoder.isMalformed3(b1, b2, b3)) {
                    return ThreeByteCharsetDecoder.malformed(src, sourcePosition, dst, dstPosition, 3);
                }
                dstChars[dstPosition++] = (char)(b1 << 12 ^ b2 << 6 ^ b3 ^ 0xFFFE1F80);
                sourcePosition += 3;
                continue;
            }
            if (dstPosition >= dstLimit) {
                return ThreeByteCharsetDecoder.xFlow(src, sourcePosition, sourceLimit, dst, dstPosition, 1);
            }
            dstChars[dstPosition++] = (char)b1;
            ++sourcePosition;
        }
        return ThreeByteCharsetDecoder.xFlow(src, sourcePosition, sourceLimit, dst, dstPosition, 0);
    }

    private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
        int mark = src.position();
        int limit = src.limit();
        while (mark < limit) {
            byte b1 = src.get();
            if (b1 < 0) {
                byte b3;
                if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                    if (limit - mark < 2 || dst.remaining() < 1) {
                        return ThreeByteCharsetDecoder.xFlow(src, mark, 2);
                    }
                    byte b2 = src.get();
                    if (ThreeByteCharsetDecoder.isNotContinuation(b2)) {
                        return ThreeByteCharsetDecoder.malformedForLength(src, mark);
                    }
                    dst.put((char)(b1 << 6 ^ b2 ^ 0xF80));
                    mark += 2;
                    continue;
                }
                if (b1 >> 4 != -2) {
                    return ThreeByteCharsetDecoder.malformed(src, mark, 1);
                }
                int srcRemaining = limit - mark;
                if (srcRemaining < 3 || dst.remaining() < 1) {
                    if (srcRemaining > 1 && ThreeByteCharsetDecoder.isMalformed3_2(b1, src.get())) {
                        return ThreeByteCharsetDecoder.malformedForLength(src, mark);
                    }
                    return ThreeByteCharsetDecoder.xFlow(src, mark, 3);
                }
                byte b2 = src.get();
                if (ThreeByteCharsetDecoder.isMalformed3(b1, b2, b3 = src.get())) {
                    return ThreeByteCharsetDecoder.malformed(src, mark, 3);
                }
                dst.put((char)(b1 << 12 ^ b2 << 6 ^ b3 ^ 0xFFFE1F80));
                mark += 3;
                continue;
            }
            if (dst.remaining() < 1) {
                return ThreeByteCharsetDecoder.xFlow(src, mark, 1);
            }
            dst.put((char)b1);
            ++mark;
        }
        return ThreeByteCharsetDecoder.xFlow(src, mark, 0);
    }

    private static void updatePositions(Buffer src, int sourcePosition, Buffer dst, int dstPosition) {
        src.position(sourcePosition - src.arrayOffset());
        dst.position(dstPosition - dst.arrayOffset());
    }

    private static boolean isNotContinuation(int b) {
        return (b & 0xC0) != 128;
    }

    private static boolean isMalformed3(int b1, int b2, int b3) {
        return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128;
    }

    private static boolean isMalformed3_2(int b1, int b2) {
        return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128;
    }

    private static CoderResult malformedN(ByteBuffer src, int nb) {
        switch (nb) {
            case 1: 
            case 2: {
                return CoderResult.malformedForLength(1);
            }
            case 3: {
                byte b1 = src.get();
                byte b2 = src.get();
                return CoderResult.malformedForLength((b1 != -32 || (b2 & 0xE0) != 128) && !ThreeByteCharsetDecoder.isNotContinuation(b2) ? 2 : 1);
            }
            case 4: {
                int b1 = src.get() & 0xFF;
                int b2 = src.get() & 0xFF;
                if (!(b1 > 244 || b1 == 240 && (b2 < 144 || b2 > 191) || b1 == 244 && (b2 & 0xF0) != 128 || ThreeByteCharsetDecoder.isNotContinuation(b2))) {
                    if (ThreeByteCharsetDecoder.isNotContinuation(src.get())) {
                        return CoderResult.malformedForLength(2);
                    }
                    return CoderResult.malformedForLength(3);
                }
                return CoderResult.malformedForLength(1);
            }
        }
        return null;
    }

    private static CoderResult malformed(ByteBuffer src, int sourcePosition, CharBuffer dst, int dstPosition, int numBytes) {
        src.position(sourcePosition - src.arrayOffset());
        CoderResult cr = ThreeByteCharsetDecoder.malformedN(src, numBytes);
        ThreeByteCharsetDecoder.updatePositions(src, sourcePosition, dst, dstPosition);
        return cr;
    }

    private static CoderResult malformed(ByteBuffer src, int mark, int nb) {
        src.position(mark);
        CoderResult cr = ThreeByteCharsetDecoder.malformedN(src, nb);
        src.position(mark);
        return cr;
    }

    private static CoderResult malformedForLength(ByteBuffer src, int sourcePosition, CharBuffer dst, int dstPosition) {
        ThreeByteCharsetDecoder.updatePositions(src, sourcePosition, dst, dstPosition);
        return CoderResult.malformedForLength(1);
    }

    private static CoderResult malformedForLength(ByteBuffer src, int mark) {
        src.position(mark);
        return CoderResult.malformedForLength(1);
    }

    private static CoderResult xFlow(Buffer src, int sourcePosition, int sourceLimit, Buffer dst, int dstPosition, int numBytes) {
        ThreeByteCharsetDecoder.updatePositions(src, sourcePosition, dst, dstPosition);
        return numBytes != 0 && sourceLimit - sourcePosition >= numBytes ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW;
    }

    private static CoderResult xFlow(Buffer src, int mark, int nb) {
        src.position(mark);
        return nb != 0 && src.remaining() >= nb ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW;
    }
}

