/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import com.reandroid.arsc.coder.Coder;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.value.ValueType;

public class CoderInteger
extends Coder {
    public static final CoderInteger INS = new CoderInteger();

    @Override
    public EncodeResult encode(String text) {
        int i = text.indexOf(46);
        if (i < 0) {
            i = text.indexOf(120);
        }
        if (i >= 0) {
            return null;
        }
        Integer integer = CoderInteger.parseInteger(text);
        if (integer == null) {
            return null;
        }
        return new EncodeResult(ValueType.DEC, integer);
    }

    @Override
    public String decode(int data) {
        return Integer.toString(data);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.DEC;
    }

    @Override
    boolean canStartWith(char first) {
        return CoderInteger.isNumberStart(first);
    }
}

