/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import android.content.res.XmlResourceParser;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlEvent;
import com.reandroid.arsc.chunk.xml.ResXmlEventParser;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.utils.StringsUtil;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParserException;

public class ResXmlPullParser
extends ResXmlEventParser
implements XmlResourceParser {
    public ResXmlPullParser(Iterator<ResXmlEvent> eventIterator) {
        super(eventIterator);
    }

    public ResXmlPullParser(ResXmlNode xmlNode) {
        this(xmlNode.getParserEvents());
    }

    @Override
    public void close() {
    }

    @Override
    public int getAttributeNameResource(int index) {
        ResXmlAttribute attribute = this.getResXmlAttributeAt(index);
        if (attribute != null) {
            return attribute.getNameId();
        }
        return 0;
    }

    @Override
    public boolean getAttributeBooleanValue(String namespace, String attribute, boolean defaultValue) {
        ResXmlAttribute xmlAttribute = this.getAttribute(namespace, attribute);
        if (xmlAttribute != null) {
            int v = this.getAttributeIntValue(xmlAttribute, 0);
            return v != 0;
        }
        return defaultValue;
    }

    @Override
    public int getAttributeResourceValue(String namespace, String attribute, int defaultValue) {
        ResXmlAttribute xmlAttribute = this.getAttribute(namespace, attribute);
        if (xmlAttribute != null && xmlAttribute.getValueType() == ValueType.REFERENCE) {
            return xmlAttribute.getData();
        }
        return defaultValue;
    }

    @Override
    public int getAttributeIntValue(String namespace, String attribute, int defaultValue) {
        return this.getAttributeIntValue(this.getAttribute(namespace, attribute), defaultValue);
    }

    @Override
    public int getAttributeUnsignedIntValue(String namespace, String attribute, int defaultValue) {
        return this.getAttributeIntValue(this.getAttribute(namespace, attribute), defaultValue);
    }

    @Override
    public float getAttributeFloatValue(String namespace, String attribute, float defaultValue) {
        ValueType valueType;
        ResXmlAttribute xmlAttribute = this.getAttribute(namespace, attribute);
        if (xmlAttribute != null && (valueType = xmlAttribute.getValueType()) == ValueType.FLOAT) {
            return Float.intBitsToFloat(xmlAttribute.getData());
        }
        return defaultValue;
    }

    @Override
    public int getAttributeListValue(int index, String[] options, int defaultValue) {
        ResXmlAttribute xmlAttribute = this.getResXmlAttributeAt(index);
        if (xmlAttribute == null || xmlAttribute.getValueType() != ValueType.STRING || options == null || options.length == 0) {
            return defaultValue;
        }
        return this.convertValueToList(xmlAttribute.getValueAsString(), options, defaultValue);
    }

    @Override
    public int getAttributeListValue(String namespace, String attribute, String[] options, int defaultValue) {
        ResXmlAttribute xmlAttribute = this.getAttribute(namespace, attribute);
        if (xmlAttribute == null || xmlAttribute.getValueType() != ValueType.STRING || options == null || options.length == 0) {
            return defaultValue;
        }
        return this.convertValueToList(xmlAttribute.getValueAsString(), options, defaultValue);
    }

    @Override
    public boolean getAttributeBooleanValue(int index, boolean defaultValue) {
        ResXmlAttribute xmlAttribute = this.getResXmlAttributeAt(index);
        if (xmlAttribute != null) {
            int v = this.getAttributeIntValue(xmlAttribute, 0);
            return v != 0;
        }
        return defaultValue;
    }

    @Override
    public int getAttributeResourceValue(int index, int defaultValue) {
        ResXmlAttribute xmlAttribute = this.getResXmlAttributeAt(index);
        if (xmlAttribute != null && xmlAttribute.getValueType() == ValueType.REFERENCE) {
            return xmlAttribute.getData();
        }
        return defaultValue;
    }

    @Override
    public int getAttributeIntValue(int index, int defaultValue) {
        return this.getAttributeIntValue(this.getResXmlAttributeAt(index), defaultValue);
    }

    @Override
    public int getAttributeUnsignedIntValue(int index, int defaultValue) {
        return this.getAttributeIntValue(this.getResXmlAttributeAt(index), defaultValue);
    }

    @Override
    public float getAttributeFloatValue(int index, float defaultValue) {
        ResXmlAttribute xmlAttribute = this.getResXmlAttributeAt(index);
        if (xmlAttribute != null && xmlAttribute.getValueType() == ValueType.FLOAT) {
            return Float.intBitsToFloat(xmlAttribute.getData());
        }
        return defaultValue;
    }

    @Override
    public String getIdAttribute() {
        ResXmlAttribute attribute;
        ResXmlElement currentElement = this.getCurrentElement();
        if (currentElement != null && (attribute = currentElement.getIdAttribute()) != null) {
            return attribute.getName();
        }
        return null;
    }

    @Override
    public String getClassAttribute() {
        ResXmlAttribute attribute;
        ResXmlElement currentElement = this.getCurrentElement();
        if (currentElement != null && (attribute = currentElement.getClassAttribute()) != null) {
            return attribute.getName();
        }
        return null;
    }

    @Override
    public int getIdAttributeResourceValue(int defaultValue) {
        ResXmlAttribute attribute;
        ResXmlElement currentElement = this.getCurrentElement();
        if (currentElement != null && (attribute = currentElement.getIdAttribute()) != null) {
            return attribute.getNameId();
        }
        return defaultValue;
    }

    @Override
    public int getStyleAttribute() {
        ResXmlAttribute attribute;
        ResXmlElement currentElement = this.getCurrentElement();
        if (currentElement != null && (attribute = currentElement.getStyleAttribute()) != null) {
            return attribute.getNameId();
        }
        return 0;
    }

    @Override
    public void setInput(Reader in) throws XmlPullParserException {
        throw new XmlPullParserException("Unsupported operation");
    }

    @Override
    public void setInput(InputStream inputStream, String inputEncoding) throws XmlPullParserException {
        throw new XmlPullParserException("Unsupported operation");
    }

    private int convertValueToList(String value, String[] options, int defaultValue) {
        if (!StringsUtil.isEmpty(value)) {
            for (int i = 0; i < options.length; ++i) {
                if (!value.equals(options[i])) continue;
                return i;
            }
        }
        return defaultValue;
    }

    private int getAttributeIntValue(ResXmlAttribute xmlAttribute, int defaultValue) {
        int type;
        if (xmlAttribute != null && (type = xmlAttribute.getType() & 0xFF) > 16 && type <= 31) {
            return xmlAttribute.getData();
        }
        return defaultValue;
    }
}

