/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.BaseXmlChunk;
import com.reandroid.arsc.chunk.xml.ResXmlNamespace;
import com.reandroid.arsc.item.ResXmlString;

abstract class ResXmlNamespaceChunk
extends BaseXmlChunk
implements ResXmlNamespace {
    ResXmlNamespaceChunk(ChunkType chunkType) {
        super(chunkType, 0);
    }

    @Override
    public String getUri() {
        return this.getString(this.getUriReference());
    }

    @Override
    public void setUri(String uri) {
        int reference;
        if (uri == null) {
            reference = NULL_REFERENCE;
        } else {
            ResXmlString xmlString = this.getOrCreateString(uri);
            if (xmlString == null) {
                throw new IllegalArgumentException("Null ResXmlString, add to parent element first");
            }
            reference = xmlString.getIndex();
        }
        this.setUriReference(reference);
    }

    @Override
    public String getPrefix() {
        return this.getString(this.getPrefixReference());
    }

    @Override
    public void setPrefix(String prefix) {
        int reference;
        if (prefix == null) {
            reference = NULL_REFERENCE;
        } else {
            ResXmlString xmlString = null;
            ResXmlString uriString = this.getResXmlString(this.getUriReference());
            if (uriString != null) {
                xmlString = uriString.getNamespacePrefix();
            }
            if (xmlString == null) {
                xmlString = this.getOrCreateString(prefix);
            }
            if (xmlString == null) {
                throw new IllegalArgumentException("Null ResXmlString, add to parent element first");
            }
            reference = xmlString.getIndex();
        }
        this.setPrefixReference(reference);
    }

    @Override
    public int getUriReference() {
        return this.getStringReference();
    }

    void setUriReference(int uriReference) {
        int oldReference = this.getUriReference();
        this.setStringReference(uriReference);
        if (oldReference != uriReference) {
            this.onUriReferenceChanged(uriReference);
        }
    }

    void onUriReferenceChanged(int uriReference) {
    }

    public int getPrefixReference() {
        return this.getNamespaceReference();
    }

    public void setPrefixReference(int prefixReference) {
        this.setNamespaceReference(prefixReference);
    }

    @Override
    public void setLineNumber(int lineNumber) {
        super.setLineNumber(lineNumber);
    }

    public boolean isRemoved() {
        return this.getParent() == null;
    }

    @Override
    public boolean isUnused() {
        return this.isRemoved();
    }

    @Override
    public String toString() {
        return "xmlns:" + this.getPrefix() + "=\"" + this.getUri() + "\"";
    }
}

