/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.UnknownChunk;
import com.reandroid.arsc.chunk.xml.ResXmlElementChunk;
import com.reandroid.arsc.chunk.xml.ResXmlEndNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlStartNamespace;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.utils.collection.ArrayCollection;
import java.io.IOException;

class ElementChunkReader {
    private final ResXmlElementChunk elementChunk;
    private ArrayCollection<ResXmlEndNamespace> endNamespaceStack;
    private boolean startElementRead = false;
    private boolean endElementRead = false;

    public ElementChunkReader(ResXmlElementChunk elementChunk) {
        this.elementChunk = elementChunk;
        this.endNamespaceStack = new ArrayCollection();
    }

    public void read(BlockReader reader) throws IOException {
        Block block;
        while (reader.isAvailable() && (block = this.getNext(reader.readHeaderBlock())) != null) {
            block.readBytes(reader);
        }
    }

    private Block getNext(HeaderBlock headerBlock) throws IOException {
        if (!this.startElementRead) {
            return this.onElementNotStarted(headerBlock);
        }
        if (!this.endElementRead) {
            return this.onElementNotEnded(headerBlock);
        }
        return this.onElementEnded(headerBlock);
    }

    private Block onElementNotStarted(HeaderBlock headerBlock) throws IOException {
        ChunkType chunkType = headerBlock.getChunkType();
        if (chunkType == ChunkType.XML_START_ELEMENT) {
            this.startElementRead = true;
            return this.elementChunk.getStartElement();
        }
        if (chunkType == ChunkType.XML_END_ELEMENT) {
            throw new IOException("END element detected before START: " + headerBlock);
        }
        if (chunkType == ChunkType.XML_START_NAMESPACE) {
            return this.newNamespace();
        }
        if (chunkType == ChunkType.XML_END_NAMESPACE) {
            ResXmlEndNamespace endNamespace = this.pickEndNamespace();
            if (endNamespace == null) {
                this.startElementRead = true;
                this.endElementRead = true;
                return this.newDiscardingChunk();
            }
            return endNamespace;
        }
        if (chunkType == ChunkType.XML_CDATA) {
            return this.elementChunk.element().getParentNode().newText();
        }
        throw new IOException("Unexpected chunk: " + headerBlock);
    }

    private Block onElementNotEnded(HeaderBlock headerBlock) {
        ChunkType chunkType = headerBlock.getChunkType();
        if (chunkType == ChunkType.XML_END_ELEMENT) {
            this.endElementRead = true;
            return this.elementChunk.getEndElement();
        }
        if (chunkType == ChunkType.XML_END_NAMESPACE) {
            ResXmlEndNamespace endNamespace = this.pickEndNamespace();
            if (endNamespace == null) {
                return this.newDiscardingChunk();
            }
            return endNamespace;
        }
        if (chunkType == ChunkType.XML_START_ELEMENT || chunkType == ChunkType.XML_START_NAMESPACE) {
            return this.elementChunk.element().newElement();
        }
        if (chunkType == ChunkType.XML_CDATA) {
            return this.elementChunk.element().newText();
        }
        if (chunkType == ChunkType.XML) {
            return this.elementChunk.element().newDocument();
        }
        return this.elementChunk.element().newUnknown();
    }

    private Block onElementEnded(HeaderBlock headerBlock) {
        if (!this.hasEndNamespaceStack()) {
            return null;
        }
        ChunkType chunkType = headerBlock.getChunkType();
        if (chunkType == ChunkType.XML_END_NAMESPACE) {
            return this.pickEndNamespace();
        }
        return null;
    }

    private Block newDiscardingChunk() {
        return new UnknownChunk();
    }

    private ResXmlStartNamespace newNamespace() {
        ResXmlStartNamespace startNamespace = this.elementChunk.getStartNamespaceList().createNext();
        this.putEndNamespace(startNamespace.getEnd());
        return startNamespace;
    }

    private boolean hasEndNamespaceStack() {
        ArrayCollection<ResXmlEndNamespace> stack = this.endNamespaceStack;
        return stack != null && !stack.isEmpty();
    }

    private ResXmlEndNamespace pickEndNamespace() {
        ArrayCollection<ResXmlEndNamespace> stack = this.endNamespaceStack;
        if (stack != null && !stack.isEmpty()) {
            return stack.remove(stack.size() - 1);
        }
        return null;
    }

    private void putEndNamespace(ResXmlEndNamespace endNamespace) {
        ArrayCollection<ResXmlEndNamespace> stack = this.endNamespaceStack;
        if (stack == null) {
            this.endNamespaceStack = stack = new ArrayCollection();
        }
        stack.add(endNamespace);
    }
}

