/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.PolicyFlag;
import com.reandroid.arsc.chunk.PolicyItem;
import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.header.OverlayablePolicyHeader;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class OverlayablePolicy
extends Chunk<OverlayablePolicyHeader>
implements Iterable<PolicyItem>,
JSONConvert<JSONObject> {
    private final CountedBlockList<PolicyItem> itemList = new CountedBlockList<PolicyItem>(CREATOR, ((OverlayablePolicyHeader)this.getHeaderBlock()).getEntryCount());
    private static final Creator<PolicyItem> CREATOR = PolicyItem::new;
    public static final String NAME_flags = "flags";
    public static final String NAME_references = "references";
    public static final String TAG_policy = ObjectsUtil.of("policy");

    public OverlayablePolicy() {
        super(new OverlayablePolicyHeader(), 1);
        this.addChild(this.itemList);
    }

    public PolicyItem get(int i) {
        return (PolicyItem)this.getItemList().get(i);
    }

    public void add(PolicyItem policyItem) {
        this.getItemList().add(policyItem);
    }

    public PolicyItem createNext() {
        return (PolicyItem)this.getItemList().createNext();
    }

    @Override
    public Iterator<PolicyItem> iterator() {
        return this.itemList.iterator();
    }

    @Override
    public boolean isNull() {
        return this.getReferenceCount() == 0;
    }

    public int getReferenceCount() {
        return this.itemList.size();
    }

    public int getFlags() {
        return ((OverlayablePolicyHeader)this.getHeaderBlock()).getFlags().get();
    }

    public void setFlags(int flags) {
        ((OverlayablePolicyHeader)this.getHeaderBlock()).getFlags().set(flags);
    }

    public void setFlags(PolicyFlag[] policyFlags) {
        this.setFlags(PolicyFlag.sum(policyFlags));
    }

    public void addFlag(PolicyFlag policyFlag) {
        int i = policyFlag == null ? 0 : policyFlag.flag();
        this.setFlags(this.getFlags() | i);
    }

    public PolicyFlag[] getPolicyFlags() {
        return PolicyFlag.valuesOf(this.getFlags());
    }

    public CountedBlockList<PolicyItem> getItemList() {
        return this.itemList;
    }

    @Override
    protected void onChunkRefreshed() {
    }

    public void parse(XmlPullParser parser) throws IOException, XmlPullParserException {
        if (parser.getEventType() != 2) {
            throw new XmlPullParserException("Parser not in START_TAG event: " + parser.getEventType());
        }
        if (!TAG_policy.equals(parser.getName())) {
            throw new XmlPullParserException("Expecting tag '" + TAG_policy + "', but found '" + parser.getName() + "'");
        }
        this.setFlags(PolicyFlag.parse(parser));
        parser.next();
        XMLUtil.ensureTag(parser);
        while (parser.getEventType() != 3 && parser.getEventType() != 1) {
            PolicyItem policyItem = this.createNext();
            policyItem.parse(parser);
            XMLUtil.ensureTag(parser);
        }
        if (parser.getEventType() == 3) {
            parser.next();
        }
    }

    public void serialize(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, TAG_policy);
        String flags = PolicyFlag.toString(this.getPolicyFlags());
        if (!StringsUtil.isEmpty(flags)) {
            serializer.attribute(null, "type", flags);
        }
        for (PolicyItem reference : this) {
            reference.serialize(serializer);
        }
        serializer.endTag(null, TAG_policy);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME_flags, this.getFlags());
        JSONArray jsonArray = new JSONArray();
        for (PolicyItem reference : this) {
            jsonArray.put(reference.get());
        }
        jsonObject.put(NAME_references, jsonArray);
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setFlags(json.getInt(NAME_flags));
        JSONArray jsonArray = json.getJSONArray(NAME_references);
        int length = jsonArray.length();
        CountedBlockList<PolicyItem> referenceList = this.getItemList();
        referenceList.setSize(length);
        for (int i = 0; i < length; ++i) {
            PolicyItem ref = (PolicyItem)referenceList.get(i);
            ref.set(jsonArray.getInt(i));
        }
    }

    public void merge(OverlayablePolicy policy) {
        if (policy == null || policy == this) {
            return;
        }
        this.setFlags(this.getFlags() | policy.getFlags());
        CountedBlockList<PolicyItem> exist = this.getItemList();
        Iterator iterator = policy.getItemList().iterator();
        while (iterator.hasNext()) {
            PolicyItem coming = (PolicyItem)iterator.next();
            if (exist.contains(coming)) continue;
            PolicyItem reference = new PolicyItem();
            reference.set(coming.get());
            exist.add(reference);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": flags=" + PolicyFlag.toString(this.getPolicyFlags()) + "', count=" + this.getReferenceCount();
    }
}

