/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.base.BlockArray;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.SpecBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.header.TypeHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.collection.ComputeIterator;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TypeBlockArray
extends BlockArray<TypeBlock>
implements JSONConvert<JSONArray>,
Comparator<TypeBlock> {
    private byte mTypeId;
    private Boolean mHasComplexEntry;
    private Map<String, TypeBlock> mQualifiersMap;

    public Boolean hasComplexEntry() {
        if (this.mHasComplexEntry != null) {
            return this.mHasComplexEntry;
        }
        for (TypeBlock typeBlock : this.listItems(true)) {
            Boolean hasComplex = typeBlock.getEntryArray().hasComplexEntry();
            if (hasComplex == null) continue;
            this.mHasComplexEntry = hasComplex;
        }
        return this.mHasComplexEntry;
    }

    @Override
    public void destroy() {
        for (TypeBlock typeBlock : this.listItems()) {
            if (typeBlock == null) continue;
            typeBlock.destroy();
        }
        this.clear();
    }

    public void sort() {
        this.sort(this);
    }

    public boolean removeNullEntries(int startId) {
        boolean result = true;
        for (TypeBlock typeBlock : this.listItems()) {
            boolean removed = typeBlock.removeNullEntries(startId);
            result = result && removed;
        }
        return result;
    }

    public void removeEmptyBlocks() {
        this.removeIf(TypeBlock::isEmpty);
    }

    public Entry getOrCreateEntry(short entryId, String qualifiers) {
        TypeBlock typeBlock = this.getOrCreate(qualifiers);
        return typeBlock.getOrCreateEntry(entryId);
    }

    public Entry getOrCreateEntry(short entryId, ResConfig resConfig) {
        TypeBlock typeBlock = this.getOrCreate(resConfig);
        return typeBlock.getOrCreateEntry(entryId);
    }

    public boolean isEmpty() {
        for (TypeBlock typeBlock : this.listItems()) {
            if (typeBlock == null || typeBlock.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Entry getEntry(short entryId, String qualifiers) {
        TypeBlock typeBlock = this.getTypeBlock(qualifiers);
        if (typeBlock == null) {
            return null;
        }
        return typeBlock.getEntry(entryId);
    }

    public Entry getEntry(ResConfig resConfig, String entryName) {
        TypeBlock typeBlock = this.getTypeBlock(resConfig);
        if (typeBlock != null) {
            return typeBlock.getEntry(entryName);
        }
        return null;
    }

    public Entry getEntry(ResConfig resConfig, int entryId) {
        TypeBlock typeBlock = this.getTypeBlock(resConfig);
        if (typeBlock != null) {
            return typeBlock.getEntry(entryId);
        }
        return null;
    }

    public TypeBlock getOrCreate(ResConfig resConfig) {
        TypeBlock typeBlock = this.getTypeBlock(resConfig);
        if (typeBlock != null) {
            return typeBlock;
        }
        typeBlock = (TypeBlock)this.createNext();
        typeBlock.setId(this.getTypeId() & 0xFF);
        ResConfig config = typeBlock.getResConfig();
        config.copyFrom(resConfig);
        return typeBlock;
    }

    public TypeBlock getOrCreate(String qualifiers) {
        TypeBlock typeBlock = this.getTypeBlock(qualifiers);
        if (typeBlock != null) {
            return typeBlock;
        }
        int count = this.getHighestEntryCount();
        typeBlock = (TypeBlock)this.createNext();
        typeBlock.ensureEntriesCount(count);
        ResConfig config = typeBlock.getResConfig();
        config.parseQualifiers(qualifiers);
        return typeBlock;
    }

    public TypeBlock getTypeBlock(String qualifiers) {
        if (qualifiers == null) {
            return null;
        }
        TypeBlock typeBlock = this.getFromQualifiersMap(qualifiers);
        if (typeBlock != null) {
            return typeBlock;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            typeBlock = (TypeBlock)iterator.next();
            if (!typeBlock.getResConfig().isEqualQualifiers(qualifiers)) continue;
            return typeBlock;
        }
        return null;
    }

    private TypeBlock getFromQualifiersMap(String qualifiers) {
        Map<String, TypeBlock> map = this.mQualifiersMap;
        if (map == null) {
            this.buildQualifiersMap();
            map = this.mQualifiersMap;
            return map.get(qualifiers);
        }
        TypeBlock typeBlock = map.get(qualifiers);
        if (typeBlock != null && !qualifiers.equals(typeBlock.getQualifiers()) || typeBlock != null && typeBlock.getParent() == null) {
            this.buildQualifiersMap();
            map = this.mQualifiersMap;
            typeBlock = map.get(qualifiers);
        }
        return typeBlock;
    }

    public TypeBlock getTypeBlock(ResConfig config) {
        if (config == null) {
            return null;
        }
        TypeBlock typeBlock = this.getFromQualifiersMap(config.getQualifiers());
        if (typeBlock != null) {
            return typeBlock;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            typeBlock = (TypeBlock)iterator.next();
            if (typeBlock == null || !config.equals(typeBlock.getResConfig())) continue;
            return typeBlock;
        }
        return null;
    }

    private void buildQualifiersMap() {
        HashMap<String, TypeBlock> map = new HashMap<String, TypeBlock>(this.size());
        this.mQualifiersMap = map;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            TypeBlock typeBlock = (TypeBlock)iterator.next();
            map.put(typeBlock.getQualifiers(), typeBlock);
        }
    }

    public void setTypeId(byte id) {
        this.mTypeId = id;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            TypeBlock typeBlock = (TypeBlock)iterator.next();
            typeBlock.setTypeId(id);
        }
    }

    public byte getTypeId() {
        byte id;
        SpecBlock specBlock = this.getSpecBlock();
        if (specBlock != null && (id = specBlock.getTypeId()) != 0) {
            return id;
        }
        if (this.mTypeId != 0) {
            return this.mTypeId;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            byte id2;
            TypeBlock typeBlock = (TypeBlock)iterator.next();
            if (typeBlock == null || (id2 = typeBlock.getTypeId()) == 0) continue;
            if (specBlock != null) {
                specBlock.setTypeId(id2);
            }
            this.mTypeId = id2;
            return id2;
        }
        return 0;
    }

    public Set<ResConfig> listResConfig() {
        HashSet<ResConfig> unique = new HashSet<ResConfig>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            TypeBlock typeBlock = (TypeBlock)iterator.next();
            unique.add(typeBlock.getResConfig());
        }
        return unique;
    }

    public Iterator<ResConfig> getResConfigs() {
        return new ComputeIterator<TypeBlock, ResConfig>(super.iterator(true), TypeBlock::getResConfig);
    }

    public Iterator<TypeBlock> iteratorNonEmpty() {
        return super.iterator((? super T typeBlock) -> {
            if (typeBlock == null || typeBlock.isNull()) {
                return false;
            }
            return !typeBlock.isEmpty();
        });
    }

    public Iterator<TypeBlock> iterator(ResConfig resConfig) {
        return this.iterator((? super T typeBlock) -> typeBlock.getResConfig().equals(resConfig));
    }

    public boolean hasDuplicateResConfig(boolean ignoreEmpty) {
        HashSet<Integer> uniqueHashSet = new HashSet<Integer>();
        Iterator<TypeBlock> itr = ignoreEmpty ? this.iteratorNonEmpty() : this.iterator(true);
        while (itr.hasNext()) {
            Integer hash = itr.next().getResConfig().hashCode();
            if (uniqueHashSet.contains(hash)) {
                return true;
            }
            uniqueHashSet.add(hash);
        }
        return false;
    }

    private SpecBlock getSpecBlock() {
        SpecTypePair parent = this.getParent(SpecTypePair.class);
        if (parent != null) {
            return parent.getSpecBlock();
        }
        return null;
    }

    @Override
    public TypeBlock newInstance() {
        byte id = this.getTypeId();
        TypeBlock typeBlock = new TypeBlock();
        typeBlock.setTypeId(id);
        return typeBlock;
    }

    @Override
    protected void onRefreshed() {
        this.mQualifiersMap = null;
    }

    @Override
    public void onChanged() {
        super.onChanged();
        this.mQualifiersMap = null;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        boolean readOk = true;
        while (readOk) {
            readOk = this.readTypeBlockArray(reader);
        }
        this.mQualifiersMap = null;
    }

    private boolean readTypeBlockArray(BlockReader reader) throws IOException {
        InfoHeader headerBlock = reader.readHeaderBlock();
        if (headerBlock == null) {
            return false;
        }
        ChunkType chunkType = headerBlock.getChunkType();
        if (chunkType != ChunkType.TYPE) {
            return false;
        }
        TypeHeader typeHeader = TypeHeader.read(reader);
        byte id = this.getTypeId();
        if (id != 0 && typeHeader.getId().get() != id) {
            return false;
        }
        int pos = reader.getPosition();
        TypeBlock typeBlock = (TypeBlock)this.createNext();
        typeBlock.readBytes(reader);
        return reader.getPosition() > pos;
    }

    public int getHighestEntryId() {
        int result = -1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            TypeBlock typeBlock = (TypeBlock)iterator.next();
            int high = typeBlock.getEntryArray().getHighestEntryId();
            if (high <= result) continue;
            result = high;
        }
        return result;
    }

    public int getHighestEntryCount() {
        int result = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            TypeBlock typeBlock = (TypeBlock)iterator.next();
            int count = typeBlock.getEntryArray().size();
            if (count <= result) continue;
            result = count;
        }
        return result;
    }

    public void setEntryCount(int count) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            TypeBlock typeBlock = (TypeBlock)iterator.next();
            if (typeBlock.isSparse()) continue;
            typeBlock.setEntryCount(count);
        }
    }

    public TypeString getTypeString() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            TypeBlock typeBlock = (TypeBlock)iterator.next();
            TypeString typeString = typeBlock.getTypeString();
            if (typeString == null) continue;
            return typeString;
        }
        return null;
    }

    @Override
    public JSONArray toJson() {
        int size = this.size();
        JSONArray jsonArray = new JSONArray(size);
        for (int i = 0; i < size; ++i) {
            JSONObject jsonObject = ((TypeBlock)this.get(i)).toJson();
            if (jsonObject == null) continue;
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        if (json != null) {
            int length = json.length();
            for (int i = 0; i < length; ++i) {
                ((TypeBlock)this.createNext()).fromJson(json.getJSONObject(i));
            }
        }
    }

    public void merge(TypeBlockArray typeBlockArray) {
        if (typeBlockArray != null && typeBlockArray != this) {
            int size = typeBlockArray.size();
            for (int i = 0; i < size; ++i) {
                TypeBlock typeBlock = (TypeBlock)typeBlockArray.get(i);
                TypeBlock exist = this.getOrCreate(typeBlock.getResConfig());
                exist.merge(typeBlock);
            }
        }
    }

    @Override
    public int compare(TypeBlock typeBlock1, TypeBlock typeBlock2) {
        return typeBlock1.compareTo(typeBlock2);
    }
}

