/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.array.OffsetArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockArray;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.io.BlockLoad;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.AlignItem;
import com.reandroid.arsc.item.IntegerReference;
import java.io.IOException;
import java.io.OutputStream;

public abstract class OffsetBlockArray<T extends Block>
extends BlockArray<T>
implements BlockLoad {
    private final OffsetArray mOffsetArray;
    private final IntegerReference startReference;
    private final IntegerReference countReference;
    private final AlignItem alignItem;

    public OffsetBlockArray(OffsetArray offsets, IntegerReference countReference, IntegerReference startReference) {
        this.mOffsetArray = offsets;
        this.countReference = countReference;
        this.startReference = startReference;
        this.alignItem = new AlignItem();
        if (countReference instanceof Block) {
            ((Block)((Object)countReference)).setBlockLoad(this);
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        super.clear();
        this.mOffsetArray.clear();
        this.startReference.set(0);
        this.countReference.set(0);
        this.alignItem.clear();
    }

    OffsetArray getOffsetArray() {
        return this.mOffsetArray;
    }

    protected AlignItem getAlignItem() {
        return this.alignItem;
    }

    @Override
    public int countBytes() {
        int result = super.countBytes();
        int alignSize = this.getAlignItem().countBytes();
        return result + alignSize;
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        super.onCountUpTo(counter);
        if (counter.FOUND) {
            return;
        }
        this.getAlignItem().onCountUpTo(counter);
    }

    @Override
    public byte[] getBytes() {
        byte[] results = super.getBytes();
        if (results == null) {
            return null;
        }
        byte[] alignBytes = this.alignItem.getBytes();
        results = OffsetBlockArray.addBytes(results, alignBytes);
        return results;
    }

    @Override
    public int onWriteBytes(OutputStream stream) throws IOException {
        int result = super.onWriteBytes(stream);
        if (result == 0) {
            return 0;
        }
        return result += this.alignItem.writeBytes(stream);
    }

    @Override
    protected void onRefreshed() {
        this.calculateOffsets();
        this.refreshCount();
        this.refreshStart();
        this.refreshAlignment(this.getAlignItem());
    }

    private void calculateOffsets() {
        int count = this.size();
        OffsetArray offsetArray = this.getOffsetArray();
        offsetArray.setSize(count);
        if (count == 0) {
            return;
        }
        int sum = 0;
        for (int i = 0; i < count; ++i) {
            int offset;
            Object item = this.get(i);
            if (item == null || ((Block)item).isNull()) {
                offset = -1;
            } else {
                offset = sum;
                sum += ((Block)item).countBytes();
            }
            offsetArray.setOffset(i, offset);
        }
    }

    public void refreshCountAndStart() {
        this.refreshCount();
        this.refreshStart();
    }

    public void refreshCount() {
        this.countReference.set(this.size());
    }

    private void refreshStart() {
        int count = this.size();
        if (count == 0) {
            this.startReference.set(0);
            this.alignItem.clear();
            return;
        }
        Block parent = this.getParent();
        if (parent == null) {
            return;
        }
        int start = parent.countUpTo(this);
        this.startReference.set(start);
    }

    void refreshAlignment(BlockReader reader, AlignItem alignItem) throws IOException {
        this.refreshAlignment(alignItem);
    }

    void refreshAlignment(AlignItem alignItem) {
        if (this.size() == 0) {
            alignItem.clear();
        } else {
            alignItem.align(this);
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int size = this.size();
        if (size == 0) {
            return;
        }
        int noEntry = -1;
        int[] offsetArray = this.mOffsetArray.getOffsets();
        int zeroPosition = this.getZeroPosition();
        reader.seek(zeroPosition);
        int maximumPosition = zeroPosition;
        for (int i = 0; i < size; ++i) {
            Object item = this.get(i);
            int offset = offsetArray[i];
            if (offset == noEntry) {
                ((Block)item).setNull(true);
                continue;
            }
            int itemStart = zeroPosition + offset;
            reader.seek(itemStart);
            ((Block)item).readBytes(reader);
            int position = reader.getPosition();
            if (position <= maximumPosition) continue;
            maximumPosition = position;
        }
        if (maximumPosition > 0) {
            reader.seek(maximumPosition);
            this.refreshAlignment(reader, this.getAlignItem());
        }
    }

    private int getZeroPosition() {
        int start = this.startReference.get();
        if (start < 0) {
            start = 0;
        }
        return start;
    }

    @Override
    public void onBlockLoaded(BlockReader reader, Block sender) throws IOException {
        if (sender == this.countReference) {
            int count = this.countReference.get();
            this.setSize(count);
            this.getOffsetArray().setSize(count);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(": size = ");
        int realCount = this.size();
        builder.append(realCount);
        int count = this.countReference.get();
        if (realCount != count) {
            builder.append(", sizeValue = ");
            builder.append(count);
        }
        builder.append(", start = ");
        builder.append(this.startReference.get());
        return builder.toString();
    }
}

