/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.base.BlockArray;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.AttributeType;
import com.reandroid.arsc.value.EntryHeaderMap;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import java.util.Comparator;
import java.util.Iterator;

public abstract class CompoundItemArray<T extends ResValueMap>
extends BlockArray<T>
implements JSONConvert<JSONArray>,
Comparator<ResValueMap> {
    public void sort() {
        super.sort(this);
        this.updateCountToHeader();
    }

    @Override
    public T createNext() {
        ResValueMap resValueMap = (ResValueMap)super.createNext();
        this.updateCountToHeader();
        return (T)resValueMap;
    }

    private void updateCountToHeader() {
        ((EntryHeaderMap)this.getParent(ResTableMapEntry.class).getHeader()).setValuesCount(this.size());
    }

    public AttributeDataFormat[] getFormats() {
        T formatsMap = this.getByType(AttributeType.FORMATS);
        if (formatsMap != null) {
            return AttributeDataFormat.decodeValueTypes(((ValueItem)formatsMap).getData() & 0xFF);
        }
        return null;
    }

    public boolean containsType(AttributeType attributeType) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ResValueMap valueMap = (ResValueMap)iterator.next();
            if (attributeType != valueMap.getAttributeType()) continue;
            return true;
        }
        return false;
    }

    public T getOrCreateType(AttributeType attributeType) {
        if (attributeType == null) {
            return null;
        }
        Object valueMap = this.getByType(attributeType);
        if (valueMap == null) {
            valueMap = this.createNext();
            ((ResValueMap)valueMap).setAttributeType(attributeType);
        }
        return valueMap;
    }

    public T getByType(AttributeType attributeType) {
        if (attributeType == null) {
            return null;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ResValueMap valueMap = (ResValueMap)iterator.next();
            if (attributeType != valueMap.getAttributeType()) continue;
            return (T)valueMap;
        }
        return null;
    }

    public T getByName(int name) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ResValueMap valueMap = (ResValueMap)iterator.next();
            if (valueMap == null || name != valueMap.getNameId()) continue;
            return (T)valueMap;
        }
        return null;
    }

    @Override
    protected void onPreRefresh() {
        this.updateCountToHeader();
    }

    @Override
    protected void onRefreshed() {
    }

    public void onRemoved() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((ResValueMap)iterator.next()).onRemoved();
        }
    }

    @Override
    public void clear() {
        this.onRemoved();
        super.clear();
    }

    @Override
    public JSONArray toJson() {
        JSONArray jsonArray = new JSONArray();
        if (this.isNull()) {
            return jsonArray;
        }
        Iterator iterator = this.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            ResValueMap item = (ResValueMap)iterator.next();
            jsonArray.put(i, item.toJson());
            ++i;
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        this.clear();
        if (json == null) {
            return;
        }
        int count = json.length();
        this.ensureSize(count);
        for (int i = 0; i < count; ++i) {
            ((ResValueMap)this.get(i)).fromJson(json.getJSONObject(i));
        }
        this.updateCountToHeader();
    }

    public void merge(CompoundItemArray<?> mapArray) {
        if (mapArray == null || mapArray == this) {
            return;
        }
        this.clear();
        int count = mapArray.size();
        this.ensureSize(count);
        for (int i = 0; i < count; ++i) {
            ((ResValueMap)this.get(i)).merge((ValueItem)mapArray.get(i));
        }
        this.updateCountToHeader();
    }

    public void mergeWithName(ResourceMergeOption mergeOption, CompoundItemArray<?> mapArray) {
        if (mapArray == null || mapArray == this) {
            return;
        }
        this.clear();
        int count = mapArray.size();
        this.ensureSize(count);
        for (int i = 0; i < count; ++i) {
            ((ResValueMap)this.get(i)).mergeWithName(mergeOption, (ValueItem)mapArray.get(i));
        }
        this.updateCountToHeader();
    }

    @Override
    public int compare(ResValueMap valueMap1, ResValueMap valueMap2) {
        if (valueMap1 == valueMap2) {
            return 0;
        }
        if (valueMap1 == null) {
            return 1;
        }
        return valueMap1.compareTo(valueMap2);
    }
}

