/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.writer;

import com.reandroid.archive.Archive;
import com.reandroid.archive.block.LocalFileHeader;
import com.reandroid.archive.block.ZipHeader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZipAligner {
    private final Map<Pattern, Integer> alignmentPatternMapDepreciated = new HashMap<Pattern, Integer>();
    private final Map<Predicate<String>, Integer> alignmentMap = new HashMap<Predicate<String>, Integer>();
    private int defaultAlignment;
    private static final int NO_ALIGNMENT = 1;
    private static final int ALIGNMENT_4 = 4;
    private static final int ALIGNMENT_PAGE_4KB = 4096;
    public static final Predicate<String> PREDICATE_NATIVE_LIBS = name -> name.startsWith("lib/") && name.endsWith(".so");

    public void setFileAlignment(Predicate<String> predicate, int alignment) {
        if (predicate == null) {
            return;
        }
        this.alignmentMap.remove(predicate);
        if (alignment > 1) {
            this.alignmentMap.put(predicate, alignment);
        }
    }

    @Deprecated
    public void setFileAlignment(Pattern patternFileName, int alignment) {
        if (patternFileName == null) {
            return;
        }
        this.alignmentPatternMapDepreciated.remove(patternFileName);
        if (alignment > 1) {
            this.alignmentPatternMapDepreciated.put(patternFileName, alignment);
        }
    }

    public void clearFileAlignment() {
        this.alignmentMap.clear();
        this.alignmentPatternMapDepreciated.clear();
    }

    public void setDefaultAlignment(int defaultAlignment) {
        if (defaultAlignment <= 0) {
            defaultAlignment = 1;
        }
        this.defaultAlignment = defaultAlignment;
    }

    public void align(long offset, LocalFileHeader lfh) {
        int padding;
        if (ZipHeader.isZip64Length(offset + lfh.getSize())) {
            return;
        }
        lfh.setZipAlign(0);
        lfh.updateDataDescriptor();
        if (lfh.getMethod() == Archive.DEFLATED) {
            padding = 0;
        } else {
            int alignment = this.getAlignment(lfh.getFileName());
            if (alignment == 1) {
                padding = 0;
            } else {
                long dataOffset = offset + (long)lfh.countBytes();
                padding = (int)(((long)alignment - dataOffset % (long)alignment) % (long)alignment);
            }
        }
        lfh.setZipAlign(padding);
    }

    private int getAlignment(String name) {
        int alignment;
        if (!this.alignmentMap.isEmpty()) {
            for (Map.Entry<Predicate<String>, Integer> entry : this.alignmentMap.entrySet()) {
                Predicate<String> predicate = entry.getKey();
                if (!predicate.test(name)) continue;
                return entry.getValue();
            }
        }
        if ((alignment = this.getAlignmentDepreciated(name)) != 0) {
            return alignment;
        }
        return this.defaultAlignment;
    }

    private int getAlignmentDepreciated(String name) {
        if (!this.alignmentPatternMapDepreciated.isEmpty()) {
            for (Map.Entry<Pattern, Integer> entry : this.alignmentPatternMapDepreciated.entrySet()) {
                Matcher matcher = entry.getKey().matcher(name);
                if (!matcher.matches()) continue;
                return entry.getValue();
            }
        }
        return 0;
    }

    public static ZipAligner apkAligner() {
        ZipAligner zipAligner = new ZipAligner();
        zipAligner.setDefaultAlignment(4);
        zipAligner.setFileAlignment(PREDICATE_NATIVE_LIBS, 4096);
        return zipAligner;
    }

    public static ZipAligner noAlignment() {
        ZipAligner zipAligner = new ZipAligner();
        zipAligner.setDefaultAlignment(1);
        return zipAligner;
    }
}

