/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.model;

import com.reandroid.archive.block.CentralEntryHeader;
import com.reandroid.archive.block.EndRecord;
import com.reandroid.archive.block.SignatureFooter;
import com.reandroid.archive.io.ZipInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class CentralFileDirectory {
    private List<CentralEntryHeader> headerList = new ArrayList<CentralEntryHeader>();
    private EndRecord endRecord;
    private SignatureFooter signatureFooter;

    public int count() {
        return this.headerList.size();
    }

    public List<CentralEntryHeader> getHeaderList() {
        return this.headerList;
    }

    public SignatureFooter getSignatureFooter() {
        return this.signatureFooter;
    }

    public EndRecord getEndRecord() {
        return this.endRecord;
    }

    public void visit(ZipInput zipInput) throws IOException {
        EndRecord endRecord = new EndRecord();
        endRecord.findEndRecord(zipInput);
        InputStream inputStream = zipInput.getInputStream(endRecord.getOffsetOfCentralDirectory(), endRecord.getLengthOfCentralDirectory());
        this.endRecord = endRecord;
        this.headerList = this.loadCentralFileHeaders(inputStream, endRecord.getTotalNumberOfDirectories());
        this.signatureFooter = this.tryFindSignatureFooter(zipInput, endRecord);
    }

    private List<CentralEntryHeader> loadCentralFileHeaders(InputStream inputStream, int capacity) throws IOException {
        ArrayList<CentralEntryHeader> headerList = new ArrayList<CentralEntryHeader>(capacity);
        CentralEntryHeader ceh = new CentralEntryHeader();
        ceh.readBytes(inputStream);
        while (ceh.isValidSignature()) {
            headerList.add(ceh);
            ceh = new CentralEntryHeader();
            ceh.readBytes(inputStream);
        }
        inputStream.close();
        return headerList;
    }

    private SignatureFooter tryFindSignatureFooter(ZipInput zipInput, EndRecord endRecord) throws IOException {
        long lenCd = endRecord.getLengthOfCentralDirectory();
        int endLength = endRecord.getTotalBytesCount();
        int length = 24;
        long offset = zipInput.getLength() - (long)endLength - lenCd - (long)length;
        if (offset < 0L) {
            return null;
        }
        InputStream inputStream = zipInput.getInputStream(offset, length);
        SignatureFooter signatureFooter = new SignatureFooter();
        signatureFooter.readBytes(inputStream);
        inputStream.close();
        if (signatureFooter.isValid()) {
            return signatureFooter;
        }
        return null;
    }
}

